/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.ICommonStateMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.MonitorException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.AttributeMonitorNode;
import com.sap.engine.library.monitor.impl0.MonitorTreeAlertEvent;
import com.sap.engine.library.monitor.impl0.MonitorTreeListenerRegistry;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;

public abstract class CommonStateMonitorNode
extends AttributeMonitorNode
implements ICommonStateMonitorNode {
    protected String m_state = null;
    private int alertMode = 1;
    private boolean explicitGreen = false;

    public CommonStateMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    public CommonStateMonitorNode(String name, boolean explicitGreen) throws InvalidNameException {
        super(name);
        this.explicitGreen = explicitGreen;
    }

    public String getState() {
        return this.m_state;
    }

    public void setAlertMode(int mode) throws IllegalArgumentException {
        if (mode != 1 && mode != 4 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("Unexpected mode (" + mode + ").");
        }
        this.alertMode = mode;
    }

    public int getAlertMode() {
        return this.alertMode;
    }

    public boolean isExplicitGreen() {
        return this.explicitGreen;
    }

    protected String buildXmlStructures() {
        return "";
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("state", this.m_state);
        result = result + "</attributes>";
        return result;
    }

    protected void setState(String state, int color) throws MonitorException {
        this.hasReportedValue = true;
        this.m_state = state;
        int oldColor = this.m_color;
        this.m_color = color;
        if (oldColor != this.m_color && this.m_color == 3) {
            this.alert();
        }
        this.m_lastChangeDate = System.currentTimeMillis();
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.reportStatus(this, state, color);
        }
    }

    private void alert() {
        MonitorTreeAlertEvent event = new MonitorTreeAlertEvent(this, "Warning");
        MonitorTreeListenerRegistry.getInstance().processAlert(event);
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return this.m_state;
        }
        return "No value has been reported yet";
    }
}

