/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.ICacheMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import java.io.Serializable;

public class CacheMonitorNode
extends PerformanceMonitorNode
implements ICacheMonitorNode {
    protected long m_currentUsage;
    protected long m_maxSize;
    protected long m_maxUsage;
    protected double m_currentUsageInPercent;
    protected double m_maxUsageInPercent;

    public CacheMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    public CacheMonitorNode(String name, long maxsize) throws InvalidNameException {
        super(name);
        this.m_maxSize = maxsize;
    }

    public void setMaxSize(long maxSize) {
        this.m_maxSize = maxSize;
        this.m_lastChangeDate = System.currentTimeMillis();
        this.calculatePercent();
    }

    public long getMaxSize() {
        return this.m_maxSize;
    }

    public void setCurrentUsage(long size) {
        this.m_currentUsage = size;
        this.m_lastChangeDate = System.currentTimeMillis();
        this.calculatePercent();
    }

    public long getCurrentUsage() {
        return this.m_currentUsage;
    }

    public double getCurrentUsageInPercent() {
        return this.m_currentUsageInPercent * 100.0;
    }

    public long getMaxUsage() {
        return this.m_maxUsage;
    }

    public double getMaxUsageInPercent() {
        return this.m_maxUsageInPercent * 100.0;
    }

    public int getTyp() {
        return 11;
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("currentUsage", this.m_currentUsage);
        result = result + AbstractMonitorNode.getAttributeString("maxSize", this.m_maxSize);
        result = result + AbstractMonitorNode.getAttributeString("currentUsageInPercent", this.m_currentUsageInPercent * 100.0);
        result = result + AbstractMonitorNode.getAttributeString("maxUsageInPercent", this.m_maxUsageInPercent * 100.0);
        result = result + "</attributes>";
        return result;
    }

    protected void calculatePercent() {
        if (this.m_currentUsage > this.m_maxUsage) {
            this.m_maxUsage = this.m_currentUsage;
        }
        if (this.m_maxSize == 0L) {
            this.m_currentUsageInPercent = 1.0;
            this.m_maxUsageInPercent = 1.0;
            return;
        }
        this.m_currentUsageInPercent = (double)this.m_currentUsage / (double)this.m_maxSize;
        if (this.m_currentUsageInPercent > this.m_maxUsageInPercent) {
            this.m_maxUsageInPercent = this.m_currentUsageInPercent;
        }
        double usage = this.m_currentUsageInPercent * 100.0;
        this.checkThresholds(usage);
        if (this.isKeepingHistory()) {
            this.history.update(new Double(usage));
        }
    }

    protected void alert() {
        this.alert("Warning");
    }

    protected Serializable getValueForPerformanceHistory() {
        return new Double(this.m_currentUsageInPercent * 100.0);
    }

    public String getMostSignificantValueAsString() {
        return new Long(this.m_currentUsage).toString() + " " + this.getUnit();
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(this.m_currentUsageInPercent * 100.0);
    }
}

