/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IBooleanMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.BooleanHistoryValue;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import java.io.Serializable;

public class BooleanMonitorNode
extends PerformanceMonitorNode
implements IBooleanMonitorNode {
    protected boolean m_value = false;
    protected long measuredTime;
    protected boolean m_alertOnTrue = false;
    protected boolean m_alertOnFalse = false;
    protected int m_colorForTrue = 0;
    protected int m_colorForFalse = 0;
    protected long m_timeOnTrue;
    protected long m_timeOnFalse;

    public BooleanMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("value", this.m_value);
        result = result + AbstractMonitorNode.getAttributeString("time on true", this.m_timeOnTrue);
        result = result + AbstractMonitorNode.getAttributeString("time on false", this.m_timeOnFalse);
        result = result + "</attributes>";
        return result;
    }

    public void setValue(boolean value) {
        this.measuredTime = System.currentTimeMillis();
        long timeDiff = this.measuredTime - this.m_lastChangeDate;
        if (value) {
            this.m_timeOnTrue += timeDiff;
        } else {
            this.m_timeOnFalse += timeDiff;
        }
        this.m_value = value;
        this.m_color = value ? this.m_colorForTrue : this.m_colorForFalse;
        if (this.m_color == 3 && this.m_alertOnRed) {
            this.alert();
        }
        this.m_lastChangeDate = this.measuredTime;
    }

    public boolean getValue() {
        return this.m_value;
    }

    public void setKeepingHistory(boolean keepHistory) {
        this.m_keepHistory = keepHistory;
        if (!this.m_keepHistory || this.history == null) {
            // empty if block
        }
    }

    public void setColorForFalse(int color) {
        this.m_colorForFalse = color;
    }

    public int getColorForFalse() {
        return this.m_colorForFalse;
    }

    public void setColorForTrue(int color) {
        this.m_colorForTrue = color;
    }

    public int getColorForTrue() {
        return this.m_colorForTrue;
    }

    public void setAlertOnFalse(boolean alert) {
        this.m_alertOnFalse = alert;
    }

    public boolean getAlertOnTrue() {
        return this.m_alertOnTrue;
    }

    public void setAlertOnTrue(boolean alert) {
        this.m_alertOnTrue = alert;
    }

    public boolean getAlertOnFalse() {
        return this.m_alertOnFalse;
    }

    public int getTyp() {
        return 5;
    }

    public long getTimeOnTrueInMilliseconds() {
        return this.m_timeOnTrue;
    }

    public long getTimeOnFalseInMilliseconds() {
        return this.m_timeOnFalse;
    }

    protected void alert() {
        this.alert("Warning");
    }

    protected Serializable getValueForPerformanceHistory() {
        return new BooleanHistoryValue(this.m_timeOnTrue, this.m_timeOnFalse, this.m_value, this.measuredTime);
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
    }
}

