/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IBooleanHistoryValue;
import com.sap.engine.library.monitor.ITimedSerializable;
import java.io.Serializable;

public class BooleanHistoryValue
implements IBooleanHistoryValue,
Serializable,
ITimedSerializable {
    protected long m_timeOnTrue;
    protected long m_timeOnFalse;
    protected boolean m_value;
    protected long measuredTime;

    public BooleanHistoryValue(long timeOnTrue, long timeOnFalse, boolean value, long measuredTime) {
        this.m_timeOnTrue = timeOnTrue;
        this.m_timeOnFalse = timeOnFalse;
        this.m_value = value;
        this.measuredTime = measuredTime;
    }

    public long getTimeOnTrue() {
        return this.m_timeOnTrue;
    }

    public long getTimeOnFalse() {
        return this.m_timeOnFalse;
    }

    public double getPercentageOnTrue() {
        long sum = this.m_timeOnTrue + this.m_timeOnFalse;
        if (sum == 0L) {
            return 100.0;
        }
        return this.m_timeOnTrue / sum;
    }

    public boolean getBooleanValue() {
        return this.m_value;
    }

    public String toString() {
        if (this.m_value) {
            return "true";
        }
        return "false";
    }

    public long getTimeStamp() {
        return this.measuredTime;
    }

    public void setTimeStamp(long timeInMillis) {
    }

    public Serializable getValue() {
        return new Boolean(this.m_value);
    }

    public void setValue(Serializable value) {
    }
}

