/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IAvailabilityMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.Util;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import java.io.Serializable;

public class AvailabilityMonitorNode
extends PerformanceMonitorNode
implements IAvailabilityMonitorNode {
    protected boolean m_value = false;
    protected long m_timeOnTrue;
    protected long m_timeOnFalse;
    protected double m_availability = 1.0;

    public AvailabilityMonitorNode(String name) throws InvalidNameException {
        super(name);
    }

    protected String buildXmlAttributes() {
        String result = "<attributes>";
        result = result + AbstractMonitorNode.getAttributeString("availability", this.getAvailability());
        result = result + AbstractMonitorNode.getAttributeString("value", this.m_value);
        result = result + "</attributes>";
        return result;
    }

    public void setValue(boolean value) {
        this.hasReportedValue = true;
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - this.m_lastChangeDate;
        if (value) {
            this.m_timeOnTrue += timeDiff;
        } else {
            this.m_timeOnFalse += timeDiff;
        }
        this.m_value = value;
        this.m_availability = 1.0;
        double sum = this.m_timeOnTrue + this.m_timeOnFalse;
        if (sum != 0.0) {
            this.m_availability = (double)this.m_timeOnTrue / sum;
        }
        double availabilityInPercent = 100.0 * this.m_availability;
        this.checkThresholds(availabilityInPercent);
        if (this.isKeepingHistory()) {
            this.history.update(new Double(availabilityInPercent));
        }
        this.m_lastChangeDate = currentTime;
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.reportAvailability(this, availabilityInPercent);
        }
    }

    public boolean getValue() {
        return this.m_value;
    }

    public int getTyp() {
        return 15;
    }

    public long getTimeOnTrueInMilliseconds() {
        return this.m_timeOnTrue;
    }

    public long getTimeOnFalseInMilliseconds() {
        return this.m_timeOnFalse;
    }

    protected void alert() {
        this.alert("Warning");
    }

    public double getAvailability() {
        return this.m_availability * 100.0;
    }

    protected Serializable getValueForPerformanceHistory() {
        return new Double(this.m_availability);
    }

    public String getMostSignificantValueAsString() {
        if (this.hasReportedValue) {
            return Util.round(this.m_availability * 100.0) + " %";
        }
        return "No value has been reported yet";
    }

    public void setThresholdsAndCheck(IThresholds thresholds) {
        super.setThresholds(thresholds);
        super.checkThresholds(100.0 * this.m_availability);
    }
}

