/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.impl0;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorNodeListener;
import com.sap.engine.library.monitor.IValueChangeListener;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.ValueChangeEvent;
import com.sap.engine.library.monitor.impl0.MonitorTreeListenerRegistry;
import com.sap.engine.library.monitor.impl0.MonitorTreeStructureChangeEvent;
import com.sap.engine.library.monitor.impl0.SummaryMonitorNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import com.sap.tc.logging.Location;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public abstract class AbstractMonitorNode
implements IMonitorNode,
Comparator {
    private static final String ENGINE_DESCRIPTION_ID = "J2EE engine root";
    private static final String ENGINE_DESCRIPTION = "Root of the J2EE engine";
    private static final String ENGINE_CONFIG_GROUP = "SAP_J2EE_Engine";
    protected static final Location location = Location.getLocation((String)"com.sap.engine.library.monitor.impl0.MonitorObjectFactory");
    protected Vector m_subnodes = new Vector();
    protected IMonitorNode m_parent = null;
    protected String m_name = "";
    protected boolean m_isConfigured = false;
    protected long m_creationTime;
    protected long m_lastChangeDate = System.currentTimeMillis();
    protected String m_description = "";
    private String descriptionID = "";
    private String configurationGroup = "";
    protected int m_color = 0;
    protected transient Vector m_changeListener = null;
    protected transient Vector nodeListeners = null;
    protected String owner;
    private boolean volatility;
    protected static String EOL = System.getProperty("line.separator");
    protected static IMonitorNode s_instance = null;
    protected String path;
    public boolean hasReportedValue = false;
    private int dataCollectionType;
    private int reactOnCollectionFailure;
    private int periodValue;
    private int periodUnit;
    private String analysisMethod;
    private String autoreactionMethod;

    public AbstractMonitorNode(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException();
        }
        this.m_name = name;
        this.m_lastChangeDate = this.m_creationTime = System.currentTimeMillis();
        this.m_changeListener = new Vector(0);
        this.nodeListeners = new Vector();
    }

    protected AbstractMonitorNode() {
        if (EOL == null) {
            EOL = "";
        }
        this.m_changeListener = new Vector(0);
        this.nodeListeners = new Vector();
    }

    public IMonitorNode[] getSubNodes() {
        int len = this.m_subnodes.size();
        TreeSet set = new TreeSet(this);
        int i = 0;
        while (i < len) {
            set.add(this.m_subnodes.elementAt(i));
            ++i;
        }
        Iterator setIter = set.iterator();
        IMonitorNode[] tempNodes = new IMonitorNode[len];
        int p = 0;
        while (setIter.hasNext()) {
            tempNodes[p] = (IMonitorNode)setIter.next();
            ++p;
        }
        return tempNodes;
    }

    public IMonitorNode subNodeWithName(String name) {
        int i = this.m_subnodes.size() - 1;
        while (i >= 0) {
            if (((IMonitorNode)this.m_subnodes.elementAt(i)).getName().equals(name)) {
                return (IMonitorNode)this.m_subnodes.elementAt(i);
            }
            --i;
        }
        return null;
    }

    public IMonitorNode getParent() {
        return this.m_parent;
    }

    public synchronized void addSubNode(IMonitorNode subNode) {
        this.m_subnodes.addElement(subNode);
        ((AbstractMonitorNode)subNode).m_parent = this;
        MonitorTreeStructureChangeEvent event = new MonitorTreeStructureChangeEvent(this, true);
        MonitorTreeListenerRegistry.getInstance().processStructureChange(event);
    }

    public void remove(Boolean isRemovedFromCcmsPersistence) {
        if (this.getSubNodes().length > 0) {
            location.warningT("monitor node " + this.getPath() + "is not an end node and can not be removed");
            return;
        }
        this.removeFromCcms(isRemovedFromCcmsPersistence);
        this.removeFromMonitorTree();
    }

    public void removeSubNode(IMonitorNode subNode) {
        IMonitorNode[] subNodes = this.getSubNodes();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getName().equals(subNode.getName())) {
                subNodes[i].remove(null);
            }
            ++i;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String description) {
        this.m_name = description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescriptionID(String id) {
        this.descriptionID = id == null ? "" : id;
    }

    public String getDescriptionID() {
        return this.descriptionID;
    }

    public String getAnalysisMethod() {
        return this.analysisMethod;
    }

    public void setAnalysisMethod(String analysisMethod) {
        this.analysisMethod = analysisMethod;
    }

    public String getAutoreactionMethod() {
        return this.autoreactionMethod;
    }

    public void setAutoreactionMethod(String autoreactionMethod) {
        this.autoreactionMethod = autoreactionMethod;
    }

    public void setVolatile(boolean volatility) {
        this.volatility = volatility;
    }

    public boolean isVolatile() {
        return this.volatility;
    }

    public void setOwner(String nodeOwner) {
        this.owner = nodeOwner;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setConfigurationGroup(String group) {
        this.configurationGroup = group == null ? "" : group;
    }

    public String getConfigurationGroup() {
        return this.configurationGroup;
    }

    public void addToCcms() {
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.registerNode(this);
        }
    }

    public int getTyp() {
        return 0;
    }

    public Date getCreationTime() {
        return new Date(this.m_creationTime);
    }

    public Date getLastChangeDate() {
        return new Date(this.m_lastChangeDate);
    }

    public boolean isConfigured() {
        return this.m_isConfigured;
    }

    public void setConfigured(boolean isConfigured) {
        this.m_isConfigured = isConfigured;
    }

    public int getStatusColor() {
        return this.m_color;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath() {
        if (this.m_parent == null) {
            this.path = "/";
            return;
        }
        if (this.m_parent.getPath().length() == 1) {
            StringBuffer pathStr = new StringBuffer(this.m_parent.getPath().length() + this.m_name.length());
            pathStr.append(this.m_parent.getPath());
            pathStr.append(this.m_name);
            this.path = pathStr.toString();
            return;
        }
        StringBuffer pathStr = new StringBuffer(this.m_parent.getPath().length() + this.m_name.length() + 1);
        pathStr.append(this.m_parent.getPath());
        pathStr.append("/");
        pathStr.append(this.m_name);
        this.path = pathStr.toString();
    }

    public final String toXml() {
        return this.buildXmlStart() + this.buildXmlAttributes() + this.buildXmlStructures() + this.buildXmlSubTree() + "</node>\n";
    }

    public synchronized void registerEventListener(IValueChangeListener listener) {
        this.m_changeListener.addElement(listener);
    }

    public synchronized void unregisterEventListener(IValueChangeListener listener) {
        this.m_changeListener.removeElement(listener);
    }

    public void registerNodeListener(IMonitorNodeListener nodeListener) {
        this.nodeListeners.add(nodeListener);
    }

    public int compare(Object o1, Object o2) {
        IMonitorNode node1 = (IMonitorNode)o1;
        IMonitorNode node2 = (IMonitorNode)o2;
        return node1.getName().compareTo(node2.getName());
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public static IMonitorNode getRootInstance() {
        if (s_instance == null) {
            AbstractMonitorNode.createRootInstance();
        }
        return s_instance;
    }

    public static void deleteRootInstance() {
        MonitorTreeListenerRegistry.deleteInstance();
        s_instance = null;
    }

    public String[] getReversePath() {
        Vector<String> v = new Vector<String>();
        IMonitorNode current = this;
        while (current != null) {
            v.addElement(current.getName());
            current = current.getParent();
        }
        int len = v.size();
        Object[] result = new String[len];
        v.copyInto(result);
        return result;
    }

    public String getMostSignificantValueAsString() {
        return "";
    }

    protected static final String getAttributeString(String name, int value) {
        return "<attribute name=\"" + name + "\" value = \"" + value + "\"/>";
    }

    protected static final String getAttributeString(String name, long value) {
        return "<attribute name=\"" + name + "\" value = \"" + value + "\"/>";
    }

    protected static final String getAttributeString(String name, float value) {
        return "<attribute name=\"" + name + "\" value = \"" + value + "\"/>";
    }

    protected static final String getAttributeString(String name, double value) {
        return "<attribute name=\"" + name + "\" value = \"" + value + "\"/>";
    }

    protected static final String getAttributeString(String name, boolean value) {
        if (value) {
            return "<attribute name=\"" + name + "\" value = \"true\"/>";
        }
        return "<attribute name=\"" + name + "\" value = \"false\"/>";
    }

    protected static final String getAttributeString(String name, Object value) {
        return "<attribute name=\"" + name + "\" value = \"" + value + "\"/>";
    }

    protected final String buildXmlStart() {
        String result = "<node name=\"" + this.m_name + "\" type=\"" + this.getTyp() + "\"> ";
        return result;
    }

    protected final String buildXmlSubTree() {
        int len = this.m_subnodes.size();
        if (len > 0) {
            String result = "<subnodes> ";
            int i = 0;
            while (i < len) {
                result = result + "\n" + ((IMonitorNode)this.m_subnodes.elementAt(i)).toXml();
                ++i;
            }
            result = result + "\n </subnodes>";
            return result;
        }
        return "";
    }

    protected void fireEvent(ValueChangeEvent event) {
        if (this.m_changeListener != null) {
            int i = this.m_changeListener.size() - 1;
            while (i >= 0) {
                ((IValueChangeListener)this.m_changeListener.elementAt(i)).stateChanged(event);
                --i;
            }
        }
    }

    private void removeFromMonitorTree() {
        ((AbstractMonitorNode)this.getParent()).m_subnodes.removeElement(this);
        this.m_parent = null;
        MonitorTreeStructureChangeEvent event = new MonitorTreeStructureChangeEvent(this.getParent(), false);
        MonitorTreeListenerRegistry.getInstance().processStructureChange(event);
    }

    private void removeFromCcms(Boolean persistent) {
        CcmsConnector connector = CcmsConnector.getInstance();
        if (connector != null) {
            connector.deregisterNode(this, persistent == null ? this.volatility : persistent);
        }
    }

    private static synchronized IMonitorNode createRootInstance() {
        if (s_instance != null) {
            return s_instance;
        }
        try {
            SummaryMonitorNode root = new SummaryMonitorNode("Root");
            AbstractMonitorNode.configureMonitorNode(root, ENGINE_DESCRIPTION_ID, ENGINE_DESCRIPTION, ENGINE_CONFIG_GROUP);
            s_instance = root;
        }
        catch (InvalidNameException e) {
            location.errorT(e.getMessage());
        }
        return s_instance;
    }

    private static void configureMonitorNode(IMonitorNode node, String descriptionID, String descriptionText, String configGroupName) {
        node.setDescriptionID(descriptionID);
        node.setDescription(descriptionText);
        node.setConfigurationGroup(configGroupName);
        node.setConfigured(true);
    }

    protected abstract String buildXmlStructures();

    protected abstract String buildXmlAttributes();

    public boolean getHasReportedValue() {
        return this.hasReportedValue;
    }

    public int getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(int periodUnit) {
        this.periodUnit = periodUnit;
    }

    public int getPeriodValue() {
        return this.periodValue;
    }

    public void setPeriodValue(int periodValue) {
        this.periodValue = periodValue;
    }

    public int getDataCollectionType() {
        return this.dataCollectionType;
    }

    public void setDataCollectionType(int dataCollectionType) {
        this.dataCollectionType = dataCollectionType;
    }

    public int getReactOnCollectionFailure() {
        return this.reactOnCollectionFailure;
    }

    public void setReactOnCollectionFailure(int reactOnCollectionFailure) {
        this.reactOnCollectionFailure = reactOnCollectionFailure;
    }
}

