/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.history;

import com.sap.engine.library.monitor.history.HistoryStatistics;
import com.sap.engine.library.monitor.history.HoursHistory;
import com.sap.engine.library.monitor.history.IntervalHistory;
import java.io.Serializable;
import java.util.List;

public class QuartersHistory
extends IntervalHistory
implements Serializable {
    private HoursHistory hoursHistory;

    public QuartersHistory() {
        this.initQuartersHistory();
        this.init();
    }

    protected void determineAggregationIndices(long timestamp) {
        this.determineAggregationIndices(timestamp, 15, 60);
    }

    protected void aggregate() {
        List aggregateCandidates = this.getAggregateCandidates();
        HistoryStatistics histStat = HistoryStatistics.getAggregatedHistoryStatistics(aggregateCandidates, this.averagingMode);
        if (histStat != null) {
            this.hoursHistory.addEntry(histStat);
        }
    }

    public void setAveragingMode(int averagingMode) {
        this.averagingMode = averagingMode;
        this.hoursHistory.setAveragingMode(averagingMode);
    }

    public HoursHistory getHoursHistory() {
        return this.hoursHistory;
    }

    private void initQuartersHistory() {
        this.intervalLengthInMinutes = 15;
        this.arrayLength = 8;
        this.counterComparator = this.arrayLength / 2 - 1;
        this.hoursHistory = new HoursHistory();
    }
}

