/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.history;

import com.sap.engine.library.monitor.history.FiveMinutesHistory;
import com.sap.engine.library.monitor.history.HistoryStatistics;
import com.sap.engine.library.monitor.history.IntervalHistory;
import java.io.Serializable;
import java.util.List;

public class MinutesHistory
extends IntervalHistory
implements Serializable {
    private FiveMinutesHistory fiveMinutesHistory;

    public MinutesHistory() {
        this.initMinutesHistory();
        this.init();
    }

    protected void determineAggregationIndices(long timestamp) {
        this.determineAggregationIndices(timestamp, 1, 5);
    }

    protected void aggregate() {
        List aggregateCandidates = this.getAggregateCandidates();
        HistoryStatistics histStat = HistoryStatistics.getAggregatedHistoryStatistics(aggregateCandidates, this.averagingMode);
        if (histStat != null) {
            this.fiveMinutesHistory.addEntry(histStat);
        }
    }

    public void setAveragingMode(int averagingMode) {
        this.averagingMode = averagingMode;
        this.fiveMinutesHistory.setAveragingMode(averagingMode);
    }

    public FiveMinutesHistory getFiveMinutesHistory() {
        return this.fiveMinutesHistory;
    }

    private void initMinutesHistory() {
        this.intervalLengthInMinutes = 1;
        this.arrayLength = 10;
        this.counterComparator = this.arrayLength / 2 - 1;
        this.fiveMinutesHistory = new FiveMinutesHistory();
    }
}

