/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.history;

import com.sap.engine.library.monitor.history.HistoryStatistics;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public abstract class IntervalHistory
implements Serializable {
    protected int arrayLength;
    protected int[] aggregationIndices;
    protected int entryCounter;
    protected int newestIndex;
    protected int counterComparator;
    protected int intervalLengthInMinutes;
    protected int averagingMode;
    private HistoryStatistics[] statisticEntries;

    public void addEntry(HistoryStatistics stat) {
        if (this.isStarting()) {
            if (this.aggregationIndices == null) {
                this.determineAggregationIndices(stat.getStartTimestamp());
            }
            this.addEntryCommon(stat);
        } else {
            this.addEntryCommon(stat);
            if (this.isAggregationNecessary()) {
                this.aggregate();
            }
        }
    }

    public List getEntries() {
        Vector<HistoryStatistics> entries = new Vector<HistoryStatistics>();
        int i = 0;
        while (i < this.statisticEntries.length) {
            entries.add(this.statisticEntries[i]);
            ++i;
        }
        return entries;
    }

    public HistoryStatistics getEntry(int index) {
        return this.statisticEntries[index];
    }

    public void print() {
        int i = 0;
        while (i < this.arrayLength) {
            HistoryStatistics entry = this.statisticEntries[i];
            if (entry != null) {
                entry.print();
            }
            ++i;
        }
    }

    protected void init() {
        this.newestIndex = -1;
        this.statisticEntries = new HistoryStatistics[this.arrayLength];
        this.entryCounter = 0;
    }

    protected void determineAggregationIndices(long timestamp, int localAggregateStep, int higherLevelAggregateStep) {
        this.aggregationIndices = new int[2];
        int minutesOfHour = this.getMinutesOfHour(timestamp);
        int index = 0;
        while (index < this.arrayLength / 2) {
            int minutes = this.getMinutesForIndex(minutesOfHour, index, localAggregateStep);
            if (this.isAggregationIndex(minutes, higherLevelAggregateStep)) {
                this.aggregationIndices[0] = index;
                this.aggregationIndices[1] = (this.aggregationIndices[0] + this.arrayLength / 2) % this.arrayLength;
                break;
            }
            ++index;
        }
    }

    protected List getAggregateCandidates() {
        Vector<HistoryStatistics> list = new Vector<HistoryStatistics>();
        int i = 0;
        int index = this.newestIndex;
        while (i < this.arrayLength / 2) {
            list.add(this.statisticEntries[index]);
            index = this.moveIndex(index, -1);
            ++i;
        }
        return list;
    }

    private int moveIndex(int initialIndex, int step) {
        if (initialIndex >= 0 && initialIndex < this.arrayLength) {
            int index = (initialIndex + step) % this.arrayLength;
            if (index < 0) {
                index += this.arrayLength;
            }
            return index;
        }
        return -1;
    }

    private int getMinutesForIndex(int minutes, int index, int aggregateStep) {
        return minutes + index * aggregateStep;
    }

    private boolean isAggregationIndex(int minutesOfHour, int higherLevelAggregateStep) {
        return minutesOfHour % higherLevelAggregateStep == 0;
    }

    private int getMinutesOfHour(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(timestamp));
        int minutes = calendar.get(12);
        return minutes;
    }

    private void addEntryCommon(HistoryStatistics stat) {
        int index = this.newestIndex == -1 ? this.getWriteIndex() : this.generateMissingEntries(stat.getStartTimestamp(), stat.getIntervalLength());
        this.statisticEntries[index] = stat;
        this.newestIndex = index;
    }

    private int generateMissingEntries(long newTimestamp, int intervalLength) {
        int index = this.getWriteIndex();
        long timeStepInMillis = (long)this.intervalLengthInMinutes * 60000L;
        long timestamp = this.statisticEntries[this.newestIndex].getStartTimestamp() + timeStepInMillis;
        while (timestamp < newTimestamp) {
            this.generateMissingEntry(index, timestamp, intervalLength);
            if (this.isAggregationNecessary()) {
                this.aggregate();
            }
            index = this.moveIndex(index, 1);
            timestamp += timeStepInMillis;
        }
        return index;
    }

    private void generateMissingEntry(int index, long timestamp, int intervalLength) {
        this.statisticEntries[index] = new HistoryStatistics(timestamp, intervalLength, this.averagingMode, 0, null, null, 0.0, 0.0, 0.0, 0.0);
        this.newestIndex = index;
    }

    private boolean isStarting() {
        boolean starting;
        if (this.entryCounter < this.counterComparator) {
            starting = true;
            ++this.entryCounter;
        } else {
            starting = false;
        }
        return starting;
    }

    private int getWriteIndex() {
        int writeIndex = this.newestIndex >= this.arrayLength - 1 ? 0 : this.newestIndex + 1;
        return writeIndex;
    }

    private boolean isAggregationNecessary() {
        if (this.aggregationIndices == null) {
            return false;
        }
        int nextToNI = this.moveIndex(this.newestIndex, 1);
        return nextToNI == this.aggregationIndices[0] || nextToNI == this.aggregationIndices[1];
    }

    protected abstract void determineAggregationIndices(long var1);

    protected abstract void aggregate();
}

