/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.history;

import com.sap.engine.library.monitor.history.Extremum;
import com.sap.engine.library.monitor.history.IExtremum;
import com.sap.engine.library.monitor.history.IHistoryStatistics;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class HistoryStatistics
implements IHistoryStatistics {
    private long timestamp;
    private Extremum minimum;
    private Extremum maximum;
    private double sum;
    private double squaredSum;
    private int counts;
    private int intervalLength;
    private double average;
    private double standardDeviation;
    private int averagingMode;

    public HistoryStatistics() {
    }

    public HistoryStatistics(long timestamp, int intervalLength, int averagingMode, int counts, Extremum minimum, Extremum maximum, double sum, double squaredSum, double average, double standardDeviation) {
        this.timestamp = timestamp;
        this.minimum = minimum;
        this.maximum = maximum;
        this.sum = sum;
        this.squaredSum = squaredSum;
        this.counts = counts;
        this.intervalLength = intervalLength;
        this.average = average;
        this.standardDeviation = standardDeviation;
        this.averagingMode = averagingMode;
    }

    public long getStartTimestamp() {
        return this.timestamp;
    }

    public int getTimeIntervalLength() {
        int timeIntervalLength;
        switch (this.intervalLength) {
            case 0: {
                timeIntervalLength = 1;
                break;
            }
            case 1: {
                timeIntervalLength = 5;
                break;
            }
            case 2: {
                timeIntervalLength = 15;
                break;
            }
            case 3: {
                timeIntervalLength = 60;
                break;
            }
            default: {
                timeIntervalLength = 0;
            }
        }
        return timeIntervalLength;
    }

    public int getMeasurementCounts() {
        return this.counts;
    }

    public IExtremum getMaximum() {
        return this.maximum;
    }

    public IExtremum getMinimum() {
        return this.minimum;
    }

    public double getAverage() {
        double avg = 0.0;
        switch (this.averagingMode) {
            case 0: {
                avg = this.sum / (double)this.counts;
                break;
            }
            case 1: {
                avg = this.average;
            }
        }
        return avg;
    }

    public double getStandardDeviation() {
        double stddev = 0.0;
        switch (this.averagingMode) {
            case 0: {
                double average = this.getAverage();
                stddev = Math.sqrt(new Double(this.squaredSum / (double)this.counts - average * average));
                break;
            }
            case 1: {
                stddev = this.standardDeviation;
            }
        }
        return stddev;
    }

    public int getIntervalLength() {
        return this.intervalLength;
    }

    public double getSum() {
        return this.sum;
    }

    public void setAverage(double sum) {
        this.sum = sum;
    }

    public void setMaximum(Extremum maximum) {
        this.maximum = maximum;
    }

    public void setMinimum(Extremum minimum) {
        this.minimum = minimum;
    }

    public double getSquaredSum() {
        return this.squaredSum;
    }

    public void setSquaredSum(double squaredSum) {
        this.squaredSum = squaredSum;
    }

    public void setStartTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setMeasurementCounts(int counts) {
        this.counts = counts;
    }

    public void setTimeIntervalLength(int intervalLength) {
        this.intervalLength = intervalLength;
    }

    public static HistoryStatistics getAggregatedHistoryStatistics(List aggregateCandidates, int averagingMode) {
        HistoryStatistics historyStatistics = null;
        switch (averagingMode) {
            case 0: {
                historyStatistics = HistoryStatistics.getAggregatedHistoryStatisticsAA(aggregateCandidates);
                break;
            }
            case 1: {
                historyStatistics = HistoryStatistics.getAggregatedHistoryStatisticsTA(aggregateCandidates);
            }
        }
        return historyStatistics;
    }

    public void print() {
        if (this.counts != 0) {
            System.out.println("timestamp: " + new Date(this.timestamp).toString() + " minimum: " + this.minimum.getValue() + " maximum: " + this.maximum.getValue() + " average: " + this.getAverage() + " stdvar: " + this.getStandardDeviation() + " counts: " + this.counts + " intervalLength: " + this.intervalLength);
        } else {
            System.out.println("timestamp: " + new Date(this.timestamp).toString() + " counts: " + this.counts + " intervalLength: " + this.intervalLength);
        }
    }

    private static HistoryStatistics getAggregatedHistoryStatisticsTA(List aggregateCandidates) {
        int intervalLength = HistoryStatistics.getCommonIntervalLength(aggregateCandidates);
        if (intervalLength >= 0) {
            long timestamp = ((HistoryStatistics)aggregateCandidates.get(0)).getStartTimestamp();
            IExtremum minimum = ((HistoryStatistics)aggregateCandidates.get(0)).getMinimum();
            IExtremum maximum = ((HistoryStatistics)aggregateCandidates.get(0)).getMaximum();
            int counts = 0;
            Iterator it = aggregateCandidates.iterator();
            int effectiveArrayLength = 0;
            double avgSum = 0.0;
            double avgSquaredSum = 0.0;
            while (it.hasNext()) {
                HistoryStatistics histStats = (HistoryStatistics)it.next();
                if (histStats == null) continue;
                int mCounts = histStats.getMeasurementCounts();
                if (mCounts > 0) {
                    counts += mCounts;
                    double avg = histStats.getAverage();
                    avgSum += avg;
                    avgSquaredSum += avg * avg;
                    ++effectiveArrayLength;
                }
                if (histStats.getStartTimestamp() < timestamp) {
                    timestamp = histStats.getStartTimestamp();
                }
                if (minimum != null && histStats.getMinimum() != null) {
                    if (histStats.getMinimum().getValue() < minimum.getValue()) {
                        minimum = histStats.getMinimum();
                    }
                } else if (minimum == null && histStats.getMinimum() != null) {
                    minimum = histStats.getMinimum();
                }
                if (maximum != null && histStats.getMaximum() != null) {
                    if (!(histStats.getMaximum().getValue() > maximum.getValue())) continue;
                    maximum = histStats.getMaximum();
                    continue;
                }
                if (maximum != null || histStats.getMaximum() == null) continue;
                maximum = histStats.getMaximum();
            }
            double average = avgSum / (double)effectiveArrayLength;
            double standardDeviation = Math.sqrt(new Double(avgSquaredSum / (double)effectiveArrayLength - average * average));
            return new HistoryStatistics(timestamp, intervalLength + 1, 1, counts, (Extremum)minimum, (Extremum)maximum, 0.0, 0.0, average, standardDeviation);
        }
        new Exception("inconsistent interval length").printStackTrace();
        return new HistoryStatistics(0L, intervalLength + 1, 1, 0, null, null, 0.0, 0.0, 0.0, 0.0);
    }

    private static HistoryStatistics getAggregatedHistoryStatisticsAA(List aggregateCandidates) {
        int intervalLength = HistoryStatistics.getCommonIntervalLength(aggregateCandidates);
        if (intervalLength >= 0) {
            long timestamp = ((HistoryStatistics)aggregateCandidates.get(0)).getStartTimestamp();
            IExtremum minimum = ((HistoryStatistics)aggregateCandidates.get(0)).getMinimum();
            IExtremum maximum = ((HistoryStatistics)aggregateCandidates.get(0)).getMaximum();
            double sum = 0.0;
            double squaredSum = 0.0;
            int counts = 0;
            Iterator it = aggregateCandidates.iterator();
            while (it.hasNext()) {
                HistoryStatistics histStats = (HistoryStatistics)it.next();
                if (histStats == null) continue;
                sum += histStats.getSum();
                squaredSum += histStats.getSquaredSum();
                counts += histStats.getMeasurementCounts();
                if (histStats.getStartTimestamp() < timestamp) {
                    timestamp = histStats.getStartTimestamp();
                }
                if (minimum != null && histStats.getMinimum() != null) {
                    if (histStats.getMinimum().getValue() < minimum.getValue()) {
                        minimum = histStats.getMinimum();
                    }
                } else if (minimum == null && histStats.getMinimum() != null) {
                    minimum = histStats.getMinimum();
                }
                if (maximum != null && histStats.getMaximum() != null) {
                    if (!(histStats.getMaximum().getValue() > maximum.getValue())) continue;
                    maximum = histStats.getMaximum();
                    continue;
                }
                if (maximum != null || histStats.getMaximum() == null) continue;
                maximum = histStats.getMaximum();
            }
            return new HistoryStatistics(timestamp, intervalLength + 1, 0, counts, (Extremum)minimum, (Extremum)maximum, sum, squaredSum, 0.0, 0.0);
        }
        new Exception("inconsistent interval length").printStackTrace();
        return new HistoryStatistics(0L, intervalLength + 1, 0, 0, null, null, 0.0, 0.0, 0.0, 0.0);
    }

    private static int getCommonIntervalLength(List aggregateCandidates) {
        int intervalLength = ((HistoryStatistics)aggregateCandidates.get((int)0)).intervalLength;
        Iterator it = aggregateCandidates.iterator();
        HistoryStatistics histTemp = null;
        while (it.hasNext()) {
            histTemp = (HistoryStatistics)it.next();
            if (histTemp == null || histTemp.intervalLength == intervalLength) continue;
            return -1;
        }
        return intervalLength;
    }
}

