/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.history;

import com.sap.engine.library.monitor.history.ActualMinuteHistory;
import com.sap.engine.library.monitor.history.HistoryStatistics;
import com.sap.engine.library.monitor.history.IHistory;
import com.sap.engine.library.monitor.history.IHistoryStatistics;
import java.io.Serializable;

public class History
implements IHistory {
    public static final int ARITHMETIC_AVERAGING = 0;
    public static final int TIME_WEIGHTED_AVERAGING = 1;
    public static final int MINUTE = 0;
    public static final int FIVE_MINUTES = 1;
    public static final int QUARTER = 2;
    public static final int HOUR = 3;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final int MINUTES_IN_ONE_MINUTE = 1;
    public static final int MINUTES_IN_FIVE_MINUTES = 5;
    public static final int MINUTES_IN_QUARTER = 15;
    public static final int MINUTES_IN_HOUR = 60;
    public static final int MINUTES_ARRAY_LENGTH = 10;
    public static final int FIVE_MINUTES_ARRAY_LENGTH = 6;
    public static final int QUARTERS_ARRAY_LENGTH = 8;
    public static final int HOURS_ARRAY_LENGTH = 24;
    private ActualMinuteHistory actualMinuteHistory = new ActualMinuteHistory();
    private int averagingMode;

    public void setAveragingMode(int averagingMode) {
        this.averagingMode = averagingMode;
        this.actualMinuteHistory.setAveragingMode(averagingMode);
    }

    public void update(Number newValue) {
        this.actualMinuteHistory.update(newValue.doubleValue());
    }

    public void update(Number newValue, int counts) {
        this.actualMinuteHistory.update(newValue.doubleValue(), counts);
    }

    public int getAveragingMode() {
        return this.averagingMode;
    }

    public IHistoryStatistics getActualMinuteHistory() {
        return this.actualMinuteHistory.getStatistics();
    }

    public Serializable[] getMinutesHistory() {
        return History.objectArray2SerializableArray(this.actualMinuteHistory.getMinutesHistory().getEntries().toArray());
    }

    public Serializable[] getFiveMinutesHistory() {
        return History.objectArray2SerializableArray(this.actualMinuteHistory.getMinutesHistory().getFiveMinutesHistory().getEntries().toArray());
    }

    public Serializable[] getQuartersHistory() {
        return History.objectArray2SerializableArray(this.actualMinuteHistory.getMinutesHistory().getFiveMinutesHistory().getQuartersHistory().getEntries().toArray());
    }

    public Serializable[] getHoursHistory() {
        return History.objectArray2SerializableArray(this.actualMinuteHistory.getMinutesHistory().getFiveMinutesHistory().getQuartersHistory().getHoursHistory().getEntries().toArray());
    }

    public static void print(Serializable[] histStatEntries) {
        int i = 0;
        while (i < histStatEntries.length) {
            if (histStatEntries[i] != null) {
                ((HistoryStatistics)histStatEntries[i]).print();
            }
            ++i;
        }
    }

    private static Serializable[] objectArray2SerializableArray(Object[] objArray) {
        Serializable[] serializableArray = new Serializable[objArray.length];
        int i = 0;
        while (i < objArray.length) {
            serializableArray[i] = (Serializable)objArray[i];
            ++i;
        }
        return serializableArray;
    }
}

