/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.history;

import com.sap.engine.library.monitor.history.HistoryStatistics;
import com.sap.engine.library.monitor.history.IntervalHistory;
import com.sap.engine.library.monitor.history.QuartersHistory;
import java.io.Serializable;
import java.util.List;

public class FiveMinutesHistory
extends IntervalHistory
implements Serializable {
    private QuartersHistory quartersHistory;

    public FiveMinutesHistory() {
        this.initFiveMinutesHistory();
        this.init();
    }

    protected void determineAggregationIndices(long timestamp) {
        this.determineAggregationIndices(timestamp, 5, 15);
    }

    protected void aggregate() {
        List aggregateCandidates = this.getAggregateCandidates();
        HistoryStatistics histStat = HistoryStatistics.getAggregatedHistoryStatistics(aggregateCandidates, this.averagingMode);
        if (histStat != null) {
            this.quartersHistory.addEntry(histStat);
        }
    }

    public void setAveragingMode(int averagingMode) {
        this.averagingMode = averagingMode;
        this.quartersHistory.setAveragingMode(averagingMode);
    }

    public QuartersHistory getQuartersHistory() {
        return this.quartersHistory;
    }

    private void initFiveMinutesHistory() {
        this.intervalLengthInMinutes = 5;
        this.arrayLength = 6;
        this.counterComparator = this.arrayLength / 2 - 1;
        this.quartersHistory = new QuartersHistory();
    }
}

