/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.history;

import com.sap.engine.library.monitor.history.Extremum;
import com.sap.engine.library.monitor.history.HistoryStatistics;
import com.sap.engine.library.monitor.history.MinutesHistory;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class ActualMinuteHistory
implements Serializable {
    private static final int MILLIS_IN_MINUTE = 60000;
    private long timestamp;
    private Extremum minimum;
    private Extremum maximum;
    private int counts;
    private double sum;
    private double squaredSum;
    private MinutesHistory minutesHistory;
    private int averagingMode;

    public ActualMinuteHistory() {
        this.initialize(0L);
        this.minutesHistory = new MinutesHistory();
    }

    public void initialize(long timestamp) {
        this.timestamp = timestamp;
        this.minimum = null;
        this.maximum = null;
        this.counts = 0;
        this.sum = 0.0;
        this.squaredSum = 0.0;
    }

    public boolean isInitial() {
        return this.timestamp == 0L;
    }

    public void setAveragingMode(int averagingMode) {
        this.averagingMode = averagingMode;
        this.minutesHistory.setAveragingMode(averagingMode);
    }

    public void update(double newValue) {
        long timestamp = System.currentTimeMillis();
        if (this.isInitial()) {
            this.addFirstEntry(timestamp, newValue);
        } else if (this.isIncluded(timestamp)) {
            this.addEntry(timestamp, newValue);
        } else {
            this.minutesHistory.addEntry(this.getStatistics());
            this.addFirstEntry(timestamp, newValue);
        }
    }

    public void update(double newValue, int counts) {
        long timestamp = System.currentTimeMillis();
        if (this.isInitial()) {
            this.addFirstEntry(timestamp, newValue, counts);
        } else if (this.isIncluded(timestamp)) {
            this.addEntry(timestamp, newValue, counts);
        } else {
            this.minutesHistory.addEntry(this.getStatistics());
            this.addFirstEntry(timestamp, newValue, counts);
        }
    }

    public MinutesHistory getMinutesHistory() {
        return this.minutesHistory;
    }

    public void addFirstEntry(long timestampOfFirstEntry, double value) {
        this.initialize(this.getMinuteStartTimestamp(timestampOfFirstEntry));
        this.updateSums(value);
        this.setExtrema(timestampOfFirstEntry, value);
    }

    public void addFirstEntry(long timestampOfFirstEntry, double value, int counts) {
        this.initialize(this.getMinuteStartTimestamp(timestampOfFirstEntry));
        this.updateSums(value, counts);
        this.setExtrema(timestampOfFirstEntry, value);
    }

    public void addEntry(long timestamp, double value) {
        this.updateSums(value);
        this.updateExtrema(timestamp, value);
    }

    public void addEntry(long timestamp, double value, int counts) {
        this.updateSums(value, counts);
        this.updateExtrema(timestamp, value);
    }

    public boolean isIncluded(long compareTimestamp) {
        return this.timestamp <= compareTimestamp && compareTimestamp < this.timestamp + 60000L;
    }

    public HistoryStatistics getStatistics() {
        double average = this.sum / (double)this.counts;
        double stddev = Math.sqrt(new Double(this.squaredSum / (double)this.counts - average * average));
        return new HistoryStatistics(this.timestamp, 0, this.averagingMode, this.counts, this.minimum, this.maximum, this.sum, this.squaredSum, average, stddev);
    }

    private void updateSums(double value) {
        ++this.counts;
        this.sum += value;
        this.squaredSum += value * value;
    }

    private void updateSums(double value, int counts) {
        this.counts += counts;
        this.sum += (double)counts * value;
        this.squaredSum += (double)counts * (value * value);
    }

    private void setExtrema(long timestamp, double value) {
        this.minimum = new Extremum(timestamp, value);
        this.maximum = new Extremum(timestamp, value);
    }

    private void updateExtrema(long timestamp, double value) {
        if (value < this.minimum.getValue()) {
            this.minimum.setValue(value);
            this.minimum.setTimestamp(timestamp);
        }
        if (value > this.maximum.getValue()) {
            this.maximum.setValue(value);
            this.maximum.setTimestamp(timestamp);
        }
    }

    private long getMinuteStartTimestamp(long timestampOfFirstEntry) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(timestampOfFirstEntry));
        calendar.set(13, 0);
        calendar.set(14, 0);
        long minuteStartTimestamp = calendar.getTime().getTime();
        return minuteStartTimestamp;
    }
}

