/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor.gui.tree;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.gui.ImageHolder;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class TreeRenderer
extends JLabel
implements TreeCellRenderer {
    private Icon m_iconRed;
    private Icon m_iconYellow;
    private Icon m_iconGreen;
    private Icon m_iconWhite;
    private static String EMPTY_STRING = "";

    public TreeRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        MappingTreeNode viewInfe = null;
        if (node instanceof MappingTreeNode) {
            viewInfe = (MappingTreeNode)node;
            int color = viewInfe.getColorRecursive();
            switch (color) {
                case 0: {
                    this.setIcon(this.m_iconWhite);
                    break;
                }
                case 3: {
                    this.setIcon(this.m_iconRed);
                    break;
                }
                case 2: {
                    this.setIcon(this.m_iconYellow);
                    break;
                }
                case 1: {
                    this.setIcon(this.m_iconGreen);
                    break;
                }
                default: {
                    this.setIcon(this.m_iconWhite);
                }
            }
        }
        String valueStr = EMPTY_STRING;
        if (viewInfe != null) {
            IMonitorNode monObject = viewInfe.getMonitorObject();
            if (monObject != null) {
                valueStr = monObject.getMostSignificantValueAsString();
            }
            valueStr = valueStr == null || valueStr.equals(EMPTY_STRING) ? EMPTY_STRING : " (" + valueStr + ")";
        }
        this.setText(viewInfe != null ? viewInfe.getName() + valueStr : "No Name");
        this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 10, retDimension.height);
        }
        return retDimension;
    }

    private void initImages() {
        try {
            this.m_iconRed = (ImageIcon)ImageHolder.aIconRed;
            this.m_iconYellow = (ImageIcon)ImageHolder.aIconYellow;
            this.m_iconGreen = (ImageIcon)ImageHolder.aIconGreen;
            this.m_iconWhite = (ImageIcon)ImageHolder.aIconWhite;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

