/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.monitor;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    private static final char COLUMN_SIGN = '|';
    private static final char LINE_SIGN = '-';
    private static Util util = new Util();

    private Util() {
    }

    public static Util getUtil() {
        return util;
    }

    public String[] convertObjectArray2StringArray(Object[] objArray) {
        String[] strArray = new String[objArray.length];
        int i = 0;
        while (i < objArray.length) {
            strArray[i] = (String)objArray[i];
            ++i;
        }
        return strArray;
    }

    public Vector tokenizer(String path, String delimiter) {
        StringTokenizer stringTokenizer = new StringTokenizer(path, delimiter);
        Vector<String> tokens = new Vector<String>();
        int tokenCount = stringTokenizer.countTokens();
        int i = 0;
        while (i < tokenCount) {
            String token = stringTokenizer.nextToken();
            tokens.add(token);
            ++i;
        }
        return tokens;
    }

    public synchronized void printTable(Serializable[] tableHeader, Serializable[][] tabEntries, PrintStream out) {
        boolean actElementLen = false;
        int lineLen = 0;
        Object it = null;
        Serializable[][] entries = null;
        List columnLenStatistic = null;
        entries = this.concatonateHeaderWithEntries(tableHeader, tabEntries);
        columnLenStatistic = this.getColumnLengthStatistics(entries);
        lineLen = this.getLineLen(columnLenStatistic);
        PrintStream printStream = out;
        synchronized (printStream) {
            this.printLineToFile(out, lineLen, '-');
            this.printTableCoreToFile(out, entries, columnLenStatistic, lineLen);
            this.printLineToFile(out, lineLen, '-');
            out.flush();
        }
    }

    private String adjustStringLengthRight(String start, int length, char fillChar) {
        int sl;
        if (start == null) {
            start = "";
        }
        if ((sl = start.length()) == length) {
            return start;
        }
        if (sl > length) {
            return start.substring(0, length);
        }
        StringBuffer result = new StringBuffer(length);
        result.append(start);
        int i = sl;
        while (i < length) {
            result.append(fillChar);
            ++i;
        }
        return result.toString();
    }

    private void printTableCoreToFile(PrintStream out, Serializable[][] entries, List columnLenList, int lineLen) {
        String tableElement = null;
        int maxElementLen = 0;
        int i = 0;
        while (i < entries.length) {
            out.print('|');
            int j = 0;
            while (j < entries[i].length) {
                tableElement = entries[i][j].toString();
                maxElementLen = (Integer)columnLenList.get(j);
                tableElement = this.adjustStringLengthRight(tableElement, maxElementLen, ' ');
                out.print(tableElement + '|');
                ++j;
            }
            out.println();
            if (i < entries.length - 1) {
                this.printLineToFile(out, lineLen, '-');
            }
            ++i;
        }
    }

    private Serializable[][] concatonateHeaderWithEntries(Serializable[] tableHeader, Serializable[][] tabEntries) {
        Serializable[][] table = new Serializable[tabEntries.length + 1][];
        table[0] = tableHeader;
        int k = 1;
        while (k <= tabEntries.length) {
            table[k] = tabEntries[k - 1];
            ++k;
        }
        return table;
    }

    private void printLineToFile(PrintStream out, int lineLen, char lineSymbol) {
        int i = 0;
        while (i < lineLen) {
            out.print(lineSymbol);
            ++i;
        }
        out.println("");
    }

    private List getColumnLengthStatistics(Serializable[][] tabEntries) {
        ArrayList<Integer> columnLenList = new ArrayList<Integer>();
        boolean maxElementLen = false;
        int actElementLen = 0;
        Integer maxElementLenInListInt = null;
        int maxElementLenInList = 0;
        int i = 0;
        while (i < tabEntries.length) {
            int j = 0;
            while (j < tabEntries[i].length) {
                actElementLen = tabEntries[i][j].toString().length();
                try {
                    maxElementLenInListInt = (Integer)columnLenList.get(j);
                    maxElementLenInList = maxElementLenInListInt;
                    if (actElementLen > maxElementLenInList) {
                        columnLenList.set(j, new Integer(actElementLen));
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                    columnLenList.add(j, new Integer(actElementLen));
                }
                ++j;
            }
            ++i;
        }
        return columnLenList;
    }

    private int getLineLen(List columnLenList) {
        int lineLen = 0;
        Iterator it = null;
        it = columnLenList.iterator();
        while (it.hasNext()) {
            lineLen += (Integer)it.next() + 1;
        }
        return lineLen + 1;
    }

    public static double round(double h) {
        double coef = 1.0;
        int sign = 1;
        if (h < 0.0) {
            sign = -1;
            h *= -1.0;
        }
        if (h > 1.0) {
            h *= 100.0;
            h = Math.round(h);
            h /= 100.0;
        } else if (h != 0.0) {
            while (h < 1.0) {
                h *= 100.0;
                coef *= 100.0;
            }
            h *= 100.0;
            h = Math.round(h);
            h /= coef * 100.0;
        }
        if (sign == -1) {
            h *= (double)sign;
        }
        return h;
    }
}

