/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.text;

import com.sap.i18n.text.Utf16String;

class Utf16StringTimeCheck {
    static final int OVERHEAD_NUM_OF_OP = 100000000;
    long m_overheadTimeEmptyLoop = 0L;
    long m_overheadTimeAddLoop = 0L;

    public Utf16StringTimeCheck() {
        this.timecheckOverheadEmptyLoop();
        this.timecheckOverheadAddLoop();
    }

    public static void main(String[] args) {
        Utf16StringTimeCheck utf16StringTimeCheck1 = new Utf16StringTimeCheck();
        utf16StringTimeCheck1.timecheckRemovePrefixJDK();
        utf16StringTimeCheck1.timecheckRemovePrefixUtf16();
        utf16StringTimeCheck1.timecheckSubstringBeforeJDK();
        utf16StringTimeCheck1.timecheckSubstringBeforeUtf16();
        utf16StringTimeCheck1.timecheckLimitLengthJDK();
        utf16StringTimeCheck1.timecheckLimitLengthUtf16();
        utf16StringTimeCheck1.timecheckSubstringFixedFormatJDK();
        utf16StringTimeCheck1.timecheckSubstringFixedFormatUtf16();
        utf16StringTimeCheck1.timecheckToUpperFirstCharJDK();
        utf16StringTimeCheck1.timecheckToUpperFirstCharUtf16();
        utf16StringTimeCheck1.timecheckCharAtJDK();
        utf16StringTimeCheck1.timecheckCharAtUtf16();
        System.out.println("finished");
    }

    public void timecheckOverheadEmptyLoop() {
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 100000000) {
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Empty", startLoop, endLoop, 100000000L);
        this.m_overheadTimeEmptyLoop = endLoop - startLoop;
    }

    public void timecheckOverheadAddLoop() {
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 100000000) {
            cnt += 5L;
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Add", startLoop, endLoop, 100000000L);
        this.m_overheadTimeAddLoop = endLoop - startLoop;
    }

    public void timecheckRemovePrefixJDK() {
        int NUM_OF_OP = 10000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            if (str.startsWith("Hello")) {
                String strSub = str.substring("Hello".length());
                cnt += 10L;
            }
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("JDKString.removePrefix", startLoop, endLoop, 10000000L);
    }

    public void timecheckRemovePrefixUtf16() {
        int NUM_OF_OP = 10000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            String strSub = Utf16String.removePrefix(str, "Hello");
            if (strSub != null) {
                cnt += 10L;
            }
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Utf16String.removePrefix", startLoop, endLoop, 10000000L);
    }

    public void timecheckSubstringBeforeJDK() {
        int NUM_OF_OP = 10000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            int delimIndex = str.indexOf(32);
            if (delimIndex != -1) {
                String strSub = str.substring(0, delimIndex);
                cnt += 10L;
            }
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("JDKString.SubstringBefore", startLoop, endLoop, 10000000L);
    }

    public void timecheckSubstringBeforeUtf16() {
        int NUM_OF_OP = 10000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            String strSub = Utf16String.substringBefore(str, ' ');
            if (strSub != null) {
                cnt += 10L;
            }
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Utf16String.SubstringBefore", startLoop, endLoop, 10000000L);
    }

    public void timecheckLimitLengthJDK() {
        int NUM_OF_OP = 10000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            String strLimit;
            if (str.length() > 5) {
                strLimit = str.substring(5);
                cnt += 10L;
            } else {
                strLimit = str;
            }
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("JDKString.LimitLength", startLoop, endLoop, 10000000L);
    }

    public void timecheckLimitLengthUtf16() {
        int NUM_OF_OP = 10000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            String strLimit = Utf16String.limitLength(str, 5);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Utf16String.LimitLength", startLoop, endLoop, 10000000L);
    }

    public void timecheckSubstringFixedFormatJDK() {
        int NUM_OF_OP = 10000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            String strsub = str.substring(3, 5);
            cnt += (long)strsub.length();
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("JDKString.SubstringFixedFormat", startLoop, endLoop, 10000000L);
    }

    public void timecheckSubstringFixedFormatUtf16() {
        int NUM_OF_OP = 10000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            String strsub = Utf16String.substringFixedFormat(str, 3, 5);
            cnt += (long)strsub.length();
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Utf16String.SubstringFixedFormat", startLoop, endLoop, 10000000L);
    }

    public void timecheckToUpperFirstCharJDK() {
        int NUM_OF_OP = 1000000;
        String str = "hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 1000000) {
            String strUpper = Character.toUpperCase(str.charAt(0)) + str.substring(1);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("JDKString.toUpperFirstChar", startLoop, endLoop, 1000000L);
    }

    public void timecheckToUpperFirstCharUtf16() {
        int NUM_OF_OP = 1000000;
        String str = "hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 1000000) {
            String strUpper = Utf16String.toUpperFirstChar(str);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Utf16String.toUpperFirstChar", startLoop, endLoop, 1000000L);
    }

    public void timecheckCharAtJDK() {
        int NUM_OF_OP = 100000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 100000000) {
            cnt += (long)str.charAt(1);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("JDKString.charAt", startLoop, endLoop, 100000000L);
    }

    public void timecheckCharAtUtf16() {
        int NUM_OF_OP = 100000000;
        String str = "Hello World";
        long cnt = 0L;
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while (i < 100000000) {
            cnt += (long)Utf16String.charAt(str, 1);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Utf16String.charAt", startLoop, endLoop, 100000000L);
    }

    private void timecheckPrintResult(String name, long startLoop, long endLoop, long numOp) {
        long timeLoop = endLoop - startLoop;
        long timeperopLoop = (endLoop - startLoop) * 1000L * 1000L / numOp;
        System.out.println("Time " + name + " Loop: " + timeLoop + " per op (ns): " + timeperopLoop);
    }
}

