/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.text;

import com.sap.i18n.text.Utf16StringBuffer;
import com.sap.tc.jtools.jver.framework.Test;
import com.sap.tc.jtools.jver.framework.TestAttributes;

public class Utf16StringBufferTest
extends Test {
    public static void main(String[] args) {
        Utf16StringBufferTest oTest = new Utf16StringBufferTest();
        oTest.testRemovePrefix();
        oTest.testRemovePostfix();
        oTest.testSubstringBefore();
        oTest.testSubstringBeforeStr();
        oTest.testSubstringAfter();
        oTest.testSubstringAfterStr();
        oTest.testToUpperFirstChar();
        oTest.testToUpper();
        oTest.testToLowerFirstChar();
        oTest.testToLower();
        oTest.testFoldCase();
        oTest.testNormalize();
        oTest.testLimitLength();
        oTest.testCombinedCharAt();
        oTest.testReverse();
        oTest.testSetLength();
        System.out.println("Finished");
    }

    public static TestAttributes getAttributes() {
        TestAttributes attributes = new TestAttributes();
        attributes.setFixtureForMethod(false);
        attributes.setInstantiationForMethod(false);
        return attributes;
    }

    public void prepare() {
    }

    public void cleanUp() {
    }

    public void testRemovePrefix() {
        this.verifyRemovePrefix("English char only", "Hello", "He", "llo");
        this.verifyRemovePrefix("Prefix not found", "Hello", "Hi", "Hello");
        this.verifyRemovePrefix("Prefix complete", "Hello", "Hello", "");
        this.verifyRemovePrefix("Non english char behind", "He\u00c4llo", "He", "\u00c4llo");
        this.verifyRemovePrefix("Combining char behind", "He\u20d0llo", "He", "\u20d0llo");
        this.verifyRemovePrefix("Combining char within", "He\u20d0llo", "He\u20d0", "llo");
    }

    private void verifyRemovePrefix(String checkName, String strRemovePrefixFrom, String strPrefix, String strExpectedSubstring) {
        StringBuffer strRemovePrefixFromBuf = new StringBuffer(strRemovePrefixFrom);
        Utf16StringBuffer.removePrefix(strRemovePrefixFromBuf, strPrefix);
        boolean bEqual = false;
        bEqual = strExpectedSubstring.equals(new String(strRemovePrefixFromBuf));
        this.verify(bEqual, checkName + ": removed \"" + strPrefix + "\" in \"" + strRemovePrefixFrom + "\" expected " + strExpectedSubstring + " got " + strRemovePrefixFromBuf, "Utf16StringBuffer.RemovePrefix");
    }

    public void testRemovePostfix() {
        this.verifyRemovePostfix("English char only", "Hello", "llo", "He");
        this.verifyRemovePostfix("Postfix not found", "Hello", "li", "Hello");
        this.verifyRemovePostfix("Postfix complete", "Hello", "Hello", "");
    }

    private void verifyRemovePostfix(String checkName, String strRemovePostfixFrom, String strPostfix, String strExpectedSubstring) {
        StringBuffer strRemovePostfixFromBuf = new StringBuffer(strRemovePostfixFrom);
        Utf16StringBuffer.removePostfix(strRemovePostfixFromBuf, strPostfix);
        boolean bEqual = false;
        bEqual = strExpectedSubstring.equals(new String(strRemovePostfixFromBuf));
        this.verify(bEqual, checkName + ": removed \"" + strPostfix + "\" in \"" + strRemovePostfixFrom + "\" expected " + strExpectedSubstring + " got " + strRemovePostfixFromBuf, "Utf16StringBuffer.RemovePostfix");
    }

    public void testSubstringBefore() {
        this.verifySubstringBefore("English char only", "Hello", 'l', "He");
        this.verifySubstringBefore("Delimiter not found", "Hello", 'x', null);
        this.verifySubstringBefore("Delimiter last char", "Hello", 'o', "Hell");
        this.verifySubstringBefore("Delimiter first char", "Hello", 'H', "");
        this.verifySubstringBefore("Combining char behind", "He\u20d0llo", 'e', "H");
        this.verifySubstringBefore("Combining char behind first", "Hel\u20d0lo", 'l', "He");
    }

    private void verifySubstringBefore(String checkName, String str, char delim, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        String strFoundSubstring = Utf16StringBuffer.substringBefore(strBuf, delim);
        boolean bEqual = false;
        bEqual = strExpectedSubstring == null ? strFoundSubstring == null : strExpectedSubstring.equals(strFoundSubstring);
        this.verify(bEqual, checkName + ": substring before '" + delim + "' in \"" + str + "\" expected " + strExpectedSubstring + " got " + strFoundSubstring, "Utf16StringBuffer.SubstringBefore");
    }

    public void testSubstringBeforeStr() {
        this.verifySubstringBeforeStr("English char only", "Hello", "ll", "He");
        this.verifySubstringBeforeStr("Delimiter not found", "Hello", "li", null);
        this.verifySubstringBeforeStr("Delimiter last char", "Hello", "o", "Hell");
        this.verifySubstringBeforeStr("Delimiter first char", "Hello", "H", "");
        this.verifySubstringBeforeStr("Combining char behind", "He\u20d0llo", "e", "H");
        this.verifySubstringBeforeStr("Combining char behind first", "Hel\u20d0lo", "l", "He");
    }

    private void verifySubstringBeforeStr(String checkName, String str, String delimstr, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        String strFoundSubstring = Utf16StringBuffer.substringBefore(strBuf, delimstr);
        boolean bEqual = false;
        bEqual = strExpectedSubstring == null ? strFoundSubstring == null : strExpectedSubstring.equals(strFoundSubstring);
        this.verify(bEqual, checkName + ": substring before \"" + delimstr + "\" in \"" + str + "\" expected " + strExpectedSubstring + " got " + strFoundSubstring, "Utf16StringBuffer.SubstringBefore");
    }

    public void testSubstringAfter() {
        this.verifySubstringAfter("English char only", "Hello", 'l', "lo");
        this.verifySubstringAfter("Delimiter not found", "Hello", 'x', null);
        this.verifySubstringAfter("Delimiter last char", "Hello", 'o', "");
        this.verifySubstringAfter("Delimiter first char", "Hello", 'H', "ello");
        this.verifySubstringAfter("Combining char behind", "He\u20d0llo", 'e', "\u20d0llo");
        this.verifySubstringAfter("Combining char behind first", "Hel\u20d0lo", 'l', "\u20d0lo");
    }

    private void verifySubstringAfter(String checkName, String str, char delim, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        String strFoundSubstring = Utf16StringBuffer.substringAfter(strBuf, delim);
        boolean bEqual = false;
        bEqual = strExpectedSubstring == null ? strFoundSubstring == null : strExpectedSubstring.equals(strFoundSubstring);
        this.verify(bEqual, checkName + ": substring after '" + delim + "' in \"" + str + "\" expected " + strExpectedSubstring + " got " + strFoundSubstring, "Utf16StringBuffer.SubstringAfter");
    }

    public void testSubstringAfterStr() {
        this.verifySubstringAfterStr("English char only", "Hello", "ll", "lo");
        this.verifySubstringAfterStr("Delimiter not found", "Hello", "li", null);
        this.verifySubstringAfterStr("Delimiter last char", "Hello", "o", "");
        this.verifySubstringAfterStr("Delimiter first char", "Hello", "H", "ello");
        this.verifySubstringAfterStr("Combining char behind", "He\u20d0llo", "e", "\u20d0llo");
        this.verifySubstringAfterStr("Combining char behind first", "Hel\u20d0lo", "l", "\u20d0lo");
    }

    private void verifySubstringAfterStr(String checkName, String str, String delimstr, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        String strFoundSubstring = Utf16StringBuffer.substringAfter(strBuf, delimstr);
        boolean bEqual = false;
        bEqual = strExpectedSubstring == null ? strFoundSubstring == null : strExpectedSubstring.equals(strFoundSubstring);
        this.verify(bEqual, checkName + ": substring after \"" + delimstr + "\" in \"" + str + "\" expected " + strExpectedSubstring + " got " + strFoundSubstring, "Utf16StringBuffer.SubstringAfter");
    }

    public void testLimitLength() {
        this.verifyLimitLength("English char only", "Hello", 3, "Hel");
        this.verifyLimitLength("Shorter than limit", "Hello", 6, "Hello");
        this.verifyLimitLength("As long as limit", "Hello", 5, "Hello");
        this.verifyLimitLength("Combining char behind", "Hel\u20d0lo", 3, "He");
        this.verifyLimitLength("Combining char behind+1", "Hel\u20d0lo", 2, "He");
        this.verifyLimitLength("Combining char at border", "Hel\u20d0lo", 4, "Hel\u20d0");
        this.verifyLimitLength("Combining char at second", "H\u20d0Hello", 1, "");
        this.verifyLimitLength("Combining sequence", "Hel\u20d0\u20d0lo", 4, "He");
        this.verifyLimitLength("Surrogate pair at border", "Hel\ud800\udc00", 4, "Hel");
        this.verifyLimitLength("Surrogate pair before border", "Hel\ud800\udc00", 5, "Hel\ud800\udc00");
        this.verifyLimitLength("Surrogate pair behind border", "Hel\ud800\udc00", 3, "Hel");
        this.verifyLimitLength("Virama behind border", "Hel\u094dlo", 3, "He");
        this.verifyLimitLength("Virama behind border+1", "Hel\u094dlo", 2, "He");
        this.verifyLimitLength("Virama at border", "Hel\u094dlo", 4, "He");
        this.verifyLimitLength("Virama at border -1 ", "Hel\u094dlo", 5, "Hel\u094dl");
        this.verifyLimitLength("Virama as second char ", "H\u094dello", 2, "");
        this.verifyLimitLength("Virama as first char ", "H\u094dello", 1, "");
    }

    private void verifyLimitLength(String checkName, String str, int limit, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        Utf16StringBuffer.limitLength(strBuf, limit);
        boolean bEqual = false;
        bEqual = strExpectedSubstring.equals(new String(strBuf));
        this.verify(bEqual, checkName + ": limit " + limit + " applied to \"" + str + "\" expected " + strExpectedSubstring + " got " + strBuf, "Utf16StringBuffer.LimitLength");
    }

    public void testSubstringFixedFormat() {
        this.verifySubstringFixedFormat("English char only", "Hello", 2, 4, "ll");
    }

    private void verifySubstringFixedFormat(String checkName, String str, int beginIndex, int endIndex, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        String strFoundSubstring = Utf16StringBuffer.substringFixedFormat(strBuf, beginIndex, endIndex);
        boolean bEqual = false;
        bEqual = strExpectedSubstring.equals(strFoundSubstring);
        this.verify(bEqual, checkName + ": substring from " + beginIndex + " to " + endIndex + " applied to \"" + str + "\" expected " + strExpectedSubstring + " got " + strFoundSubstring, "Utf16StringBuffer.SubstringFixedFormat");
    }

    public void testCharAt() {
        this.verifyCharAt("English char only", "Hello", 1, 101);
        this.verifyCharAt("Surrogate pair", "H\ud800\udc000ello", 1, 65536);
        this.verifyCharAt("Surrogate trail", "H\ud800\udc000ello", 2, 65533);
        this.verifyCharAt("Surrogate lead", "H\ud800ello", 1, 65533);
        this.verifyCharAt("Surrogate lead at end", "Hello\ud800", 5, 65533);
    }

    private void verifyCharAt(String checkName, String str, int index, int expectedChar) {
        StringBuffer strBuf = new StringBuffer(str);
        int foundChar = Utf16StringBuffer.charAt(strBuf, index);
        this.verify(foundChar == expectedChar, checkName + ": getChar at " + index + " of \"" + str + "\" expected " + expectedChar + " got " + foundChar, "Utf16StringBuffer.charAt");
    }

    public void testToUpperFirstChar() {
        this.verifyToUpperFirstChar("English char only", "Hello", "Hello");
        this.verifyToUpperFirstChar("Lower case", "hello", "Hello");
        this.verifyToUpperFirstChar("Surrogate", "\ud800\udc00Hello", "\ud800\udc00Hello");
        this.verifyToUpperFirstChar("Half surrogate", "\ud800Hello", "\ud800Hello");
        this.verifyToUpperFirstChar("One char", "h", "H");
    }

    private void verifyToUpperFirstChar(String checkName, String str, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        Utf16StringBuffer.toUpperFirstChar(strBuf);
        boolean bEqual = false;
        bEqual = strExpectedSubstring.equals(new String(strBuf));
        this.verify(bEqual, checkName + ": toUpperFirstChar of \"" + str + "\" expected " + strExpectedSubstring + " got " + strBuf, "Utf16StringBuffer.toUpperFirstChar");
    }

    public void testToUpper() {
        this.verifyToUpper("English char only", "HELLO", "HELLO");
        this.verifyToUpper("Lower case", "hello", "HELLO");
        this.verifyToUpper("Mixed", "HeLLo", "HELLO");
        this.verifyToUpper("Surrogate", "\ud800\udc00Hello", "\ud800\udc00HELLO");
        this.verifyToUpper("Half surrogate", "\ud800Hello", "\ud800HELLO");
        this.verifyToUpper("One char", "h", "H");
        this.verifyToUpper("i with dot", "i", "I");
        this.verifyToUpper("i without dot", "\u0131", "I");
    }

    private void verifyToUpper(String checkName, String str, String strExpected) {
        StringBuffer strBufFound = new StringBuffer(str);
        Utf16StringBuffer.toUpper(strBufFound);
        String strFound = strBufFound.toString();
        boolean bEqual = false;
        bEqual = strExpected.equals(strFound);
        this.verify(bEqual, checkName + ": toUpper of \"" + str + "\" expected " + strExpected + " got " + strFound, "Utf16StringBuffer.toUpper");
    }

    public void testToLowerFirstChar() {
        this.verifyToLowerFirstChar("English char only", "hello", "hello");
        this.verifyToLowerFirstChar("Upper case", "Hello", "hello");
        this.verifyToLowerFirstChar("Surrogate", "\ud800\udc00Hello", "\ud800\udc00Hello");
        this.verifyToLowerFirstChar("Half surrogate", "\ud800Hello", "\ud800Hello");
        this.verifyToLowerFirstChar("One char", "H", "h");
    }

    private void verifyToLowerFirstChar(String checkName, String str, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        Utf16StringBuffer.toLowerFirstChar(strBuf);
        boolean bEqual = false;
        bEqual = strExpectedSubstring.equals(new String(strBuf));
        this.verify(bEqual, checkName + ": toLowerFirstChar of \"" + str + "\" expected " + strExpectedSubstring + " got " + strBuf, "Utf16StringBuffer.toLowerFirstChar");
    }

    public void testToLower() {
        this.verifyToLower("English char only", "hello", "hello");
        this.verifyToLower("Upper case", "HELLO", "hello");
        this.verifyToLower("Mixed", "HeLLo", "hello");
        this.verifyToLower("Surrogate", "\ud800\udc00Hello", "\ud800\udc00hello");
        this.verifyToLower("Half surrogate", "\ud800Hello", "\ud800hello");
        this.verifyToLower("One char", "H", "h");
        this.verifyToLower("i without dot", "I", "i");
    }

    private void verifyToLower(String checkName, String str, String strExpected) {
        StringBuffer strBufFound = new StringBuffer(str);
        Utf16StringBuffer.toLower(strBufFound);
        String strFound = strBufFound.toString();
        boolean bEqual = false;
        bEqual = strExpected.equals(strFound);
        this.verify(bEqual, checkName + ": toLower of \"" + str + "\" expected " + strExpected + " got " + strFound, "Utf16StringBuffer.toLower");
    }

    public void testFoldCase() {
        this.verifyToLower("English char only", "hello", "hello");
        this.verifyToLower("Upper case", "HELLO", "hello");
        this.verifyToLower("Mixed", "HeLLo", "hello");
        this.verifyToLower("Surrogate", "\ud800\udc00Hello", "\ud800\udc00hello");
        this.verifyToLower("Half surrogate", "\ud800Hello", "\ud800hello");
        this.verifyToLower("One char", "H", "h");
        this.verifyToLower("i with dot", "\u0130", "i\u0307");
        this.verifyToLower("i without dot", "I", "i");
    }

    private void verifyFoldCase(String checkName, String str, String strExpected) {
        StringBuffer strBufFound = new StringBuffer(str);
        Utf16StringBuffer.foldCase(strBufFound);
        String strFound = strBufFound.toString();
        boolean bEqual = false;
        bEqual = strExpected.equals(strFound);
        this.verify(bEqual, checkName + ": foldCase of \"" + str + "\" expected " + strExpected + " got " + strFound, "Utf16StringBuffer.foldCase");
    }

    public void testNormalize() {
        this.verifyNormalize("English char only", "Hello", "Hello");
        this.verifyNormalize("Composed", "\u00c4", "\u00c4");
        this.verifyNormalize("Decomposed", "A\u0308", "\u00c4");
    }

    private void verifyNormalize(String checkName, String str, String strExpected) {
        StringBuffer strBufFound = new StringBuffer(str);
        Utf16StringBuffer.normalize(strBufFound);
        String strFound = strBufFound.toString();
        boolean bEqual = false;
        bEqual = strExpected.equals(strFound);
        this.verify(bEqual, checkName + ": normalize of \"" + str + "\" expected " + strExpected + " got " + strFound, "Utf16StringBuffer.normalize");
    }

    public void testCombinedCharAt() {
        this.verifyCombinedCharAt("English char only", "Hello", 2, "l");
        this.verifyCombinedCharAt("Surrogate", "He\ud800\udc00llo", 2, "\ud800\udc00");
        this.verifyCombinedCharAt("Half Surrogate", "He\ud800llo", 2, "\ufffd");
        this.verifyCombinedCharAt("Combining character behind", "Hel\u20d0lo", 2, "l\u20d0");
        this.verifyCombinedCharAt("Combining character at", "Hel\u20d0lo", 3, "\u20d0");
        this.verifyCombinedCharAt("Virama behind", "Hel\u094dlo", 2, "l\u094dl");
        this.verifyCombinedCharAt("Virama at end", "Hello\u094d", 5, "\u094d");
    }

    private void verifyCombinedCharAt(String checkName, String str, int index, String strExpectedSubstring) {
        StringBuffer strBuf = new StringBuffer(str);
        String strFoundSubstring = Utf16StringBuffer.combinedCharAt(strBuf, index);
        boolean bEqual = false;
        bEqual = strExpectedSubstring.equals(strFoundSubstring);
        this.verify(bEqual, checkName + ": combining char seq. of \"" + str + "\" at " + index + " expected " + strExpectedSubstring + " got " + strFoundSubstring, "Utf16StringBuffer.combinedCharAt");
    }

    public void testReverse() {
    }

    private void verifyReverse(String checkName, String str, String strExpectedReverse) {
        StringBuffer strBuf = new StringBuffer(str);
        Utf16StringBuffer.reverse(strBuf);
        String strFound = strBuf.toString();
        boolean bEqual = strExpectedReverse.equals(strFound);
        this.verify(bEqual, checkName + ": reverse of \"" + str + "\" expected " + strExpectedReverse + " got " + strFound, "Utf16StringBuffer.reverse");
    }

    public void testSetLength() {
        this.verifySetLength("English char only", "Hello", 3, "Hel");
        this.verifySetLength("Shorter than limit", "Hello", 6, "Hello\u0000");
        this.verifySetLength("limit 0", "Hello", 0, "");
        this.verifySetLength("As long as limit", "Hello", 5, "Hello");
        this.verifySetLength("Combining char behind", "Hel\u20d0lo", 3, "He\u0000");
        this.verifySetLength("Combining char behind+1", "Hel\u20d0lo", 2, "He");
        this.verifySetLength("Combining char at border", "Hel\u20d0lo", 4, "Hel\u20d0");
        this.verifySetLength("Combining char at second", "H\u20d0Hello", 1, "\u0000");
        this.verifySetLength("Combining sequence", "Hel\u20d0\u20d0lo", 4, "He\u0000\u0000");
        this.verifySetLength("Surrogate pair at border", "Hel\ud800\udc00", 4, "Hel\u0000");
        this.verifySetLength("Surrogate pair before border", "Hel\ud800\udc00", 5, "Hel\ud800\udc00");
        this.verifySetLength("Surrogate pair behind border", "Hel\ud800\udc00", 3, "Hel");
        this.verifySetLength("Virama behind border", "Hel\u094dlo", 3, "He\u0000");
        this.verifySetLength("Virama behind border+1", "Hel\u094dlo", 2, "He");
        this.verifySetLength("Virama at border", "Hel\u094dlo", 4, "He\u0000\u0000");
        this.verifySetLength("Virama at border -1 ", "Hel\u094dlo", 5, "Hel\u094dl");
        this.verifySetLength("Virama as second char ", "H\u094dello", 2, "\u0000\u0000");
        this.verifySetLength("Virama as first char ", "H\u094dello", 1, "\u0000");
    }

    private void verifySetLength(String checkName, String str, int nLength, String strExpected) {
        StringBuffer strBuf = new StringBuffer(str);
        Utf16StringBuffer.setLength(strBuf, nLength);
        String strFound = strBuf.toString();
        boolean bEqual = strExpected.equals(strFound);
        this.verify(bEqual, checkName + ": set length of \"" + str + " to " + nLength + "\" expected " + strExpected + " got " + strFound, "Utf16StringBuffer.setLength");
    }
}

