/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import java.util.Locale;

public class Utf16StringBuffer {
    static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    static final int HIGH_NON_SURROGATE_MIN_VALUE = 57344;
    static final int SURROGATE_PAIR_MIN_VALUE = 65536;

    public static boolean isCombiningCharAt(StringBuffer str, int index) {
        if (index == str.length()) {
            return false;
        }
        char ch = str.charAt(index);
        if (ch <= '\u007f') {
            return false;
        }
        int cat = UCharacter.getType(ch);
        boolean isCombining = cat == 6 || cat == 8 || cat == 7;
        return isCombining;
    }

    public static boolean isCombiningChar(int ch) {
        if (ch <= 127) {
            return false;
        }
        int cat = UCharacter.getType(ch);
        boolean isCombining = cat == 6 || cat == 8 || cat == 7;
        return isCombining;
    }

    public static void removePrefix(StringBuffer str, String prefix) {
        String strHelp = new String(str);
        if (strHelp.startsWith(prefix)) {
            str.delete(0, prefix.length());
        }
    }

    public static void removePostfix(StringBuffer str, String postfix) {
        String strHelp = new String(str);
        if (strHelp.endsWith(postfix)) {
            str.delete(str.length() - postfix.length(), str.length());
        }
    }

    public static String substringBefore(StringBuffer str, char delim) {
        String strHelp = new String(str);
        int delimIndex = strHelp.indexOf(delim);
        if (delimIndex != -1) {
            return str.substring(0, delimIndex);
        }
        return null;
    }

    public static String substringBefore(StringBuffer str, String delimstr) {
        String strHelp = new String(str);
        int delimIndex = strHelp.indexOf(delimstr);
        if (delimIndex != -1) {
            return str.substring(0, delimIndex);
        }
        return null;
    }

    public static String substringAfter(StringBuffer str, char delim) {
        String strHelp = new String(str);
        int delimIndex = strHelp.indexOf(delim);
        if (delimIndex != -1) {
            return str.substring(delimIndex + 1);
        }
        return null;
    }

    public static String substringAfter(StringBuffer str, String delimstr) {
        String strHelp = new String(str);
        int delimIndex = strHelp.indexOf(delimstr);
        if (delimIndex != -1) {
            return str.substring(delimIndex + 1);
        }
        return null;
    }

    public static void limitLength(StringBuffer str, int limit) {
        int strlen = str.length();
        if (strlen <= limit) {
            return;
        }
        if (limit == 0) {
            str.setLength(0);
            return;
        }
        if (Utf16StringBuffer.isCombiningCharAt(str, limit)) {
            if (limit > 1) {
                Utf16StringBuffer.limitLength(str, limit - 1);
            } else {
                str.setLength(0);
            }
            return;
        }
        char endChar = str.charAt(limit - 1);
        if (endChar <= '\u007f') {
            str.delete(limit, strlen);
            return;
        }
        if (endChar >= '\ud800' && endChar < '\udc00') {
            if (limit > 1) {
                Utf16StringBuffer.limitLength(str, limit - 1);
            } else {
                str.delete(0, strlen);
            }
            return;
        }
        if (Utf16StringBuffer.isVirama(endChar)) {
            if (limit > 2) {
                Utf16StringBuffer.limitLength(str, limit - 2);
            } else {
                str.delete(0, strlen);
            }
            return;
        }
        str.delete(limit, strlen);
    }

    private static boolean isVirama(int ch) {
        if (ch < 2304 || ch >= 3584) {
            return false;
        }
        return ch == 2509 || ch == 2381 || ch == 2765 || ch == 2637 || ch == 3277 || ch == 3405 || ch == 2893 || ch == 3021 || ch == 3149;
    }

    public static String substringFixedFormat(StringBuffer str, int beginIndex, int endIndex) {
        return str.substring(beginIndex, endIndex);
    }

    public static void toUpperFirstChar(StringBuffer str) {
        int firstCharUpper;
        int firstChar = Utf16StringBuffer.charAt(str, 0);
        if (firstChar == (firstCharUpper = UCharacter.toUpperCase(firstChar))) {
            return;
        }
        if (firstChar < 65536 && firstCharUpper < 65536) {
            str.setCharAt(0, (char)firstCharUpper);
        } else {
            str.replace(0, Utf16StringBuffer.countCodeUnits(firstChar), UTF16.valueOf(firstCharUpper));
        }
    }

    public static void toUpper(StringBuffer str) {
        String strUpper = UCharacter.toUpperCase(str.toString());
        str.setLength(0);
        str.append(strUpper);
    }

    public static void toLowerFirstChar(StringBuffer str) {
        int firstCharLower;
        int firstChar = Utf16StringBuffer.charAt(str, 0);
        if (firstChar == (firstCharLower = UCharacter.toLowerCase(firstChar))) {
            return;
        }
        if (firstChar < 65536 && firstCharLower < 65536) {
            str.setCharAt(0, (char)firstCharLower);
        } else {
            str.replace(0, Utf16StringBuffer.countCodeUnits(firstChar), UTF16.valueOf(firstCharLower));
        }
    }

    public static void toLower(StringBuffer str) {
        String strLower = UCharacter.toLowerCase(Locale.ENGLISH, str.toString());
        str.setLength(0);
        str.append(strLower);
    }

    public static void foldCase(StringBuffer str) {
        String strFoldCase = UCharacter.foldCase(str.toString(), true);
        str.setLength(0);
        str.append(strFoldCase);
    }

    public static void normalize(StringBuffer str) {
        int nSrcLen = str.length();
        char[] sSrc = new char[nSrcLen];
        str.getChars(0, nSrcLen, sSrc, 0);
        char[] sDst = new char[nSrcLen];
        int nDstLen = Normalizer.normalize(sSrc, sDst, Normalizer.NFC);
        if (nDstLen > nSrcLen) {
            nDstLen = nSrcLen;
        }
        str.setLength(0);
        str.append(sDst, 0, nDstLen);
    }

    public static int charAt(StringBuffer str, int index) {
        char ch = str.charAt(index);
        if (ch < '\ud800') {
            return ch;
        }
        if (ch < '\udc00') {
            char trail;
            if (index + 1 < str.length() && (trail = str.charAt(index + 1)) >= '\udc00' && trail < '\ue000') {
                return UCharacter.getCodePoint(ch, trail);
            }
            return 65533;
        }
        if (ch <= '\ue000') {
            return 65533;
        }
        return ch;
    }

    public static int countCodeUnits(int ch) {
        return ch < 65536 ? 1 : 2;
    }

    public static String combinedCharAt(StringBuffer str, int index) {
        StringBuffer strBuf = new StringBuffer();
        int strLen = str.length();
        int curChar = Utf16StringBuffer.charAt(str, index);
        Utf16StringBuffer.append(strBuf, curChar);
        int i = index + Utf16StringBuffer.countCodeUnits(curChar);
        while (i < strLen) {
            int prevChar = curChar;
            boolean bCombine = false;
            curChar = Utf16StringBuffer.charAt(str, i);
            if (prevChar > 127 && Utf16StringBuffer.isVirama(prevChar)) {
                bCombine = true;
            }
            if (curChar > 127 && Utf16StringBuffer.isCombiningChar(curChar)) {
                bCombine = true;
            }
            if (!bCombine) break;
            Utf16StringBuffer.append(strBuf, curChar);
            i += Utf16StringBuffer.countCodeUnits(curChar);
        }
        return strBuf.toString();
    }

    public static void append(StringBuffer str, int ch) {
        if (ch < 65536) {
            str.append((char)ch);
        } else {
            str.append(UTF16.getLeadSurrogate(ch));
            str.append(UTF16.getTrailSurrogate(ch));
        }
    }

    public static void reverse(StringBuffer str) {
    }

    public static void setLength(StringBuffer str, int nNewLen) {
        if (str.length() > nNewLen) {
            Utf16StringBuffer.limitLength(str, nNewLen);
        }
        str.setLength(nNewLen);
    }
}

