/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.sap.i18n.text.Utf16Char;
import com.sap.i18n.text.Utf16StringBuffer;
import java.util.Locale;

public class Utf16String {
    static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    static final int HIGH_NON_SURROGATE_MIN_VALUE = 57344;
    static final int SURROGATE_PAIR_MIN_VALUE = 65536;

    public static boolean isCombiningCharAt(String str, int index) {
        if (index == str.length()) {
            return false;
        }
        char ch = str.charAt(index);
        if (ch <= '\u007f') {
            return false;
        }
        int cat = UCharacter.getType(ch);
        boolean isCombining = cat == 6 || cat == 8 || cat == 7;
        return isCombining;
    }

    public static boolean isCombiningChar(int ch) {
        if (ch <= 127) {
            return false;
        }
        int cat = UCharacter.getType(ch);
        boolean isCombining = cat == 6 || cat == 8 || cat == 7;
        return isCombining;
    }

    public static String removePrefix(String str, String prefix) {
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return null;
    }

    public static String removePostfix(String str, String postfix) {
        if (str.endsWith(postfix)) {
            return str.substring(0, str.length() - postfix.length());
        }
        return null;
    }

    public static String substringBefore(String str, char delim) {
        int delimIndex = str.indexOf(delim);
        if (delimIndex != -1) {
            return str.substring(0, delimIndex);
        }
        return null;
    }

    public static String substringBefore(String str, String delimstr) {
        int delimIndex = str.indexOf(delimstr);
        if (delimIndex != -1) {
            return str.substring(0, delimIndex);
        }
        return null;
    }

    public static String substringAfter(String str, char delim) {
        int delimIndex = str.indexOf(delim);
        if (delimIndex != -1) {
            return str.substring(delimIndex + 1);
        }
        return null;
    }

    public static String substringAfter(String str, String delimstr) {
        int delimIndex = str.indexOf(delimstr);
        if (delimIndex != -1) {
            return str.substring(delimIndex + 1);
        }
        return null;
    }

    public static String limitLength(String str, int limit) {
        int strlen = str.length();
        if (strlen <= limit) {
            return str;
        }
        if (Utf16String.isCombiningCharAt(str, limit)) {
            if (limit > 1) {
                return Utf16String.limitLength(str, limit - 1);
            }
            return "";
        }
        char endChar = str.charAt(limit - 1);
        if (endChar <= '\u007f') {
            return str.substring(0, limit);
        }
        if (endChar >= '\ud800' && endChar < '\udc00') {
            if (limit > 1) {
                return Utf16String.limitLength(str, limit - 1);
            }
            return "";
        }
        if (Utf16String.isVirama(endChar)) {
            if (limit > 2) {
                return Utf16String.limitLength(str, limit - 2);
            }
            return "";
        }
        return str.substring(0, limit);
    }

    private static boolean isVirama(int ch) {
        if (ch < 2304 || ch >= 3584) {
            return false;
        }
        return ch == 2509 || ch == 2381 || ch == 2765 || ch == 2637 || ch == 3277 || ch == 3405 || ch == 2893 || ch == 3021 || ch == 3149;
    }

    public static String substringFixedFormat(String str, int beginIndex, int endIndex) {
        return str.substring(beginIndex, endIndex);
    }

    public static String toUpperFirstChar(String str) {
        int firstCharUpper;
        int firstChar = Utf16String.charAt(str, 0);
        if (firstChar == (firstCharUpper = UCharacter.toUpperCase(firstChar))) {
            return str;
        }
        if (firstChar < 65536 && firstCharUpper < 65536) {
            return (char)firstCharUpper + str.substring(1);
        }
        return UTF16.valueOf(firstCharUpper) + str.substring(Utf16Char.characterLength(firstChar));
    }

    public static String toUpper(String str) {
        return UCharacter.toUpperCase(Locale.ENGLISH, str);
    }

    public static String toLowerFirstChar(String str) {
        int firstCharLower;
        int firstChar = Utf16String.charAt(str, 0);
        if (firstChar == (firstCharLower = UCharacter.toLowerCase(firstChar))) {
            return str;
        }
        if (firstChar < 65536 && firstCharLower < 65536) {
            return (char)firstCharLower + str.substring(1);
        }
        return UTF16.valueOf(firstCharLower) + str.substring(Utf16Char.characterLength(firstChar));
    }

    public static String toLower(String str) {
        return UCharacter.toLowerCase(Locale.ENGLISH, str);
    }

    public static String foldCase(String str) {
        return UCharacter.foldCase(str, true);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        int nLen2;
        int nLen1 = str1.length();
        if (nLen1 != (nLen2 = str2.length())) {
            return false;
        }
        int ch1 = 0;
        int ch2 = 0;
        int i = 0;
        while (i < nLen1) {
            ch1 = Utf16String.charAt(str1, i);
            if (!Utf16Char.equalsIgnoreCase(ch1, ch2 = Utf16String.charAt(str2, i))) {
                return false;
            }
            i += Utf16Char.characterLength(ch1);
        }
        return true;
    }

    public static String normalize(String str) {
        int nSrcLen = str.length();
        char[] sSrc = new char[nSrcLen];
        str.getChars(0, nSrcLen, sSrc, 0);
        char[] sDst = new char[nSrcLen];
        int nDstLen = Normalizer.normalize(sSrc, sDst, Normalizer.NFC);
        if (nDstLen > nSrcLen) {
            nDstLen = nSrcLen;
        }
        return new String(sDst, 0, nDstLen);
    }

    public static int charAt(String str, int index) {
        char ch = str.charAt(index);
        if (ch < '\ud800') {
            return ch;
        }
        if (ch < '\udc00') {
            char trail;
            if (index + 1 < str.length() && (trail = str.charAt(index + 1)) >= '\udc00' && trail < '\ue000') {
                return UCharacter.getCodePoint(ch, trail);
            }
            return 65533;
        }
        if (ch <= '\ue000') {
            return 65533;
        }
        return ch;
    }

    public static String combinedCharAt(String str, int index) {
        StringBuffer strBuf = new StringBuffer();
        int strLen = str.length();
        int curChar = Utf16String.charAt(str, index);
        Utf16StringBuffer.append(strBuf, curChar);
        int i = index + Utf16Char.characterLength(curChar);
        while (i < strLen) {
            int prevChar = curChar;
            boolean bCombine = false;
            curChar = Utf16String.charAt(str, i);
            if (prevChar > 127 && Utf16String.isVirama(prevChar)) {
                bCombine = true;
            }
            if (curChar > 127 && Utf16String.isCombiningChar(curChar)) {
                bCombine = true;
            }
            if (!bCombine) break;
            Utf16StringBuffer.append(strBuf, curChar);
            i += Utf16Char.characterLength(curChar);
        }
        return strBuf.toString();
    }
}

