/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.text;

import com.sap.i18n.text.Utf16Char;
import com.sap.tc.jtools.jver.framework.Test;
import com.sap.tc.jtools.jver.framework.TestAttributes;

public class Utf16CharTest
extends Test {
    public static void main(String[] args) {
        Utf16CharTest oTest = new Utf16CharTest();
        oTest.testDigit09();
        oTest.testDigitHex();
        oTest.testDigitAny();
        oTest.testIsAscii();
        oTest.testIsPrintable();
        oTest.testIsLetter();
        oTest.testIsWhitespace();
        oTest.testEqualsIgnoreCase();
        oTest.testIsJavaIdentifierPart();
        oTest.testIsJavaIdentifierStart();
        oTest.testIsUnicodeIdentifierPart();
        oTest.testIsUnicodeIdentifierStart();
        oTest.testCharacterLength();
        oTest.testToChars();
    }

    public static TestAttributes getAttributes() {
        TestAttributes attributes = new TestAttributes();
        attributes.setFixtureForMethod(false);
        attributes.setInstantiationForMethod(false);
        return attributes;
    }

    public void prepare() {
    }

    public void cleanUp() {
    }

    public void testDigit09() {
        this.verifyDigit09("below 0", 47, -1);
        this.verifyDigit09("0", 48, 0);
        this.verifyDigit09("9", 57, 9);
        this.verifyDigit09("above 9", 58, -1);
        this.verifyDigit09("below A", 64, -1);
        this.verifyDigit09("A", 65, -1);
        this.verifyDigit09("F", 70, -1);
        this.verifyDigit09("above F", 71, -1);
        this.verifyDigit09("below a", 96, -1);
        this.verifyDigit09("a", 97, -1);
        this.verifyDigit09("f", 102, -1);
        this.verifyDigit09("above f", 103, -1);
        this.verifyDigit09("Other digit", 1632, -1);
    }

    private void verifyDigit09(String checkName, int chDigit, int nExpectedValue) {
        int nValue = Utf16Char.digit09(chDigit);
        boolean bIsExpected = nExpectedValue != -1;
        boolean bIs = Utf16Char.isDigit09(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is digit " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isDigit09");
        this.verify(nValue == nExpectedValue, checkName + ": digit value of " + chDigit + " expected " + nExpectedValue + " got " + nValue, "Utf16Char.digit09");
    }

    public void testDigitHex() {
        this.verifyDigitHex("below 0", 47, -1);
        this.verifyDigitHex("0", 48, 0);
        this.verifyDigitHex("9", 57, 9);
        this.verifyDigitHex("above 9", 58, -1);
        this.verifyDigitHex("below A", 64, -1);
        this.verifyDigitHex("A", 65, 10);
        this.verifyDigitHex("F", 70, 15);
        this.verifyDigitHex("above F", 71, -1);
        this.verifyDigitHex("below a", 96, -1);
        this.verifyDigitHex("a", 97, 10);
        this.verifyDigitHex("f", 102, 15);
        this.verifyDigitHex("above f", 103, -1);
        this.verifyDigitHex("Other digit", 1632, -1);
    }

    private void verifyDigitHex(String checkName, int chDigit, int nExpectedValue) {
        boolean bIsExpected = nExpectedValue != -1;
        boolean bIs = Utf16Char.isDigitHex(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is digit hex " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isDigitHex");
        int nValue = Utf16Char.digitHex(chDigit);
        this.verify(nValue == nExpectedValue, checkName + ": digit value of " + chDigit + " expected " + nExpectedValue + " got " + nValue, "Utf16Char.digitHex");
    }

    public void testDigitAny() {
        this.verifyDigitAny("below 0", 47, -1);
        this.verifyDigitAny("0", 48, 0);
        this.verifyDigitAny("9", 57, 9);
        this.verifyDigitAny("above 9", 58, -1);
        this.verifyDigitAny("below A", 64, -1);
        this.verifyDigitAny("A", 65, -1);
        this.verifyDigitAny("F", 70, -1);
        this.verifyDigitAny("above F", 71, -1);
        this.verifyDigitAny("below a", 96, -1);
        this.verifyDigitAny("a", 97, -1);
        this.verifyDigitAny("f", 102, -1);
        this.verifyDigitAny("above f", 103, -1);
        this.verifyDigitAny("Other digit", 1632, 0);
    }

    private void verifyDigitAny(String checkName, int chDigit, int nExpectedValue) {
        int nValue = Utf16Char.digitAny(chDigit);
        boolean bIsExpected = nExpectedValue != -1;
        boolean bIs = Utf16Char.isDigitAny(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is digit " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isDigitAny");
        this.verify(nValue == nExpectedValue, checkName + ": digit value of " + chDigit + " expected " + nExpectedValue + " got " + nValue, "Utf16Char.digitAny");
    }

    public void testIsAscii() {
        this.verifyIsAscii("below 0x20", 31, false);
        this.verifyIsAscii("0x20", 32, true);
        this.verifyIsAscii("0x7E", 126, true);
        this.verifyIsAscii("0x7F", 127, false);
        this.verifyIsAscii("above 0x80", 128, false);
    }

    private void verifyIsAscii(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isAscii(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is ascii " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isAscii");
    }

    public void testIsPrintable() {
        this.verifyIsPrintable("control", 31, false);
        this.verifyIsPrintable("space", 32, true);
        this.verifyIsPrintable("letter", 65, true);
        this.verifyIsPrintable("non latin-1 letter", 913, true);
        this.verifyIsPrintable("non latin-1 non letter", 8224, true);
        this.verifyIsPrintable("format char", 8206, false);
    }

    private void verifyIsPrintable(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isPrintable(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is printable " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isPrintable");
    }

    public void testIsLetter() {
        this.verifyIsLetter("control", 31, false);
        this.verifyIsLetter("space", 32, false);
        this.verifyIsLetter("digit", 48, false);
        this.verifyIsLetter("letter", 65, true);
        this.verifyIsLetter("non latin-1 letter", 913, true);
        this.verifyIsLetter("non latin-1 non letter", 8224, false);
        this.verifyIsLetter("non latin-1 digit", 1632, false);
        this.verifyIsLetter("non latin-1 sign", 8364, false);
        this.verifyIsLetter("format char", 8206, false);
    }

    private void verifyIsLetter(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isLetter(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is letter " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isLetter");
    }

    public void testIsLetterOrDigit() {
        this.verifyIsLetterOrDigit("control", 31, false);
        this.verifyIsLetterOrDigit("space", 32, false);
        this.verifyIsLetterOrDigit("digit", 48, true);
        this.verifyIsLetterOrDigit("letter", 65, true);
        this.verifyIsLetterOrDigit("non latin-1 letter", 913, true);
        this.verifyIsLetterOrDigit("non latin-1 non letter", 8224, false);
        this.verifyIsLetterOrDigit("non latin-1 digit", 1632, true);
        this.verifyIsLetterOrDigit("non latin-1 sign", 8364, false);
        this.verifyIsLetterOrDigit("format char", 8206, false);
    }

    private void verifyIsLetterOrDigit(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isLetterOrDigit(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is letter or digit" + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isLetterOrDigit");
    }

    public void testIsWhitespace() {
        this.verifyIsWhitespace("tab", 13, true);
        this.verifyIsWhitespace("lf", 10, true);
        this.verifyIsWhitespace("cr", 19, false);
        this.verifyIsWhitespace("control", 31, true);
        this.verifyIsWhitespace("space", 32, true);
        this.verifyIsWhitespace("digit", 48, false);
        this.verifyIsWhitespace("letter", 65, false);
        this.verifyIsWhitespace("non latin-1 letter", 913, false);
        this.verifyIsWhitespace("non latin-1 non letter", 8224, false);
        this.verifyIsWhitespace("non latin-1 digit", 1632, false);
        this.verifyIsWhitespace("non latin-1 sign", 8364, false);
        this.verifyIsWhitespace("format char", 8206, false);
    }

    private void verifyIsWhitespace(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isWhitespace(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is whitespace" + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isWhitespace");
    }

    public void testEqualsIgnoreCase() {
        this.verifyEqualsIgnoreCase("same char", 32, 32, true);
        this.verifyEqualsIgnoreCase("different char", 32, 65, false);
        this.verifyEqualsIgnoreCase("lower + upperr", 97, 65, true);
        this.verifyEqualsIgnoreCase("upper + lower", 65, 97, true);
        this.verifyEqualsIgnoreCase("different letter", 65, 66, false);
    }

    private void verifyEqualsIgnoreCase(String checkName, int chDigit1, int chDigit2, boolean bEqualExpected) {
        boolean bEqual = Utf16Char.equalsIgnoreCase(chDigit1, chDigit2);
        this.verify(bEqual == bEqualExpected, checkName + ": " + chDigit1 + " is equal " + chDigit2 + " expected " + bEqualExpected + " got " + bEqual, "Utf16Char.EqualsIgnoreCase");
    }

    public void testIsJavaIdentifierPart() {
        this.verifyIsJavaIdentifierPart("control", 31, false);
        this.verifyIsJavaIdentifierPart("space", 32, false);
        this.verifyIsJavaIdentifierPart("digit", 48, true);
        this.verifyIsJavaIdentifierPart("letter", 65, true);
        this.verifyIsJavaIdentifierPart("underscore", 95, true);
        this.verifyIsJavaIdentifierPart("dollar", 36, true);
        this.verifyIsJavaIdentifierPart("non latin-1 letter", 913, true);
        this.verifyIsJavaIdentifierPart("non latin-1 non letter", 8224, false);
        this.verifyIsJavaIdentifierPart("non latin-1 digit", 1632, true);
        this.verifyIsJavaIdentifierPart("format char", 8206, true);
    }

    private void verifyIsJavaIdentifierPart(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isJavaIdentifierPart(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is Java identifier part " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isJavaIdentifierPart");
    }

    public void testIsJavaIdentifierStart() {
        this.verifyIsJavaIdentifierStart("control", 31, false);
        this.verifyIsJavaIdentifierStart("space", 32, false);
        this.verifyIsJavaIdentifierStart("digit", 48, false);
        this.verifyIsJavaIdentifierStart("letter", 65, true);
        this.verifyIsJavaIdentifierStart("underscore", 95, true);
        this.verifyIsJavaIdentifierStart("dollar", 36, true);
        this.verifyIsJavaIdentifierStart("non latin-1 letter", 913, true);
        this.verifyIsJavaIdentifierStart("non latin-1 non letter", 8224, false);
        this.verifyIsJavaIdentifierStart("non latin-1 digit", 1632, false);
        this.verifyIsJavaIdentifierStart("format char", 8206, false);
    }

    private void verifyIsJavaIdentifierStart(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isJavaIdentifierStart(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is Java identifier start " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isJavaIdentifierStart");
    }

    public void testIsUnicodeIdentifierPart() {
        this.verifyIsUnicodeIdentifierPart("control", 31, false);
        this.verifyIsUnicodeIdentifierPart("space", 32, false);
        this.verifyIsUnicodeIdentifierPart("digit", 48, true);
        this.verifyIsUnicodeIdentifierPart("letter", 65, true);
        this.verifyIsUnicodeIdentifierPart("underscore", 95, true);
        this.verifyIsUnicodeIdentifierPart("dollar", 36, false);
        this.verifyIsUnicodeIdentifierPart("non latin-1 letter", 913, true);
        this.verifyIsUnicodeIdentifierPart("non latin-1 non letter", 8224, false);
        this.verifyIsUnicodeIdentifierPart("non latin-1 digit", 1632, true);
        this.verifyIsUnicodeIdentifierPart("format char", 8206, true);
    }

    private void verifyIsUnicodeIdentifierPart(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isUnicodeIdentifierPart(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is Unicode identifier part " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isUnicodeIdentifierPart");
    }

    public void testIsUnicodeIdentifierStart() {
        this.verifyIsUnicodeIdentifierStart("control", 31, false);
        this.verifyIsUnicodeIdentifierStart("space", 32, false);
        this.verifyIsUnicodeIdentifierStart("digit", 48, false);
        this.verifyIsUnicodeIdentifierStart("letter", 65, true);
        this.verifyIsUnicodeIdentifierStart("underscore", 95, false);
        this.verifyIsUnicodeIdentifierStart("dollar", 36, false);
        this.verifyIsUnicodeIdentifierStart("non latin-1 letter", 913, true);
        this.verifyIsUnicodeIdentifierStart("non latin-1 non letter", 8224, false);
        this.verifyIsUnicodeIdentifierStart("non latin-1 digit", 1632, false);
        this.verifyIsUnicodeIdentifierStart("format char", 8206, false);
    }

    private void verifyIsUnicodeIdentifierStart(String checkName, int chDigit, boolean bIsExpected) {
        boolean bIs = Utf16Char.isUnicodeIdentifierStart(chDigit);
        this.verify(bIs == bIsExpected, checkName + ": is Unicode identifier start " + chDigit + " expected " + bIsExpected + " got " + bIs, "Utf16Char.isUnicodeIdentifierStart");
    }

    public void testCharacterLength() {
        this.verifyCharacterLength("English", 65, 1);
        this.verifyCharacterLength("National", 8364, 1);
        this.verifyCharacterLength("Supplementary", 65536, 2);
    }

    private void verifyCharacterLength(String checkName, int chDigit, int nLenExpected) {
        int nLen = Utf16Char.characterLength(chDigit);
        this.verify(nLen == nLenExpected, checkName + ": character length " + chDigit + " expected " + nLenExpected + " got " + nLen, "Utf16Char.verifyCharacterLength");
    }

    public void testToChars() {
        this.verifyToChars("English", 65, new char[]{'A'});
        this.verifyToChars("National", 8364, new char[]{'\u20ac'});
        this.verifyToChars("Supplementary", 65536, new char[]{'\ud800', '\udc00'});
    }

    private void verifyToChars(String checkName, int chDigit, char[] acExpected) {
        char[] ac = Utf16Char.toChars(chDigit);
        this.verify(new String(ac).equals(new String(acExpected)), checkName + ": to chars " + chDigit + " expected " + acExpected + " got " + ac, "Utf16Char.verifyToChars");
    }
}

