/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;

public class Utf16Char {
    static final int SURROGATE_PAIR_MIN_VALUE = 65536;

    public static int digit09(int ch) {
        if (48 <= ch && ch <= 57) {
            return ch - 48;
        }
        return -1;
    }

    public static int digitHex(int ch) {
        if (48 <= ch && ch <= 57) {
            return ch - 48;
        }
        if (65 <= ch && ch <= 70) {
            return ch - 65 + 10;
        }
        if (97 <= ch && ch <= 102) {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static int digitAny(int ch) {
        return UCharacter.digit(ch);
    }

    public static boolean isDefined(int ch) {
        return UCharacter.isDefined(ch);
    }

    public static boolean isDigit09(int ch) {
        return 48 <= ch && ch <= 57;
    }

    public static boolean isDigitHex(int ch) {
        if (48 <= ch && ch <= 57) {
            return true;
        }
        if (65 <= ch && ch <= 70) {
            return true;
        }
        return 97 <= ch && ch <= 102;
    }

    public static boolean isDigitAny(int ch) {
        return UCharacter.isDigit(ch);
    }

    public static boolean isAscii(int ch) {
        return 32 <= ch && ch < 127;
    }

    public static boolean isPrintable(int ch) {
        return UCharacter.isPrintable(ch);
    }

    public static boolean isLetter(int ch) {
        return UCharacter.isLetter(ch);
    }

    public static boolean isLetterOrDigit(int ch) {
        return UCharacter.isLetterOrDigit(ch);
    }

    public static boolean isWhitespace(int ch) {
        return UCharacter.isWhitespace(ch);
    }

    public static boolean equalsIgnoreCase(int ch1, int ch2) {
        return UCharacter.toLowerCase(ch1) == UCharacter.toLowerCase(ch2);
    }

    public static boolean isJavaIdentifierPart(int ch) {
        return Character.isJavaIdentifierPart((char)ch);
    }

    public static boolean isJavaIdentifierStart(int ch) {
        return Character.isJavaIdentifierStart((char)ch);
    }

    public static boolean isUnicodeIdentifierPart(int ch) {
        return UCharacter.isUnicodeIdentifierPart((char)ch);
    }

    public static boolean isUnicodeIdentifierStart(int ch) {
        return UCharacter.isUnicodeIdentifierStart((char)ch);
    }

    public static int characterLength(int ch) {
        return ch < 65536 ? 1 : 2;
    }

    public static char[] toChars(int ch) {
        return UTF16.valueOf(ch).toCharArray();
    }
}

