/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

public final class CollationKey
implements Comparable {
    private String m_source_;
    private byte[] m_key_;
    private int m_hashCode_;

    public CollationKey(String source, byte[] key) {
        this.m_source_ = source;
        this.m_key_ = key;
        this.m_hashCode_ = 0;
    }

    public String getSourceString() {
        return this.m_source_;
    }

    public byte[] toByteArray() {
        int length = 0;
        while (this.m_key_[length] != 0) {
            ++length;
        }
        byte[] result = new byte[++length];
        System.arraycopy(this.m_key_, 0, result, 0, length);
        return result;
    }

    public int compareTo(CollationKey target) {
        int i = 0;
        while (this.m_key_[i] != 0 && target.m_key_[i] != 0) {
            byte key = this.m_key_[i];
            byte targetkey = target.m_key_[i];
            if (key == targetkey) {
                ++i;
                continue;
            }
            if (key >= 0) {
                if (targetkey < 0 || key < targetkey) {
                    return -1;
                }
                return 1;
            }
            if (targetkey >= 0 || key > targetkey) {
                return 1;
            }
            return -1;
        }
        if (this.m_key_[i] == target.m_key_[i]) {
            return 0;
        }
        if (this.m_key_[i] == 0) {
            return -1;
        }
        return 1;
    }

    public int compareTo(Object obj) {
        return this.compareTo((CollationKey)obj);
    }

    public boolean equals(Object target) {
        if (!(target instanceof CollationKey)) {
            return false;
        }
        return this.equals((CollationKey)target);
    }

    public boolean equals(CollationKey target) {
        if (this == target) {
            return true;
        }
        if (target == null) {
            return false;
        }
        CollationKey other = target;
        int i = 0;
        while (true) {
            if (this.m_key_[i] != other.m_key_[i]) {
                return false;
            }
            if (this.m_key_[i] == 0) break;
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (this.m_hashCode_ == 0) {
            int size = this.m_key_.length >> 1;
            StringBuffer key = new StringBuffer(size);
            int i = 0;
            while (this.m_key_[i] != 0 && this.m_key_[i + 1] != 0) {
                key.append((char)(this.m_key_[i] << 8 | this.m_key_[i + 1]));
                i += 2;
            }
            if (this.m_key_[i] != 0) {
                key.append((char)(this.m_key_[i] << 8));
            }
            this.m_hashCode_ = key.toString().hashCode();
        }
        return this.m_hashCode_;
    }
}

