/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ICUListResourceBundle
extends ListResourceBundle {
    private static final String ICUDATA = "ICUDATA";
    private static final String ICU_BUNDLE_NAME = "LocaleElements";
    private static final String ICU_PACKAGE_NAME = "com.ibm.icu.impl.data";
    private static final String ENCODING = "UTF-8";
    private Hashtable visited = new Hashtable();
    protected Object[][] contents;
    private Object[][] realContents;

    protected ICUListResourceBundle() {
    }

    protected Object[][] getContents() {
        if (this.realContents == null) {
            this.realContents = this.contents;
            int i = 0;
            while (i < this.contents.length) {
                Object newValue = this.getRedirectedResource((String)this.contents[i][0], this.contents[i][1]);
                if (newValue != null) {
                    if (this.realContents == this.contents) {
                        this.realContents = (Object[][])this.contents.clone();
                    }
                    this.realContents[i] = new Object[]{this.contents[i][0], newValue};
                }
                ++i;
            }
        }
        return this.realContents;
    }

    private Object getRedirectedResource(String key, Object value) {
        if (value instanceof Object[][]) {
            Object[][] aValue = (Object[][])value;
            int i = 0;
            while (i < aValue.length) {
                int j = 0;
                while (j < aValue[i].length) {
                    aValue[i][j] = this.getRedirectedResource((String)aValue[i][0], aValue[i][j]);
                    ++j;
                }
                ++i;
            }
        } else {
            if (value instanceof Alias) {
                String cName = this.getClass().getName();
                this.visited.clear();
                this.visited.put(cName + key, "");
                return ((Alias)value).getResource(cName, key, this.visited);
            }
            if (value instanceof RedirectedResource) {
                return ((RedirectedResource)value).getResource(this);
            }
        }
        return value;
    }

    private static byte[] readToEOS(InputStream stream) {
        ArrayList<byte[]> vec = new ArrayList<byte[]>();
        int count = 0;
        int pos = 0;
        int MAXLENGTH = 32768;
        int length = 128;
        do {
            pos = 0;
            length = length >= 32768 ? 32768 : length * 2;
            byte[] buffer = new byte[length];
            try {
                int n;
                while ((n = stream.read(buffer, pos, length - pos)) != -1 && (pos += n) < length) {
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            vec.add(buffer);
            count += pos;
        } while (pos == length);
        byte[] data = new byte[count];
        pos = 0;
        int i = 0;
        while (i < vec.size()) {
            byte[] buf = (byte[])vec.get(i);
            int len = Math.min(buf.length, count - pos);
            System.arraycopy(buf, 0, data, pos, len);
            pos += len;
            ++i;
        }
        return data;
    }

    private static char[] readToEOS(InputStreamReader stream) {
        ArrayList<char[]> vec = new ArrayList<char[]>();
        int count = 0;
        int pos = 0;
        int MAXLENGTH = 32768;
        int length = 128;
        do {
            pos = 0;
            length = length >= 32768 ? 32768 : length * 2;
            char[] buffer = new char[length];
            try {
                int n;
                while ((n = stream.read(buffer, pos, length - pos)) != -1 && (pos += n) < length) {
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            vec.add(buffer);
            count += pos;
        } while (pos == length);
        char[] data = new char[count];
        pos = 0;
        int i = 0;
        while (i < vec.size()) {
            char[] buf = (char[])vec.get(i);
            int len = Math.min(buf.length, count - pos);
            System.arraycopy(buf, 0, data, pos, len);
            pos += len;
            ++i;
        }
        return data;
    }

    public static class Alias {
        private final char RES_PATH_SEP_CHAR = (char)47;
        private String pathToResource;

        public Alias(String path) {
            this.pathToResource = path;
        }

        private Object getResource(String className, String parentKey, Hashtable visited) {
            int i;
            String packageName = null;
            String bundleName = null;
            String locale = null;
            String keyPath = null;
            if (this.pathToResource.indexOf(47) == 0) {
                i = this.pathToResource.indexOf(47, 1);
                int j = this.pathToResource.indexOf(47, i + 1);
                bundleName = this.pathToResource.substring(1, i);
                locale = this.pathToResource.substring(i + 1);
                if (j != -1) {
                    locale = this.pathToResource.substring(i + 1, j);
                    keyPath = this.pathToResource.substring(j + 1, this.pathToResource.length());
                }
                if (bundleName.equals(ICUListResourceBundle.ICUDATA)) {
                    bundleName = ICUListResourceBundle.ICU_BUNDLE_NAME;
                    packageName = ICUListResourceBundle.ICU_PACKAGE_NAME;
                }
            } else {
                i = this.pathToResource.indexOf(47);
                int j = className.lastIndexOf(".");
                packageName = className.substring(0, j);
                bundleName = className.substring(j + 1, className.indexOf("_"));
                keyPath = this.pathToResource.substring(i + 1);
                if (i != -1) {
                    locale = this.pathToResource.substring(0, i);
                } else {
                    locale = keyPath;
                    keyPath = parentKey;
                    className = packageName + "." + bundleName + "_" + locale;
                }
            }
            ResourceBundle bundle = null;
            bundle = ICULocaleData.getResourceBundle(packageName, bundleName, locale);
            return this.findResource(bundle, className, keyPath, visited);
        }

        private boolean isIndex(String s) {
            if (s.length() == 1) {
                char c = s.charAt(0);
                return Character.isDigit(c);
            }
            return false;
        }

        private int getIndex(String s) {
            char c;
            if (s.length() == 1 && Character.isDigit(c = s.charAt(0))) {
                return Integer.valueOf(s);
            }
            return -1;
        }

        private Object findResource(Object[][] contents, String key) {
            int i = 0;
            while (i < contents.length) {
                String tempKey = (String)contents[i][0];
                Object value = contents[i][1];
                if (tempKey == null || value == null) {
                    throw new NullPointerException();
                }
                if (tempKey.equals(key)) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        private Object findResource(Object o, String[] keys, int start) {
            Object obj = o;
            if (start < keys.length && keys[start] != null) {
                if (obj instanceof Object[][]) {
                    obj = this.findResource((Object[][])obj, keys[start]);
                } else if (obj instanceof Object[] && this.isIndex(keys[start])) {
                    obj = ((Object[])obj)[this.getIndex(keys[start])];
                }
                if (start + 1 < keys.length && keys[start + 1] != null) {
                    obj = this.findResource(obj, keys, start + 1);
                }
            }
            return obj;
        }

        private Object findResource(ResourceBundle bundle, String className, String key, Hashtable visited) {
            if (key == null) {
                return ((ICUListResourceBundle)bundle).getContents();
            }
            if (visited.get(className + key) != null) {
                throw new MissingResourceException("Circular Aliases in bundle.", bundle.getClass().getName(), key);
            }
            visited.put(className + key, "");
            String[] keys = this.split(key, '/');
            Object o = null;
            if (keys.length > 0) {
                o = bundle.getObject(keys[0]);
                o = this.findResource(o, keys, 1);
            }
            o = this.resolveAliases(o, className, key, visited);
            return o;
        }

        private Object resolveAliases(Object o, String className, String key, Hashtable visited) {
            if (o instanceof Object[][]) {
                o = this.resolveAliases((Object[][])o, className, key, visited);
            } else if (o instanceof Object[]) {
                o = this.resolveAliases((Object[])o, className, key, visited);
            } else if (o instanceof Alias) {
                return ((Alias)o).getResource(className, key, visited);
            }
            return o;
        }

        private Object resolveAliases(Object[][] o, String className, String key, Hashtable visited) {
            int i = 0;
            while (i < o.length) {
                o[i][1] = this.resolveAliases(o[i][1], className, key, visited);
                ++i;
            }
            return o;
        }

        private Object resolveAliases(Object[] o, String className, String key, Hashtable visited) {
            int i = 0;
            while (i < o.length) {
                o[i] = this.resolveAliases(o[i], className, key, visited);
                ++i;
            }
            return o;
        }

        private String[] split(String source, char delimiter) {
            char[] src = source.toCharArray();
            int index = 0;
            int numdelimit = 0;
            int i = 0;
            while (i < source.length()) {
                if (src[i] == delimiter) {
                    ++numdelimit;
                }
                ++i;
            }
            String[] values = null;
            values = new String[numdelimit + 2];
            int old = 0;
            int j = 0;
            while (j < src.length) {
                if (src[j] == delimiter) {
                    values[index++] = new String(src, old, j - old);
                    old = j + 1;
                }
                ++j;
            }
            if (old < src.length) {
                values[index++] = new String(src, old, src.length - old);
            }
            return values;
        }
    }

    public static class ResourceString
    implements RedirectedResource {
        private char[] expanded = null;
        private String resName = null;

        public ResourceString(String name) {
            this.resName = name;
        }

        public Object getResource(Object obj) {
            if (this.expanded == null) {
                InputStream stream = obj.getClass().getResourceAsStream(this.resName);
                if (stream == null) {
                    throw new MissingResourceException("", obj.getClass().getName(), this.resName);
                }
                try {
                    InputStreamReader reader = new InputStreamReader(stream, ICUListResourceBundle.ENCODING);
                    this.expanded = ICUListResourceBundle.readToEOS(reader);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("Could open converter for encoding: UTF-8");
                }
            }
            return new String(this.expanded);
        }
    }

    public static class ResourceBinary
    implements RedirectedResource {
        private byte[] expanded = null;
        private String resName = null;

        public ResourceBinary(String name) {
            this.resName = name;
        }

        public Object getResource(Object obj) {
            if (this.expanded == null) {
                InputStream stream = obj.getClass().getResourceAsStream(this.resName);
                if (stream == null) {
                    throw new MissingResourceException("", obj.getClass().getName(), this.resName);
                }
                this.expanded = ICUListResourceBundle.readToEOS(stream);
            }
            return this.expanded;
        }
    }

    private static interface RedirectedResource {
        public Object getResource(Object var1);
    }

    public static class CompressedBinary
    implements RedirectedResource {
        private byte[] expanded = null;
        private String compressed = null;

        public CompressedBinary(String str) {
            this.compressed = str;
        }

        public Object getResource(Object obj) {
            if (this.compressed == null) {
                return null;
            }
            if (this.expanded == null) {
                this.expanded = Utility.RLEStringToByteArray(this.compressed);
            }
            return this.expanded;
        }
    }
}

