/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.xmlcomparator;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLComparator {
    String[] fileNames;
    private static final short OPT_SUN_JDK = 1;
    private static final short OPT_IBM_JDK = 2;
    private static final short OPT_WINDOWS = 4;
    private static final short OPT_HP_UX = 8;
    private static final short OPT_SOLARIS = 16;
    private static final short OPT_IBM_TOR = 32;
    private static final short OPT_APPLE = 64;
    private static final short OPT_ICU = 128;
    private static final short OPT_OTHER = 256;
    private static final short OPT_SOURCE = 288;
    private static final short OPT_DEST = 320;
    private static final short OPT_OUT1 = 352;
    private static final short OPT_OUT2 = 384;
    private static final short OPT_UNKNOWN = 4096;
    private static final String POSIX = "0";
    private static final String ICU = "1";
    private static final String[][] USER_OPTIONS = new String[][]{{"-sun_jdk", "sun_jdk", "1"}, {"-ibm_jdk", "ibm_jdk", "1"}, {"-windows", "windows", "0"}, {"-hp_ux", "hp_ux", "0"}, {"-solaris", "solaris", "0"}, {"-ibm_tor", "ibm_toronto", "0"}, {"-apple", "apple", "0"}, {"-icu", "icu", "1"}, {"-other", "other", "0"}, {"-s", null, null}, {"-d", null, null}, {"-out1", null, null}};
    Hashtable optionTable = new Hashtable();
    private String sourceFolder = ".";
    private String destFolder = ".";
    private boolean out1 = false;
    private boolean out2 = false;
    ArrayList doesNotExist = new ArrayList();
    ArrayList notAvailable = new ArrayList();
    Document resultDocument;
    String localeStr;
    Locale locale;
    Calendar cal = Calendar.getInstance();
    private String goldFileName;
    private String goldKey;
    private Document goldDoc = null;
    boolean canonical = false;
    String encoding = "UTF-8";
    double args1 = 1.0E10;
    double args2 = -1.0E10;
    DecimalFormat fmt = new DecimalFormat();

    public static void main(String[] args) {
        XMLComparator comparator = new XMLComparator();
        comparator.processArgs(args);
    }

    private void processArgs(String[] args) {
        short options = this.identifyOptions(args);
        if (args.length < 2 || (options & 0x1000) != 0) {
            this.printUsage();
            return;
        }
        boolean[] warning = new boolean[]{false};
        Enumeration enumeration = this.optionTable.keys();
        try {
            NodeList list;
            String key;
            this.resultDocument = this.parse(this.sourceFolder + File.separator + "ResultXML.xml");
            this.localeStr = this.goldFileName.substring(this.goldFileName.lastIndexOf(File.separatorChar) + 1, this.goldFileName.indexOf(46));
            this.locale = new Locale(this.localeStr.substring(0, this.localeStr.indexOf(95)), this.localeStr.substring(this.localeStr.indexOf(95) + 1, this.localeStr.length()));
            OutputStreamWriter os1 = new OutputStreamWriter((OutputStream)new FileOutputStream(this.destFolder + File.separator + this.locale + ".xml"), this.encoding);
            OutputStreamWriter os2 = new OutputStreamWriter((OutputStream)new FileOutputStream(this.destFolder + File.separator + this.locale + ".html"), this.encoding);
            while (enumeration.hasMoreElements()) {
                String key2 = (String)enumeration.nextElement();
                String fileName = (String)this.optionTable.get(key2);
                this.compare(this.goldFileName, this.goldKey, fileName, key2, this.out1);
            }
            Iterator iter = ((AbstractList)this.doesNotExist).iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                list = this.resultDocument.getElementsByTagName(key);
                this.addNodeValue(list, key, "S.N.A", null);
            }
            this.notAvailable.add("solaris");
            this.notAvailable.add("apple");
            this.notAvailable.add("other");
            this.notAvailable.add("open_office");
            iter = ((AbstractList)this.notAvailable).iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                list = this.resultDocument.getElementsByTagName(key);
                this.addNodeValue(list, key, "S.N.A", null);
            }
            PrintWriter writer1 = new PrintWriter(os1);
            PrintWriter writer2 = new PrintWriter(os2);
            this.print(writer1, this.resultDocument);
            if (this.out1) {
                this.printHTML_1(writer2);
            } else {
                this.printHTML(writer2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printUsage() {
        System.err.println("Usage: XMLComparator [<option>:<gold>] filename1 [option] filename2 ... \n XMLComparator [-sun_jdk:gold]  filename [-ibm_jdk] filename [-windows] filename [-hp_ux]  filename [-solaris] filename [-ibm_tor] filename [-apple] filename [-icu] filename [-other] filename");
    }

    private short identifyOptions(String[] options) {
        short result = 0;
        int j = 0;
        while (j < options.length) {
            String option = options[j];
            boolean isGold = false;
            if (option.startsWith("-")) {
                if (option.indexOf(":gold") > 0) {
                    option = option.substring(0, option.indexOf(":"));
                    isGold = true;
                }
                boolean optionRecognized = false;
                int i = 0;
                while (i < USER_OPTIONS.length) {
                    if (USER_OPTIONS[i][0].equals(option)) {
                        result = (short)(result | (short)(1 << i));
                        optionRecognized = true;
                        if (i == 9) {
                            this.sourceFolder = options[++j];
                            break;
                        }
                        if (i == 10) {
                            this.destFolder = options[++j];
                            break;
                        }
                        if (i == 11) {
                            this.out1 = true;
                            break;
                        }
                        if (!isGold) {
                            this.optionTable.put(USER_OPTIONS[i][1], options[++j]);
                            break;
                        }
                        this.goldFileName = options[++j];
                        this.goldKey = USER_OPTIONS[i][1];
                        break;
                    }
                    i = (short)(i + 1);
                }
                if (!optionRecognized) {
                    result = (short)(result | 0x1000);
                }
            }
            ++j;
        }
        return result;
    }

    private void printHTML(PrintWriter writer) {
        NodeList list = this.resultDocument.getElementsByTagName("difference_element");
        writer.println("<html>\n    <head>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n        <title>" + this.locale + "</title>\n" + "    </head>\n" + "    <body>\n" + "        <p><b>" + this.locale + "</b></p>\n" + "        <table border=\"1\" cellspacing=\"0\">\n" + "            <tr>\n" + "                <th>ParentNode</th>\n" + "                <th>Name</th>\n" + "                <th>ID</th>\n" + "                <th>ICU 2.1</th>\n" + "                <th>IBM Toronto</th>\n" + "                <th>Windows 2000</th>\n" + "                <th>Sun JDK 1.3</th>\n" + "                <th>IBM JDK 1.3</th>\n" + "                <th>Solaris</th>\n" + "                <th>Apple</th>\n" + "                <th>HPUX 11</th>\n" + "                <th>Open Office</th>\n" + "                <th>Other</th>\n" + "            </tr>\n");
        int i = 0;
        while (i < list.getLength()) {
            Node diffElem = list.item(i);
            writer.println("            <tr>\n");
            NamedNodeMap attrb = diffElem.getAttributes();
            if (!attrb.item(0).getNodeValue().equals("test")) {
                writer.println("                <td>" + attrb.item(0).getNodeValue() + "</td>");
                writer.println("                <td>" + attrb.item(1).getNodeValue() + "</td>");
                writer.println("                <td>" + attrb.item(3).getNodeValue() + "</td>");
                NodeList childList = diffElem.getChildNodes();
                int j = 0;
                while (j < childList.getLength()) {
                    Node current = childList.item(j);
                    if (current != null && current.getNodeType() == 1) {
                        String val = current.getFirstChild().getNodeValue();
                        if (val == null || (val = this.trim(val)).equals("")) {
                            val = "&nbsp;";
                        }
                        writer.println("                <td>" + val + "</td>");
                    }
                    ++j;
                }
                writer.println("            </tr>\n");
            }
            ++i;
        }
        writer.println("        </table>\n    </body>\n</html>");
        writer.flush();
    }

    private void printHTML_1(PrintWriter writer) {
        NodeList list = this.resultDocument.getElementsByTagName("difference_element");
        writer.println("<html>\n    <head>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n        <title>" + this.localeStr + "</title>\n" + "    </head>\n" + "    <body>\n" + "        <p><b>" + this.localeStr + "(" + this.locale.getDisplayLanguage() + "_" + this.locale.getDisplayCountry() + ")</b></p>\n" + "        <table border=\"1\" cellspacing=\"0\">\n" + "            <tr>\n" + "                <th>ParentNode</th>\n" + "                <th>Name</th>\n" + "                <th>ID</th>\n" + "                <th>ICU 2.1</th>\n" + "                <th>IBM Toronto</th>\n" + "                <th>Windows 2000</th>\n" + "                <th>Sun JDK 1.3</th>\n" + "                <th>IBM JDK 1.3</th>\n" + "                <th>Solaris</th>\n" + "                <th>Apple</th>\n" + "                <th>HPUX 11</th>\n" + "                <th>Open Office</th>\n" + "                <th>Other</th>\n" + "            </tr>\n");
        Hashtable<String, String> colorHash = new Hashtable<String, String>();
        colorHash.put("icu", "#D3D3D3");
        colorHash.put("ibm_toronto", "#FF7777");
        colorHash.put("windows", "#98FB98");
        colorHash.put("sun_jdk", "#DDDDFF");
        colorHash.put("ibm_jdk", "#FFBBBB");
        colorHash.put("hp_ux", "#FFE4B5");
        colorHash.put("apple", "#FFBBBB");
        colorHash.put("solaris", "#E0FFFF");
        colorHash.put("other", "#CCCCFF");
        boolean hasData = false;
        int i = 0;
        while (i < list.getLength()) {
            Node diffElem = list.item(i);
            NamedNodeMap attrb = diffElem.getAttributes();
            if (!attrb.item(0).getNodeValue().equals("test") && !attrb.item(0).getNodeValue().equals("identity")) {
                writer.println("            <tr>\n");
                writer.println("                <td>" + attrb.item(0).getNodeValue() + "</td>");
                writer.println("                <td>" + attrb.item(1).getNodeValue() + "</td>");
                writer.println("                <td>" + attrb.item(3).getNodeValue() + "</td>");
                NodeList childList = diffElem.getChildNodes();
                int j = 0;
                while (j < childList.getLength()) {
                    Node current = childList.item(j);
                    if (current != null && current.getNodeType() == 1) {
                        String val = current.getFirstChild().getNodeValue();
                        if (val == null || (val = this.trim(val)).equals("")) {
                            val = "&nbsp;";
                        }
                        String color = "#FFFFFF";
                        if (!val.equals("S.N.A") && !val.equals("&nbsp;")) {
                            int k = 0;
                            while (k < childList.getLength()) {
                                String nVal;
                                Node n = childList.item(k);
                                if (n != null && n.getNodeType() == 1 && !(nVal = n.getFirstChild().getNodeValue()).equals("S.N.A") && !val.equals("&nbsp;") && (val.equals(nVal) || attrb.item(1).getNodeValue().equals("pattern") && this.comparePatterns(val, nVal) || attrb.item(0).getNodeValue().equals("patterns") && this.comparePatterns(val, nVal))) {
                                    String str = (String)colorHash.get(n.getNodeName());
                                    if (str == null) break;
                                    color = str;
                                    break;
                                }
                                ++k;
                            }
                        }
                        if (!val.equals("S.N.A")) {
                            NamedNodeMap attList = current.getAttributes();
                            if (attList.getNamedItem("case_diff").getNodeValue().equals("false")) {
                                writer.println("                <td bgcolor=" + color + ">" + val + "</td>");
                            } else {
                                writer.println("                <td bgcolor=" + color + ">" + val + "<font color=#A52A2A> (case difference only)</font>" + "</td>");
                            }
                            hasData = true;
                        }
                    }
                    ++j;
                }
                writer.println("            </tr>\n");
            }
            ++i;
        }
        writer.println("        </table>\n");
        if (!hasData) {
            writer.println("       <p><font size=16 color=#FF0000> Data exists only in ICU </font></p>\n");
        }
        writer.println("        <p>Created on: " + this.cal.getTime() + "</p>\n" + "    </body>\n" + "</html>");
        writer.flush();
    }

    public Document getFullyResolvedLocale(String localeName, String fileName) {
        Document doc = this.parse(localeName);
        String temp = localeName;
        if (temp.indexOf("icu") >= 0 || temp.indexOf("jdk") >= 0) {
            int index = -1;
            while ((index = temp.indexOf("_")) > 0 && index > fileName.lastIndexOf("\\")) {
                Document parentDoc = this.parse(temp = temp.substring(0, index) + ".xml");
                if (parentDoc == null) continue;
                this.mergeElements(doc.getDocumentElement(), parentDoc.getDocumentElement());
            }
        }
        String rootFileName = "";
        if (fileName.lastIndexOf(File.pathSeparatorChar) != -1) {
            rootFileName = fileName.substring(0, fileName.lastIndexOf(File.pathSeparatorChar) + 1);
        }
        rootFileName = rootFileName + "root.xml";
        Document rootDoc = this.parse(rootFileName);
        this.mergeElements(doc.getDocumentElement(), rootDoc.getDocumentElement());
        return doc;
    }

    public boolean compare(String goldFileName, String goldKey, String testFileName, String testKey, boolean mergeData) {
        if (this.goldDoc == null) {
            this.goldDoc = this.getFullyResolvedLocale(goldKey, goldFileName);
        }
        Document testDoc = null;
        if (this.goldDoc != null) {
            testDoc = this.getFullyResolvedLocale(testKey, testFileName);
        }
        if (null == this.goldDoc) {
            this.doesNotExist.add(goldKey);
            return false;
        }
        if (null == testDoc) {
            this.doesNotExist.add(testKey);
            return false;
        }
        if (mergeData) {
            return this.extractMergeData(this.goldDoc, goldKey, testDoc, testKey);
        }
        return this.compareElementsAndData(this.goldDoc, goldKey, testDoc, testKey);
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\'': {
                    str.append("&apos;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public void print(PrintWriter out, Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    out.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
                }
                NodeList children = node.getChildNodes();
                int iChild = 0;
                while (iChild < children.getLength()) {
                    this.print(out, children.item(iChild));
                    ++iChild;
                }
                out.flush();
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    out.print(' ');
                    out.print(attr.getNodeName());
                    out.print("=\"");
                    out.print(this.normalize(attr.getNodeValue()));
                    out.print('\"');
                    ++i;
                }
                out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i2 = 0;
                while (i2 < len) {
                    this.print(out, children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.print(out, children.item(i));
                        ++i;
                    }
                    break;
                }
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.println("?>");
                break;
            }
        }
        if (type == 1) {
            out.print("</");
            out.print(node.getNodeName());
            out.print('>');
        }
        out.flush();
    }

    private void addNodeValue(NodeList list, String nodeName, String nodeValue, String caseDiff) {
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (nodeName.equals(node.getNodeName())) {
                node.getFirstChild().setNodeValue(nodeValue);
                if (caseDiff != null) {
                    NamedNodeMap attr = node.getAttributes();
                    Node case_diff = attr.getNamedItem("case_diff");
                    case_diff.setNodeValue(caseDiff);
                }
            }
            ++i;
        }
    }

    private void addElement(String parentNode, String childNode, String attr, String nodeName1, String value1, String nodeName2, String value2) {
        String caseDiff = null;
        if (Normalizer.compare(value1, value2, 0) != 0 && Normalizer.compare(value1, value2, 65536) == 0) {
            caseDiff = "true";
        }
        String id = attr != null ? parentNode + "_" + childNode + "_" + attr : parentNode + "_" + childNode;
        Element element = this.resultDocument.getElementById(id);
        NodeList nodes = null;
        NamedNodeMap attribMap = null;
        Node rootNode = this.resultDocument.getElementsByTagName("difference_xml").item(0);
        if (element != null) {
            nodes = element.getChildNodes();
            attribMap = element.getAttributes();
        } else {
            NodeList nodeList = this.resultDocument.getElementsByTagName("difference_element");
            Node node = nodeList.item(0).cloneNode(true);
            attribMap = node.getAttributes();
            nodes = node.getChildNodes();
        }
        this.addNodeValue(nodes, nodeName1, value1, nodeName1.equals(this.goldKey) ? null : caseDiff);
        this.addNodeValue(nodes, nodeName2, value2, nodeName2.equals(this.goldKey) ? null : caseDiff);
        Node parent_node = attribMap.getNamedItem("parent_node");
        Node node_name = attribMap.getNamedItem("node_name");
        Node id_attrib = attribMap.getNamedItem("id");
        Node index = attribMap.getNamedItem("index");
        parent_node.setNodeValue(parentNode);
        node_name.setNodeValue(childNode);
        id_attrib.setNodeValue(id);
        index.setNodeValue(attr == null ? "&nbsp;" : attr);
        rootNode.appendChild(nodes.item(0).getParentNode());
    }

    private void addDifference(String parentNode, String childNode, String attr, String nodeName1, String value1, String nodeName2, String value2) {
        if (Normalizer.compare(value1, value2, 0) == 0) {
            return;
        }
        String caseDiff = null;
        if (Normalizer.compare(value1, value2, 65536) == 0) {
            caseDiff = "true";
        }
        String id = attr != null ? parentNode + "_" + childNode + "_" + attr : parentNode + "_" + childNode;
        Element element = this.resultDocument.getElementById(id);
        NodeList nodes = null;
        NamedNodeMap attribMap = null;
        Node rootNode = this.resultDocument.getElementsByTagName("difference_xml").item(0);
        if (element != null) {
            nodes = element.getChildNodes();
            attribMap = element.getAttributes();
        } else {
            NodeList nodeList = this.resultDocument.getElementsByTagName("difference_element");
            Node node = nodeList.item(0).cloneNode(true);
            attribMap = node.getAttributes();
            nodes = node.getChildNodes();
        }
        this.addNodeValue(nodes, nodeName1, value1, caseDiff);
        this.addNodeValue(nodes, nodeName2, value2, caseDiff);
        Node parent_node = attribMap.getNamedItem("parent_node");
        Node node_name = attribMap.getNamedItem("node_name");
        Node id_attrib = attribMap.getNamedItem("id");
        Node index = attribMap.getNamedItem("index");
        parent_node.setNodeValue(parentNode);
        node_name.setNodeValue(childNode);
        id_attrib.setNodeValue(id);
        index.setNodeValue(attr == null ? "&nbsp;" : attr);
        rootNode.appendChild(nodes.item(0).getParentNode());
    }

    private void mergeElements(Node dest, Node source) {
        Document destDoc = dest.getOwnerDocument();
        Text spaces = destDoc.createTextNode("\n       ");
        Node childOfSource = source.getFirstChild();
        while (childOfSource != null) {
            if (childOfSource.getNodeType() == 1 && !childOfSource.getNodeName().equals("collation") && !childOfSource.getNodeName().equals("timeZoneNames")) {
                boolean didMerge = false;
                Node childOfDest = dest.getFirstChild();
                while (childOfDest != null) {
                    if (childOfDest.getNodeType() == 1 && childOfDest.getNodeName().equals(childOfSource.getNodeName())) {
                        this.mergeElements(childOfDest, childOfSource);
                        didMerge = true;
                        break;
                    }
                    childOfDest = childOfDest.getNextSibling();
                }
                if (!didMerge) {
                    Node importedNode = destDoc.importNode(childOfSource, true);
                    dest.appendChild(spaces);
                    dest.appendChild(importedNode);
                }
            }
            childOfSource = childOfSource.getNextSibling();
        }
    }

    private boolean comparePatterns(String pat1, String pat2) {
        this.fmt.applyPattern(pat1);
        String s1 = this.fmt.format(this.args1);
        String s3 = this.fmt.format(this.args2);
        this.fmt.applyPattern(pat2);
        String s2 = this.fmt.format(this.args1);
        String s4 = this.fmt.format(this.args2);
        return s1.equals(s2) && s3.equals(s4);
    }

    private boolean compareElementsAndData(Node goldNode, String goldKey, Document testDoc, String testKey) {
        Node childOfSource = goldNode.getFirstChild();
        while (childOfSource != null) {
            if (!(childOfSource.getNodeType() != 1 || childOfSource.getNodeName().equals("collation") || childOfSource.getNodeName().equals("timeZoneNames") || childOfSource.getNodeName().equals("versioning"))) {
                NamedNodeMap attr = childOfSource.getAttributes();
                NodeList destList = testDoc.getElementsByTagName(childOfSource.getNodeName());
                Node sourceID = attr.getNamedItem("id");
                int i = 0;
                while (i < destList.getLength()) {
                    Node destNode = destList.item(i);
                    NamedNodeMap destAttr = destNode.getAttributes();
                    Node destID = destAttr.getNamedItem("id");
                    if (destID != null && sourceID != null) {
                        String sourceNodeVal;
                        String destNodeVal;
                        String destVal;
                        String sourceVal = sourceID.getNodeValue();
                        if (sourceVal.equals(destVal = destID.getNodeValue()) && destNode.hasChildNodes() && childOfSource.hasChildNodes() && destNode.getParentNode().getNodeName().equals(childOfSource.getParentNode().getNodeName()) && !(destNodeVal = this.trim(destNode.getFirstChild().getNodeValue())).equals(sourceNodeVal = this.trim(childOfSource.getFirstChild().getNodeValue()))) {
                            boolean write = true;
                            String parentNodeName = this.trim(childOfSource.getParentNode().getNodeName());
                            String childNodeName = this.trim(childOfSource.getNodeName());
                            if (childNodeName.equals("pattern") && this.comparePatterns(sourceNodeVal, destNodeVal)) {
                                write = false;
                            }
                            if (write) {
                                this.addDifference(parentNodeName, childNodeName, destVal, testKey, destNodeVal, goldKey, sourceNodeVal);
                            }
                        }
                    } else if (destNode.getNodeName().equals(childOfSource.getNodeName()) && destNode.getParentNode().getNodeName().equals(childOfSource.getParentNode().getNodeName()) && destNode.hasChildNodes() && childOfSource.hasChildNodes()) {
                        String destNodeVal = this.trim(destNode.getFirstChild().getNodeValue());
                        String sourceNodeVal = this.trim(childOfSource.getFirstChild().getNodeValue());
                        String attID = null;
                        if (!destNodeVal.equals(sourceNodeVal)) {
                            boolean write = true;
                            String parentNodeName = childOfSource.getParentNode().getNodeName();
                            String childNodeName = childOfSource.getNodeName();
                            if (childNodeName.equals("pattern") && this.comparePatterns(sourceNodeVal, destNodeVal)) {
                                write = false;
                            }
                            if (write) {
                                this.addDifference(parentNodeName, childNodeName, attID, testKey, destNodeVal, goldKey, sourceNodeVal);
                            }
                        }
                    }
                    ++i;
                }
                this.compareElementsAndData(childOfSource, goldKey, testDoc, testKey);
            }
            childOfSource = childOfSource.getNextSibling();
        }
        return true;
    }

    private String trim(String source) {
        char[] src = source.toCharArray();
        char[] dest = new char[src.length];
        int start = 0;
        while (start < src.length && (UCharacter.isWhitespace(src[start]) || src[start] == '\u00a0')) {
            ++start;
        }
        int stop = src.length - 1;
        while (stop > 0 && (UCharacter.isWhitespace(src[stop]) || src[stop] == '\u00a0')) {
            --stop;
        }
        if (stop != -1 && start != src.length) {
            System.arraycopy(src, start, dest, 0, stop - start + 1);
            return new String(dest, 0, stop - start + 1);
        }
        return new String();
    }

    private boolean extractMergeData(Node goldNode, String goldKey, Document testDoc, String testKey) {
        Node childOfSource = goldNode.getFirstChild();
        while (childOfSource != null) {
            if (!(childOfSource.getNodeType() != 1 || childOfSource.getNodeName().equals("collation") || childOfSource.getNodeName().equals("timeZoneNames") || childOfSource.getNodeName().equals("versioning"))) {
                NamedNodeMap attr = childOfSource.getAttributes();
                NodeList destList = testDoc.getElementsByTagName(childOfSource.getNodeName());
                Node sourceID = attr.getNamedItem("id");
                int i = 0;
                while (i < destList.getLength()) {
                    Node destNode = destList.item(i);
                    NamedNodeMap destAttr = destNode.getAttributes();
                    Node destID = destAttr.getNamedItem("id");
                    if (destID != null && sourceID != null) {
                        String destIDVal;
                        String sourceIDVal = sourceID.getNodeValue();
                        if (sourceIDVal.equals(destIDVal = destID.getNodeValue()) && destNode.hasChildNodes() && childOfSource.hasChildNodes() && destNode.getParentNode().getNodeName().equals(childOfSource.getParentNode().getNodeName())) {
                            String destNodeVal = this.trim(destNode.getFirstChild().getNodeValue());
                            String sourceNodeVal = this.trim(childOfSource.getFirstChild().getNodeValue());
                            String parentNodeName = this.trim(childOfSource.getParentNode().getNodeName());
                            String childNodeName = this.trim(childOfSource.getNodeName());
                            if (sourceNodeVal.length() != 0) {
                                this.addElement(parentNodeName, childNodeName, destIDVal, testKey, destNodeVal, goldKey, sourceNodeVal);
                            }
                        }
                    } else if (destNode.getNodeName().equals(childOfSource.getNodeName()) && destNode.getParentNode().getNodeName().equals(childOfSource.getParentNode().getNodeName()) && destNode.hasChildNodes() && childOfSource.hasChildNodes()) {
                        String destNodeVal = this.trim(destNode.getFirstChild().getNodeValue());
                        String sourceNodeVal = this.trim(childOfSource.getFirstChild().getNodeValue());
                        String parentNodeName = this.trim(childOfSource.getParentNode().getNodeName());
                        String childNodeName = this.trim(childOfSource.getNodeName());
                        if (sourceNodeVal.length() != 0) {
                            this.addElement(parentNodeName, childNodeName, null, testKey, destNodeVal, goldKey, sourceNodeVal);
                        }
                    }
                    ++i;
                }
                this.extractMergeData(childOfSource, goldKey, testDoc, testKey);
            }
            childOfSource = childOfSource.getNextSibling();
        }
        return true;
    }

    public static String filenameToURL(String filename) {
        if (null == filename) {
            return null;
        }
        if (filename.startsWith("file:") || filename.startsWith("http:") || filename.startsWith("ftp:") || filename.startsWith("gopher:") || filename.startsWith("mailto:") || filename.startsWith("news:") || filename.startsWith("telnet:")) {
            return filename;
        }
        File f = new File(filename);
        String tmp = null;
        try {
            tmp = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            tmp = f.getAbsolutePath();
        }
        if (File.separatorChar == '\\') {
            tmp = tmp.replace('\\', '/');
        }
        if (tmp.startsWith("/")) {
            return "file://" + tmp;
        }
        return "file:///" + tmp;
    }

    Document parse(String filename) {
        String docURI = XMLComparator.filenameToURL(filename);
        return this.parse(new InputSource(docURI), filename);
    }

    Document parse(InputSource docSrc, String filename) {
        Document doc;
        block7: {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            ErrorHandler nullHandler = new ErrorHandler(){

                public void warning(SAXParseException e) throws SAXException {
                    System.err.println("Warning: " + e.getMessage());
                }

                public void error(SAXParseException e) throws SAXException {
                    System.err.println("Error: " + e.getMessage());
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }
            };
            doc = null;
            try {
                DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                docBuilder.setErrorHandler(nullHandler);
                doc = docBuilder.parse(docSrc);
            }
            catch (Throwable se) {
                System.out.println("ERROR :" + se.toString());
                try {
                    throw new RuntimeException("XMLComparator no HTML parser!");
                }
                catch (Exception e) {
                    if (filename == null) break block7;
                    try {
                        String tmp;
                        FileReader fr = new FileReader(filename);
                        BufferedReader br = new BufferedReader(fr);
                        StringBuffer buffer = new StringBuffer();
                        while ((tmp = br.readLine()) != null) {
                            buffer.append(tmp);
                            buffer.append("\n");
                        }
                        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                        doc = docBuilder.newDocument();
                        Element outElem = doc.createElement("out");
                        Text textNode = doc.createTextNode(buffer.toString());
                        outElem.appendChild(textNode);
                        doc.appendChild(outElem);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return doc;
    }
}

