/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.translit;

import com.ibm.icu.dev.tool.translit.UnicodeSetClosure;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;

public class genIndexFilters {
    public static void main(String[] args) throws IOException {
        Normalizer.Mode m = Normalizer.NONE;
        boolean lowerFirst = false;
        if (args.length >= 2) {
            if (args[1].equalsIgnoreCase("NFD")) {
                m = Normalizer.NFD;
            } else if (args[1].equalsIgnoreCase("NFKD")) {
                m = Normalizer.NFKD;
            } else {
                genIndexFilters.usage();
            }
        }
        if (args.length >= 3) {
            if (args[2].equalsIgnoreCase("lower")) {
                lowerFirst = true;
            } else {
                genIndexFilters.usage();
            }
        }
        if (args.length > 3) {
            genIndexFilters.usage();
        }
        genIndexFilters.showSourceSet(args[0], m, lowerFirst);
    }

    static void showSourceSet(String ID, Normalizer.Mode m, boolean lowerFirst) throws IOException {
        Transliterator t = Transliterator.getInstance(ID);
        UnicodeSet sourceSet = t.getSourceSet();
        if (m != Normalizer.NONE || lowerFirst) {
            UnicodeSetClosure.close(sourceSet, m, lowerFirst);
        }
        System.out.println(sourceSet.toPattern(true));
    }

    static void usage() {
        System.err.println("Usage: ID [ NFD|NFKD [lower] ]");
        System.exit(1);
    }
}

