/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.translit;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;

public class WriteIndicCharts {
    static String header = "<html>\n    <head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">           Inter-Indic Transliteration Comparison chart    </head>\n    <body bgcolor=#FFFFFF>\n         <table border=1 width=100% >\n            <tr>\n            <th width=9%>Inter-Indic</th>\n            <th width=9%>Latin</th>\n            <th width=9%>Devanagari</th>\n            <th width=9%>Bengali</th>\n            <th width=9%>Gurmukhi</th>\n            <th width=9%>Gujarati</th>\n            <th width=9%>Oriya</th>\n            <th width=9%>Tamil</th>\n            <th width=9%>Telugu</th>\n            <th width=9%>Kannada</th>\n            <th width=9%>Malayalam</th>\n            </tr>\n";
    static String footer = "          </table>\n    </body>\n</html>\n";
    static UnicodeSet deva = new UnicodeSet("[:deva:]");
    static UnicodeSet beng = new UnicodeSet("[:beng:]");
    static UnicodeSet gujr = new UnicodeSet("[:gujr:]");
    static UnicodeSet guru = new UnicodeSet("[:guru:]");
    static UnicodeSet orya = new UnicodeSet("[:orya:]");
    static UnicodeSet taml = new UnicodeSet("[:taml:]");
    static UnicodeSet telu = new UnicodeSet("[:telu:]");
    static UnicodeSet knda = new UnicodeSet("[:knda:]");
    static UnicodeSet mlym = new UnicodeSet("[:mlym:]");
    static UnicodeSet inter = new UnicodeSet("[\ue000-\ue080]");
    static Hashtable table = new Hashtable();

    public static void main(String[] args) {
        WriteIndicCharts.writeIICharts();
    }

    public static void writeIICharts() {
        try {
            Transliterator t1 = Transliterator.getInstance("InterIndic-Bengali");
            Transliterator t2 = Transliterator.getInstance("InterIndic-Gurmukhi");
            Transliterator t3 = Transliterator.getInstance("InterIndic-Gujarati");
            Transliterator t4 = Transliterator.getInstance("InterIndic-Oriya");
            Transliterator t5 = Transliterator.getInstance("InterIndic-Tamil");
            Transliterator t6 = Transliterator.getInstance("InterIndic-Telugu");
            Transliterator t7 = Transliterator.getInstance("InterIndic-Kannada");
            Transliterator t8 = Transliterator.getInstance("InterIndic-Malayalam");
            Transliterator t9 = Transliterator.getInstance("InterIndic-Devanagari");
            Transliterator t10 = Transliterator.getInstance("InterIndic-Latin");
            UnicodeSetIterator sIter = new UnicodeSetIterator(deva);
            int i = 0;
            while (i <= 128) {
                String[] arr = new String[10];
                arr[0] = UTF16.valueOf(i + 57344);
                table.put(UTF16.valueOf(i), arr);
                ++i;
            }
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream("comparison-chart.html"), "UTF-8");
            os.write(header);
            WriteIndicCharts.writeIICharts(t9, 2304, 1);
            WriteIndicCharts.writeIICharts(t1, 2432, 2);
            WriteIndicCharts.writeIICharts(t2, 2560, 3);
            WriteIndicCharts.writeIICharts(t3, 2688, 4);
            WriteIndicCharts.writeIICharts(t4, 2816, 5);
            WriteIndicCharts.writeIICharts(t5, 2944, 6);
            WriteIndicCharts.writeIICharts(t6, 3072, 7);
            WriteIndicCharts.writeIICharts(t7, 3200, 8);
            WriteIndicCharts.writeIICharts(t8, 3328, 9);
            int i2 = 0;
            while (i2 <= 128) {
                String[] temp = (String[])table.get(UTF16.valueOf(i2));
                boolean write = false;
                int k = 1;
                while (k < temp.length && temp[k] != null) {
                    if (UCharacter.getExtendedName(UTF16.charAt(temp[k], 0)).indexOf("unassigned") < 0 || temp[k].indexOf(":UNASSIGNED") < 0) {
                        write = true;
                    }
                    ++k;
                }
                if (write) {
                    os.write("        <tr>\n");
                    int j = 0;
                    while (j < temp.length) {
                        if (temp[j] != null) {
                            boolean fallback = false;
                            boolean unassigned = false;
                            boolean unmapped = false;
                            boolean consumed = false;
                            String str = temp[j];
                            if (temp[j].indexOf(":FALLBACK") >= 0) {
                                str = temp[j].substring(0, temp[j].indexOf(":"));
                                fallback = true;
                            }
                            if (temp[j].indexOf(":UNASSIGNED") >= 0) {
                                str = temp[j].substring(0, temp[j].indexOf(":"));
                                unassigned = true;
                            }
                            if (temp[j].indexOf(":UNMAPPED") >= 0) {
                                str = temp[j].substring(0, temp[j].indexOf(":"));
                                unmapped = true;
                            }
                            if (temp[j].indexOf(":CONSUMED") >= 0) {
                                str = temp[j].substring(0, temp[j].indexOf(":"));
                                consumed = true;
                            }
                            StringBuffer nameBuf = new StringBuffer();
                            int f = 0;
                            while (f < str.length()) {
                                if (f > 0) {
                                    nameBuf.append("+");
                                }
                                nameBuf.append(UCharacter.getExtendedName(UTF16.charAt(str, f)));
                                ++f;
                            }
                            String name = nameBuf.toString();
                            if (fallback) {
                                if (UCharacter.getExtendedName(UTF16.charAt(str, 0)).indexOf("unassigned") > 0) {
                                    os.write("            <td  width=9% bgcolor=#BBBBFF align=center title=\"" + name + "\">" + "&nbsp<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                                } else {
                                    os.write("            <td width=9% bgcolor=#BBBBFF align=center title=\"" + name + "\">" + str + "<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                                }
                            } else if (unmapped) {
                                os.write("            <td bgcolor=#FF9999 align=center title=\"" + name + "\">" + "&nbsp<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                            } else if (unassigned) {
                                if (UCharacter.getExtendedName(UTF16.charAt(str, 0)).indexOf("unassigned") > 0) {
                                    os.write("            <td width=9% bgcolor=#00FFFF align=center title=\"" + name + "\">" + "&nbsp<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                                } else {
                                    os.write("            <td width=9% bgcolor=#00FFFF align=center title=\"" + name + "\">" + str + "<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                                }
                            } else if (consumed) {
                                if (UCharacter.getExtendedName(UTF16.charAt(str, 0)).indexOf("unassigned") > 0) {
                                    os.write("            <td width=9% bgcolor=#FFFF55 align=center title=\"" + name + "\">" + "&nbsp<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                                } else {
                                    os.write("            <td width=9% bgcolor=#FFFF55 align=center title=\"\">&nbsp<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                                }
                            } else if (name.indexOf("private") != -1) {
                                String s = t10.transliterate(str);
                                os.write("            <td width=9% bgcolor=#FFBBBB  align=center title=\"" + name + "\">" + "&nbsp<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                                if (!s.equals(str)) {
                                    os.write("            <td width=9%  bgcolor=#CCEEDD align=center>" + s + "</td>");
                                } else {
                                    os.write("            <td width=9% bgcolor=#CCEEDD align=center>&nbsp;</td>");
                                }
                            } else {
                                os.write("            <td width=9% align=center title=\"" + name + "\">" + str + "<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                            }
                        } else {
                            os.write("           <td width=9% >&nbsp</td>\n");
                        }
                        ++j;
                    }
                    os.write("        </tr>\n");
                }
                ++i2;
            }
            os.write(footer);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeCharts() {
        try {
            Transliterator t1 = Transliterator.getInstance("InterIndic-Bengali");
            Transliterator t2 = Transliterator.getInstance("InterIndic-Gurmukhi");
            Transliterator t3 = Transliterator.getInstance("InterIndic-Gujarati");
            Transliterator t4 = Transliterator.getInstance("InterIndic-Oriya");
            Transliterator t5 = Transliterator.getInstance("InterIndic-Tamil");
            Transliterator t6 = Transliterator.getInstance("InterIndic-Telugu");
            Transliterator t7 = Transliterator.getInstance("InterIndic-Kannada");
            Transliterator t8 = Transliterator.getInstance("InterIndic-Malayalam");
            Transliterator t9 = Transliterator.getInstance("InterIndic-Devanagari");
            UnicodeSetIterator sIter = new UnicodeSetIterator(deva);
            int i = 2304;
            while (i <= 2431) {
                String[] arr = new String[10];
                arr[0] = UTF16.valueOf((i & 0xFF) + 57344);
                table.put(UTF16.valueOf(i), arr);
                ++i;
            }
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream("comparison-chart.html"), "UTF-8");
            os.write(header);
            WriteIndicCharts.writeIICharts(t9, 2304, 1);
            WriteIndicCharts.writeIICharts(t1, 2432, 2);
            WriteIndicCharts.writeIICharts(t2, 2560, 3);
            WriteIndicCharts.writeIICharts(t3, 2688, 4);
            WriteIndicCharts.writeIICharts(t4, 2816, 5);
            WriteIndicCharts.writeIICharts(t5, 2944, 6);
            WriteIndicCharts.writeIICharts(t6, 3072, 7);
            WriteIndicCharts.writeIICharts(t7, 3200, 8);
            WriteIndicCharts.writeIICharts(t8, 3328, 9);
            int i2 = 2304;
            while (i2 <= 2431) {
                String[] temp = (String[])table.get(UTF16.valueOf(i2));
                boolean write = false;
                int k = 1;
                while (k < temp.length) {
                    if (UCharacter.getExtendedName(UTF16.charAt(temp[k], 0)).indexOf("unassigned") < 0) {
                        write = true;
                    }
                    ++k;
                }
                if (write) {
                    os.write("        <tr>\n");
                    int j = 0;
                    while (j < temp.length) {
                        if (temp[j] != null) {
                            boolean fallback = false;
                            String str = temp[j];
                            if (temp[j].indexOf(":FALLBACK") >= 0) {
                                str = temp[j].substring(0, temp[j].indexOf(":"));
                                fallback = true;
                            }
                            String name = UCharacter.getExtendedName(UTF16.charAt(str, 0));
                            if (fallback) {
                                os.write("            <td bgcolor=#BBBBFF align=center title=\"" + name + "\">" + str + "<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                            } else if (name.indexOf("unassigned") != -1) {
                                os.write("            <td bgcolor=#CCCCCC align=center title=\"" + name + "\">" + "&nbsp<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                            } else if (name.indexOf("private") != -1) {
                                os.write("            <td bgcolor=#FFBBBB align=center title=\"" + name + "\">" + "&nbsp<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                            } else {
                                os.write("            <td align=center title=\"" + name + "\">" + str + "<br><tt>" + Utility.hex(str) + "</tt>" + "</td>\n");
                            }
                        } else {
                            os.write("           <td>&nbsp</td>\n");
                        }
                        ++j;
                    }
                    os.write("        </tr>\n");
                }
                ++i2;
            }
            os.write(footer);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String getKey(int cp) {
        int delta;
        return UTF16.valueOf(delta -= (delta = cp & 0xFF) > 127 ? 128 : 0);
    }

    public static void writeCharts(Transliterator trans, int start, int index) {
        Transliterator inverse = trans.getInverse();
        int i = 0;
        while (i <= 127) {
            String cp = UTF16.valueOf(start + i);
            String s1 = inverse.transliterate(cp);
            String s2 = trans.transliterate(s1);
            String[] arr = (String[])table.get(WriteIndicCharts.getKey(start + i));
            arr[index] = cp.equals(s2) ? s1 : s1 + ":FALLBACK";
            ++i;
        }
    }

    public static void writeIICharts(Transliterator trans, int start, int index) {
        Transliterator inverse = trans.getInverse();
        UnicodeSetIterator iter = new UnicodeSetIterator(inter);
        while (iter.next()) {
            String cp = UTF16.valueOf(iter.codepoint);
            String s1 = trans.transliterate(cp);
            String s2 = inverse.transliterate(s1);
            String[] arr = (String[])table.get(UTF16.valueOf(iter.codepoint & 0xFF));
            if (cp.equals(s1)) {
                arr[index] = UTF16.valueOf(start + ((byte)iter.codepoint & 0xFF)) + ":UNASSIGNED";
                continue;
            }
            if (cp.equals(s2)) {
                arr[index] = s1;
                continue;
            }
            if (s1.equals(s2)) {
                if (s1.equals("")) {
                    arr[index] = UTF16.valueOf(start + ((byte)iter.codepoint & 0xFF)) + ":CONSUMED";
                    continue;
                }
                arr[index] = s1 + ":FALLBACK";
                continue;
            }
            arr[index] = s2.equals("") ? UTF16.valueOf(start + ((byte)iter.codepoint & 0xFF)) + ":CONSUMED" : s1 + ":FALLBACK";
        }
    }

    public static void writeCharts(Transliterator trans, UnicodeSet target, int index) {
        UnicodeSetIterator tIter = new UnicodeSetIterator(target);
        Transliterator inverse = trans.getInverse();
        while (tIter.next()) {
            String cp = UTF16.valueOf(tIter.codepoint);
            String s1 = inverse.transliterate(cp);
            String s2 = trans.transliterate(s1);
            String[] arr = (String[])table.get(WriteIndicCharts.getKey(tIter.codepoint));
            arr[index] = cp.equals(s2) ? cp : cp + ":FALLBACK";
        }
    }
}

