/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.translit;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class UnicodeSetClosure {
    static boolean GENERATE = false;
    static final Normalizer.Mode[] testModes = new Normalizer.Mode[]{Normalizer.NONE, Normalizer.NFD, Normalizer.NFC, Normalizer.NFKD, Normalizer.NFKC};
    static final String[] modeNames = new String[]{"NoNF", "NFD", "NFC", "NFKD", "NFKC"};
    static final boolean[] testCases = new boolean[]{false, true};
    static final String[] caseNames = new String[]{"noLower", "lower"};
    static PrintWriter out;
    static boolean FAST;
    static UnicodeSet generatedSet;

    public static void main(String[] args) throws Exception {
        UnicodeSet foo = new UnicodeSet("[\u1ff6-\u1ffd\u2000-\u2001\u2126]");
        UnicodeSetClosure.test();
    }

    public static void generateSets(String label, boolean forward, Normalizer.Mode m, boolean lowerFirst, String rules) {
        UnicodeSet s = new UnicodeSet(rules);
        System.out.println("Generating " + label + (forward ? "" : " BACKWARD"));
        UnicodeSetClosure.close(s, m, lowerFirst);
        out.println("# MINIMAL FILTER GENERATED FOR: " + label + (forward ? "" : " BACKWARD"));
        out.println(":: " + (forward ? "" : "( ") + s.toPattern(true) + (forward ? "" : " )") + " ;");
        out.println();
        out.println("Unicode: " + s.toPattern(false));
    }

    public static void test() throws Exception {
        File f = new File("TestUnicodeSetClosure.txt");
        String filename = f.getCanonicalFile().toString();
        out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        System.out.println("Writing " + filename);
        out.print('\ufeff');
        GENERATE = true;
        UnicodeSetClosure.test("[:Devanagari:]");
        out.close();
    }

    public static void test(String testStr) throws Exception {
        UnicodeSet original = new UnicodeSet(testStr);
        System.out.println("Testing Closure of: " + original.toPattern(true));
        out.println("Testing Closure of: " + original.toPattern(false));
        UnicodeSet raw = new UnicodeSet(original);
        original.complement();
        original.complement();
        if (!raw.equals(original)) {
            out.println("Equals:" + original.toPattern(false));
        }
        StringWriter swLog = null;
        PrintWriter log = null;
        if (GENERATE) {
            swLog = new StringWriter();
            log = new PrintWriter(swLog);
            log.println("static UnicodeSet[][] UNCHANGED = {");
        }
        int i = 0;
        while (i < testCases.length) {
            if (GENERATE) {
                log.println("    {");
            }
            int j = 0;
            while (j < testModes.length) {
                UnicodeSet test = new UnicodeSet(original);
                UnicodeSetClosure.close(test, testModes[j], testCases[i]);
                if (GENERATE) {
                    log.println("\tnew UnicodeSet(\"" + generatedSet.toPattern(true) + "\"),");
                }
                String label = caseNames[i] + ", " + modeNames[j];
                System.out.println(label);
                out.println(label + ": " + test.toPattern(false));
                test.removeAll(original);
                if (test.isEmpty()) {
                    out.println("\tNo Difference from original");
                } else {
                    out.println("\tDifference = " + test.toPattern(false));
                }
                out.flush();
                ++j;
            }
            if (GENERATE) {
                log.println("    },");
            }
            out.println();
            ++i;
        }
        if (GENERATE) {
            log.println("};");
            out.print(swLog.getBuffer().toString());
        }
    }

    public static void close(UnicodeSet s, Normalizer.Mode m, boolean lowerFirst) {
        NFToString f = new NFToString(m, lowerFirst);
        if (FAST) {
            int mm = 0;
            while (m != testModes[mm]) {
                ++mm;
            }
            UnicodeSetClosure.close2(s, f, lowerFirst ? 1 : 0, mm);
            return;
        }
        UnicodeSetClosure.close(s, f);
    }

    public static void close(UnicodeSet s, Char32ToString f) {
        if (GENERATE) {
            generatedSet = new UnicodeSet();
        }
        int cp = 0;
        while (cp <= 0x10FFFF) {
            String result;
            int type = UCharacter.getType(cp);
            if (type != 0 && (result = f.get(cp)) != null) {
                if (GENERATE) {
                    generatedSet.add(cp);
                }
                if (UnicodeSetClosure.containsSome(s, result)) {
                    s.add(cp);
                }
            }
            ++cp;
        }
    }

    public static void close2(UnicodeSet s, Char32ToString f, int lc, int mode) {
        UnicodeSet unchanged = new UnicodeSet();
        int count = unchanged.getRangeCount();
        int i = 0;
        while (i < count) {
            int start = unchanged.getRangeStart(i);
            int end = unchanged.getRangeEnd(i);
            int cp = start;
            while (cp <= end) {
                String result = f.get(cp);
                if (result == null) {
                    throw new IllegalArgumentException("Something wrong -- should never happen");
                }
                if (UnicodeSetClosure.containsSome(s, result)) {
                    s.add(cp);
                }
                ++cp;
            }
            ++i;
        }
    }

    public static void addAll(UnicodeSet s, String str) {
        int i = 0;
        while (i < str.length()) {
            int cp = UTF16.charAt(str, i);
            s.add(cp);
            i += UTF16.getCharCount(cp);
        }
    }

    public static boolean containsSome(UnicodeSet s, String str) {
        int i = 0;
        while (i < str.length()) {
            int cp = UTF16.charAt(str, i);
            if (s.contains(cp)) {
                return true;
            }
            i += UTF16.getCharCount(cp);
        }
        return false;
    }

    static {
        FAST = true;
    }

    static interface Char32ToString {
        public String get(int var1);
    }

    public static class NFToString
    implements Char32ToString {
        Normalizer.Mode mode;
        boolean lowerFirst;

        NFToString(Normalizer.Mode m, boolean lowerFirst) {
            this.mode = m;
            this.lowerFirst = lowerFirst;
        }

        public String get(int cp) {
            String source;
            String result = source = UTF16.valueOf(cp);
            if (this.lowerFirst) {
                result = UCharacter.toLowerCase(Locale.US, result);
            }
            result = Normalizer.normalize(result, this.mode);
            if (this.lowerFirst) {
                result = UCharacter.toLowerCase(Locale.US, result);
            }
            if (result.equals(source)) {
                return null;
            }
            return result;
        }
    }
}

