/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.translit;

import com.ibm.icu.text.Transliterator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Trans {
    static final boolean DEBUG = false;

    public static void main(String[] args) throws Exception {
        boolean isHTML = false;
        int pos = 0;
        String transName = null;
        String inText = null;
        String inName = null;
        String outName = null;
        while (pos < args.length) {
            if (args[pos].equals("-html")) {
                isHTML = true;
            } else if (args[pos].equals("-i")) {
                if (++pos == args.length) {
                    Trans.usage();
                }
                inName = args[pos];
            } else if (args[pos].equals("-o")) {
                if (++pos == args.length) {
                    Trans.usage();
                }
                outName = args[pos];
            } else if (transName == null) {
                transName = args[pos];
            } else {
                inText = inText == null ? args[pos] : inText + " " + args[pos];
            }
            ++pos;
        }
        if (inText != null && inName != null) {
            Trans.usage();
        }
        Transliterator trans = Transliterator.getInstance(transName);
        BufferedReader in = null;
        if (inName != null) {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inName), "UTF8"));
        }
        PrintWriter out = null;
        out = outName != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outName), "UTF8")) : new PrintWriter(System.out);
        Trans.trans(trans, inText, in, out, isHTML);
        out.close();
    }

    static void trans(Transliterator trans, String inText, BufferedReader in, PrintWriter out, boolean isHTML) throws IOException {
        boolean inTag = false;
        while (true) {
            String line = null;
            if (inText != null) {
                line = inText;
                inText = null;
            } else if (in != null) {
                line = in.readLine();
            }
            if (line == null) break;
            if (isHTML) {
                StringBuffer buf = new StringBuffer();
                int right = -1;
                if (inTag) {
                    right = line.indexOf(62);
                    if (right < 0) {
                        right = line.length() - 1;
                    }
                    buf.append(line.substring(0, right + 1));
                    inTag = false;
                }
                while (true) {
                    int left;
                    if ((left = line.indexOf(60, right + 1)) < 0) {
                        if (right >= line.length() - 1) break;
                        buf.append(trans.transliterate(line.substring(right + 1)));
                        break;
                    }
                    buf.append(trans.transliterate(line.substring(right + 1, left)));
                    right = line.indexOf(62, left + 1);
                    if (right < 0) {
                        inTag = true;
                        buf.append(line.substring(left));
                        break;
                    }
                    buf.append(line.substring(left, right + 1));
                }
                line = buf.toString();
            } else {
                line = trans.transliterate(line);
            }
            out.println(line);
        }
    }

    static void usage() {
        System.out.println("Usage: java com.ibm.icu.dev.tool.translit.Trans [-html] <trans> ( <input> | -i <infile>) [ -o <outfile> ]");
        System.out.println("<trans>   Name of transliterator");
        System.out.println("<input>   Text to transliterate");
        System.out.println("<infile>  Name of input file");
        System.out.println("<outfile> Name of output file");
        System.out.println("-html     Only transliterate text outside of <tags>");
        System.out.println("Input may come from the command line or a file.\n");
        System.out.println("Ouput may go to stdout or a file.\n");
        System.exit(0);
    }
}

