/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.rbbi;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;

public class WriteTablesToFiles {
    public static void main(String[] args) throws IOException {
        WriteTablesToFiles.writeBatch(true);
        WriteTablesToFiles.writeBatch(false);
    }

    public static void writeBatch(boolean littleEndian) throws IOException {
        String suffix = littleEndian ? "LE" : "BE";
        BreakIterator bi = BreakIterator.getCharacterInstance();
        ((RuleBasedBreakIterator)bi).writeTablesToFile(new FileOutputStream("char" + suffix + ".brk"), littleEndian);
        bi = BreakIterator.getWordInstance();
        ((RuleBasedBreakIterator)bi).writeTablesToFile(new FileOutputStream("word" + suffix + ".brk"), littleEndian);
        bi = BreakIterator.getLineInstance();
        ((RuleBasedBreakIterator)bi).writeTablesToFile(new FileOutputStream("line" + suffix + ".brk"), littleEndian);
        bi = BreakIterator.getSentenceInstance();
        ((RuleBasedBreakIterator)bi).writeTablesToFile(new FileOutputStream("sent" + suffix + ".brk"), littleEndian);
        bi = BreakIterator.getTitleInstance();
        ((RuleBasedBreakIterator)bi).writeTablesToFile(new FileOutputStream("title" + suffix + ".brk"), littleEndian);
        Locale thai = new Locale("th", "", "");
        bi = BreakIterator.getWordInstance(thai);
        ((RuleBasedBreakIterator)bi).writeTablesToFile(new FileOutputStream("word_th" + suffix + ".brk"), littleEndian);
        bi = BreakIterator.getLineInstance(thai);
        ((RuleBasedBreakIterator)bi).writeTablesToFile(new FileOutputStream("line_th" + suffix + ".brk"), littleEndian);
    }
}

