/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.rbbi;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.CompactByteArray;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class BuildDictionaryFile {
    private CompactByteArray columnMap = null;
    private char[] reverseColumnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;
    private int totalWords = 0;
    private int uniqueWords = 0;
    private int totalUniqueWordChars = 0;
    private static final String spaces = "      ";

    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String filename = args[0];
        String encoding = "";
        String outputFile = "";
        String listingFile = "";
        if (args.length >= 2) {
            encoding = args[1];
        }
        if (args.length >= 3) {
            outputFile = args[2];
        }
        if (args.length >= 4) {
            listingFile = args[3];
        }
        BuildDictionaryFile dictionary = new BuildDictionaryFile();
        dictionary.build(filename, encoding);
        DataOutputStream out = null;
        if (outputFile.length() != 0) {
            out = new DataOutputStream(new FileOutputStream(outputFile));
            dictionary.writeDictionaryFile(out);
        }
        PrintWriter listing = null;
        if (listingFile.length() != 0) {
            listing = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(listingFile), "UnicodeLittle"));
            dictionary.printWordList("", 0, listing);
            listing.close();
        }
    }

    public void build(String filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileInputStream file = new FileInputStream(filename);
        InputStreamReader in = encoding.length() == 0 ? new InputStreamReader(file) : new InputStreamReader((InputStream)file, encoding);
        this.buildColumnMap(in);
        file = new FileInputStream(filename);
        in = encoding.length() == 0 ? new InputStreamReader(file) : new InputStreamReader((InputStream)file, encoding);
        this.buildStateTable(in);
    }

    public void buildColumnMap(InputStreamReader in) throws IOException {
        System.out.println("Building column map...");
        UnicodeSet charsInFile = new UnicodeSet();
        int c = in.read();
        int totalChars = 0;
        while (c >= 0) {
            if (++totalChars > 0 && totalChars % 5000 == 0) {
                System.out.println("Read " + totalChars + " characters...");
            }
            if (c > 32) {
                charsInFile.add((char)c);
            }
            c = in.read();
        }
        StringBuffer tempReverseMap = new StringBuffer();
        tempReverseMap.append(' ');
        this.columnMap = new CompactByteArray();
        int n = charsInFile.getRangeCount();
        byte p = 1;
        int i = 0;
        while (i < n) {
            char start = (char)charsInFile.getRangeStart(i);
            char end = (char)charsInFile.getRangeEnd(i);
            char ch = start;
            while (ch <= end) {
                if (this.columnMap.elementAt(Character.toLowerCase(ch)) == 0) {
                    this.columnMap.setElementAt(Character.toUpperCase(ch), Character.toUpperCase(ch), p);
                    this.columnMap.setElementAt(Character.toLowerCase(ch), Character.toLowerCase(ch), p);
                    p = (byte)(p + 1);
                    tempReverseMap.append(ch);
                }
                ch = (char)(ch + '\u0001');
            }
            ++i;
        }
        this.columnMap.compact();
        this.reverseColumnMap = new char[p];
        Utility.getChars(tempReverseMap, 0, p, this.reverseColumnMap, 0);
        System.out.println("total columns = " + p);
        this.numCols = p;
        this.numColGroups = (this.numCols >> 5) + 1;
    }

    public void buildStateTable(InputStreamReader in) throws IOException {
        Vector<int[]> tempTable = new Vector<int[]>();
        tempTable.addElement(new int[this.numCols + 1]);
        int state = 0;
        int c = in.read();
        int[] row = null;
        int charsInWord = 0;
        while (c >= 0) {
            ++charsInWord;
            short column = this.columnMap.elementAt((char)c);
            row = (int[])tempTable.elementAt(state);
            if (column != 0) {
                if (row[column] == 0) {
                    row[column] = tempTable.size();
                    int n = this.numCols;
                    row[n] = row[n] + 1;
                    state = tempTable.size();
                    tempTable.addElement(new int[this.numCols + 1]);
                } else {
                    state = row[column];
                }
            } else if (state != 0) {
                if (row[0] != -1) {
                    row[0] = -1;
                    int n = this.numCols;
                    row[n] = row[n] + 1;
                    ++this.uniqueWords;
                    this.totalUniqueWordChars += charsInWord;
                }
                ++this.totalWords;
                if (this.totalWords % 5000 == 0) {
                    System.out.println("Read " + this.totalWords + " words, " + tempTable.size() + " rows...");
                }
                charsInWord = 0;
                state = 0;
            }
            c = in.read();
        }
        if (state != 0) {
            row = (int[])tempTable.elementAt(state);
            if (row[0] != -1) {
                row[0] = -1;
                ++this.uniqueWords;
                this.totalUniqueWordChars += charsInWord;
            }
            ++this.totalWords;
        }
        this.compress(tempTable);
        this.table = new short[this.numCols * tempTable.size()];
        int i = 0;
        while (i < tempTable.size()) {
            row = (int[])tempTable.elementAt(i);
            int j = 0;
            while (j < this.numCols) {
                this.table[i * this.numCols + j] = (short)row[j];
                ++j;
            }
            ++i;
        }
    }

    private void compress(Vector tempTable) {
        System.out.println("Before compression:");
        System.out.println("  Number of rows = " + tempTable.size());
        System.out.println("  Number of columns = " + this.numCols);
        System.out.println("  Number of cells = " + tempTable.size() * this.numCols);
        this.deleteDuplicateRows(tempTable);
        System.out.println("After removing duplicate rows:");
        System.out.println("  Number of rows = " + tempTable.size());
        System.out.println("  Number of columns = " + this.numCols);
        System.out.println("  Number of cells = " + tempTable.size() * this.numCols);
        this.stackRows(tempTable);
        if (tempTable.size() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Too many rows in table!");
        }
        System.out.println("After doubling up on rows:");
        System.out.println("  Number of rows = " + tempTable.size());
        System.out.println("  Number of columns = " + this.numCols);
        System.out.println("  Number of cells = " + tempTable.size() * this.numCols);
    }

    private void deleteDuplicateRows(Vector tempTable) {
        int i;
        int i2;
        Vector work = (Vector)tempTable.clone();
        boolean didDeleteRow = true;
        Vector<Integer> tempMapping = new Vector<Integer>(work.size());
        int[] mapping = new int[work.size()];
        int i3 = 0;
        while (i3 < mapping.length) {
            mapping[i3] = i3;
            tempMapping.addElement(new Integer(i3));
            ++i3;
        }
        boolean[] tbd = new boolean[work.size()];
        while (didDeleteRow) {
            System.out.println(" " + work.size() + " rows...");
            int deletedRows = 0;
            didDeleteRow = false;
            this.sortTable(work, tempMapping, mapping, 1, work.size());
            i2 = 0;
            while (i2 < work.size() - 1) {
                System.out.print("Deleting, inspecting row " + i2 + ", deleted " + deletedRows + " rows...\r");
                int rowToDelete = (Integer)tempMapping.elementAt(i2 + 1);
                int rowToMapTo = (Integer)tempMapping.elementAt(i2);
                if (this.compareRows((int[])work.elementAt(i2), (int[])work.elementAt(i2 + 1), mapping) == 0) {
                    tbd[rowToDelete] = true;
                    tempTable.setElementAt(null, rowToDelete);
                    while (tbd[mapping[rowToMapTo]]) {
                        mapping[rowToMapTo] = mapping[mapping[rowToMapTo]];
                    }
                    mapping[rowToDelete] = mapping[rowToMapTo];
                    didDeleteRow = true;
                    ++deletedRows;
                    work.removeElementAt(i2 + 1);
                    tempMapping.removeElementAt(i2 + 1);
                    continue;
                }
                ++i2;
            }
            i = 0;
            while (i < mapping.length) {
                if (tbd[i] && tbd[mapping[i]]) {
                    mapping[i] = mapping[mapping[i]];
                }
                ++i;
            }
        }
        int decrementBy = 0;
        i2 = 0;
        while (i2 < mapping.length) {
            if (tbd[i2]) {
                ++decrementBy;
            } else {
                int n = i2;
                mapping[n] = mapping[n] - decrementBy;
            }
            ++i2;
        }
        i = 0;
        while (i < mapping.length) {
            if (tbd[i]) {
                mapping[i] = mapping[mapping[i]];
            }
            ++i;
        }
        int i4 = tempTable.size() - 1;
        while (i4 >= 0) {
            if (tbd[i4]) {
                tempTable.removeElementAt(i4);
            } else {
                int[] row = (int[])tempTable.elementAt(i4);
                int j = 0;
                while (j < this.numCols) {
                    row[j] = row[j] == -1 ? -1 : mapping[row[j]];
                    ++j;
                }
            }
            --i4;
        }
    }

    private void sortTable(Vector table, Vector tempMapping, int[] mapping, int start, int end) {
        System.out.print("Sorting (" + start + ", " + end + ")...\r");
        if (start + 1 >= end) {
            return;
        }
        if (start + 10 >= end) {
            int i = start + 1;
            while (i < end) {
                int[] row = (int[])table.elementAt(i);
                Integer tempMap = (Integer)tempMapping.elementAt(i);
                int j = i - 1;
                while (j >= start) {
                    if (this.compareRows((int[])table.elementAt(j), row, mapping) <= 0) {
                        table.setElementAt(row, j + 1);
                        tempMapping.setElementAt(tempMap, j + 1);
                        break;
                    }
                    table.setElementAt((int[])table.elementAt(j), j + 1);
                    tempMapping.setElementAt((Integer)tempMapping.elementAt(j), j + 1);
                    --j;
                }
                if (j < start) {
                    table.setElementAt(row, start);
                    tempMapping.setElementAt(tempMap, start);
                }
                ++i;
            }
        } else {
            int i;
            int boundaryPos = (start + end) / 2;
            boolean allTheSame = true;
            int firstDifferent = 0;
            do {
                int[] boundary = (int[])table.elementAt(boundaryPos);
                i = start;
                int j = end - 1;
                int[] row = null;
                while (i < j) {
                    row = (int[])table.elementAt(i);
                    while (i <= j && this.compareRows(row, boundary, mapping) < 0) {
                        row = (int[])table.elementAt(++i);
                    }
                    row = (int[])table.elementAt(j);
                    byte compResult = this.compareRows(row, boundary, mapping);
                    while (i <= j && compResult >= 0) {
                        if (compResult != 0) {
                            allTheSame = false;
                            firstDifferent = j;
                        }
                        row = (int[])table.elementAt(--j);
                        compResult = this.compareRows(row, boundary, mapping);
                    }
                    if (i > j) continue;
                    row = (int[])table.elementAt(j);
                    table.setElementAt(table.elementAt(i), j);
                    table.setElementAt(row, i);
                    Object temp = tempMapping.elementAt(j);
                    tempMapping.setElementAt(tempMapping.elementAt(i), j);
                    tempMapping.setElementAt(temp, i);
                }
                if (i > start) continue;
                if (allTheSame) {
                    return;
                }
                boundaryPos = firstDifferent;
            } while (i <= start);
            this.sortTable(table, tempMapping, mapping, start, i);
            this.sortTable(table, tempMapping, mapping, i, end);
        }
    }

    private byte compareRows(int[] row1, int[] row2, int[] mapping) {
        int i = 0;
        while (i < this.numCols) {
            int c2;
            int c1 = row1[i] == -1 ? -1 : mapping[row1[i]];
            int n = c2 = row2[i] == -1 ? -1 : mapping[row2[i]];
            if (c1 < c2) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    private int[] buildRowIndex(Vector tempTable) {
        int[] tempRowIndex = new int[tempTable.size()];
        this.rowIndexFlagsIndex = new short[tempTable.size()];
        Vector<Integer> tempRowIndexFlags = new Vector<Integer>();
        this.rowIndexShifts = new byte[tempTable.size()];
        int i = 0;
        while (i < tempTable.size()) {
            tempRowIndex[i] = i;
            int[] row = (int[])tempTable.elementAt(i);
            if (row[this.numCols] == 1 && row[0] == 0) {
                int j = 0;
                while (row[j] == 0) {
                    ++j;
                }
                this.rowIndexFlagsIndex[i] = (short)(-j);
            } else {
                int[] flags = new int[this.numColGroups];
                int nextFlag = 1;
                int colGroup = 0;
                int j = 0;
                while (j < this.numCols) {
                    if (row[j] != 0) {
                        int n = colGroup;
                        flags[n] = flags[n] | nextFlag;
                    }
                    if ((nextFlag <<= 1) == 0) {
                        ++colGroup;
                        nextFlag = 1;
                    }
                    ++j;
                }
                colGroup = 0;
                int j2 = 0;
                while (j2 < tempRowIndexFlags.size()) {
                    if ((Integer)tempRowIndexFlags.elementAt(j2) == flags[colGroup]) {
                        ++j2;
                        if (++colGroup < this.numColGroups) continue;
                        break;
                    }
                    if (colGroup != 0) {
                        colGroup = 0;
                        continue;
                    }
                    ++j2;
                }
                this.rowIndexFlagsIndex[i] = (short)(j2 - colGroup);
                while (colGroup < this.numColGroups) {
                    tempRowIndexFlags.addElement(new Integer(flags[colGroup]));
                    ++colGroup;
                }
            }
            ++i;
        }
        this.rowIndexFlags = new int[tempRowIndexFlags.size()];
        int i2 = 0;
        while (i2 < this.rowIndexFlags.length) {
            this.rowIndexFlags[i2] = (Integer)tempRowIndexFlags.elementAt(i2);
            ++i2;
        }
        System.out.println("Number of column groups = " + this.numColGroups);
        System.out.println("Size of rowIndexFlags = " + this.rowIndexFlags.length);
        return tempRowIndex;
    }

    private void stackRows(Vector tempTable) {
        int[] tempRowIndex = this.buildRowIndex(tempTable);
        boolean[] tbd = new boolean[tempTable.size()];
        int i = 0;
        while (i < tempTable.size()) {
            if (!tbd[i]) {
                System.out.print("Stacking, inspecting row " + i + "...\r");
                int[] destRow = (int[])tempTable.elementAt(i);
                boolean[] tempFlags = new boolean[this.numCols];
                boolean[] filledCells = new boolean[this.numCols];
                int j = 0;
                while (j < this.numCols) {
                    filledCells[j] = destRow[j] != 0;
                    ++j;
                }
                int j2 = i + 1;
                while (destRow[this.numCols] < this.numCols && j2 < tempTable.size()) {
                    int[] srcRow;
                    if (!tbd[j2] && (srcRow = (int[])tempTable.elementAt(j2))[this.numCols] + destRow[this.numCols] <= this.numCols) {
                        int k;
                        int maxLeftShift = -999;
                        int maxRightShift = 0;
                        int k2 = 0;
                        while (k2 < this.numCols) {
                            boolean bl = tempFlags[k2] = srcRow[k2] != 0;
                            if (tempFlags[k2]) {
                                if (maxLeftShift == -999) {
                                    maxLeftShift = -k2;
                                }
                                maxRightShift = this.numCols - 1 - k2;
                            }
                            ++k2;
                        }
                        int shift = maxLeftShift;
                        while (shift <= maxRightShift) {
                            k = 0;
                            while (k < this.numCols) {
                                if (tempFlags[k] && filledCells[k + shift]) break;
                                ++k;
                            }
                            if (k >= this.numCols) break;
                            ++shift;
                        }
                        if (shift <= maxRightShift) {
                            k = 0;
                            while (k < this.numCols) {
                                if (tempFlags[k]) {
                                    filledCells[k + shift] = true;
                                    destRow[k + shift] = srcRow[k];
                                    int n = this.numCols;
                                    destRow[n] = destRow[n] + 1;
                                }
                                ++k;
                            }
                            tbd[j2] = true;
                            tempRowIndex[j2] = i;
                            this.rowIndexShifts[j2] = (byte)shift;
                        }
                    }
                    ++j2;
                }
            }
            ++i;
        }
        int decrementBy = 0;
        int i2 = 0;
        while (i2 < tempRowIndex.length) {
            if (!tbd[i2]) {
                int n = i2;
                tempRowIndex[n] = tempRowIndex[n] - decrementBy;
            } else {
                ++decrementBy;
            }
            ++i2;
        }
        this.rowIndex = new short[tempRowIndex.length];
        int i3 = tempRowIndex.length - 1;
        while (i3 >= 0) {
            if (tbd[i3]) {
                this.rowIndex[i3] = (short)tempRowIndex[tempRowIndex[i3]];
                tempTable.removeElementAt(i3);
            } else {
                this.rowIndex[i3] = (short)tempRowIndex[i3];
            }
            --i3;
        }
    }

    private void printTable() {
        int populatedCells = 0;
        System.out.println();
        System.out.println("Conceptual table:");
        System.out.print(" Row:");
        int i = 0;
        while (i < this.reverseColumnMap.length) {
            System.out.print("   " + this.reverseColumnMap[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.rowIndex.length) {
            System.out.println();
            this.printNumber(i2, 4);
            System.out.print(":");
            int j = 0;
            while (j < this.numCols) {
                this.printNumber(this.at(i2, j), 4);
                ++j;
            }
            ++i2;
        }
        System.out.println('\n');
        System.out.println();
        System.out.println("Internally stored table:");
        System.out.print(" Row:");
        int i3 = 0;
        while (i3 < this.reverseColumnMap.length) {
            System.out.print("   " + this.reverseColumnMap[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.table.length) {
            short cell;
            if (i4 % this.numCols == 0) {
                System.out.println();
                this.printNumber(i4 / this.numCols, 4);
                System.out.print(":");
            }
            if ((cell = this.table[i4]) != 0) {
                ++populatedCells;
            }
            this.printNumber(cell, 4);
            ++i4;
        }
        System.out.println('\n');
        System.out.println("Row index:");
        int i5 = 0;
        while (i5 < this.rowIndex.length) {
            System.out.print("   " + i5 + " -> " + this.rowIndex[i5]);
            if (this.rowIndexFlagsIndex[i5] < 0) {
                System.out.print(", flags = " + Integer.toBinaryString(1 << -this.rowIndexFlagsIndex[i5]) + " (" + this.rowIndexFlagsIndex[i5]);
            } else {
                System.out.print(", flags = " + Integer.toBinaryString(this.rowIndexFlags[this.rowIndexFlagsIndex[i5]]) + " (" + this.rowIndexFlagsIndex[i5]);
            }
            System.out.println("), shift = " + this.rowIndexShifts[i5]);
            ++i5;
        }
    }

    private void printConceptualTable(String initialString, int state, boolean[] flags) {
        short nextState;
        if (initialString.length() == 0) {
            System.out.println("root:");
        } else {
            System.out.println(initialString + ':');
        }
        if (!flags[state]) {
            flags[state] = true;
            this.printNumber(state, 4);
            System.out.print(":");
            int i = 0;
            while (i < this.numCols) {
                this.printNumber(this.at(state, i), 4);
                ++i;
            }
            System.out.println();
        }
        int i = 0;
        while (i < this.numCols) {
            nextState = this.at(state, i);
            if (nextState > 0 && !flags[nextState]) {
                this.printNumber(nextState, 4);
                System.out.print(":");
                int j = 0;
                while (j < this.numCols) {
                    this.printNumber(this.at((int)nextState, j), 4);
                    ++j;
                }
                System.out.println();
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numCols) {
            nextState = this.at(state, i2);
            if (nextState > 0 && !flags[nextState]) {
                char nextChar = nextState == 27 ? (char)' ' : (nextState == 26 ? (char)'\'' : (char)((char)(i2 + 97)));
                flags[nextState] = true;
                this.printConceptualTable(initialString + nextChar, nextState, flags);
            }
            ++i2;
        }
    }

    private void printWordList(String partialWord, int state, PrintWriter out) throws IOException {
        if (state == -1) {
            System.out.println(partialWord);
            if (out != null) {
                out.println(partialWord);
            }
        } else {
            int i = 0;
            while (i < this.numCols) {
                if (this.at(state, i) != 0) {
                    this.printWordList(partialWord + this.reverseColumnMap[i], this.at(state, i), out);
                }
                ++i;
            }
        }
    }

    private void writeDictionaryFile(DataOutputStream out) throws IOException {
        out.writeInt(0);
        char[] columnMapIndexes = this.columnMap.getIndexArray();
        out.writeInt(columnMapIndexes.length);
        int i = 0;
        while (i < columnMapIndexes.length) {
            out.writeShort((short)columnMapIndexes[i]);
            ++i;
        }
        byte[] columnMapValues = this.columnMap.getValueArray();
        out.writeInt(columnMapValues.length);
        int i2 = 0;
        while (i2 < columnMapValues.length) {
            out.writeByte(columnMapValues[i2]);
            ++i2;
        }
        out.writeInt(this.numCols);
        out.writeInt(this.numColGroups);
        out.writeInt(this.rowIndex.length);
        int i3 = 0;
        while (i3 < this.rowIndex.length) {
            out.writeShort(this.rowIndex[i3]);
            ++i3;
        }
        out.writeInt(this.rowIndexFlagsIndex.length);
        int i4 = 0;
        while (i4 < this.rowIndexFlagsIndex.length) {
            out.writeShort(this.rowIndexFlagsIndex[i4]);
            ++i4;
        }
        out.writeInt(this.rowIndexFlags.length);
        int i5 = 0;
        while (i5 < this.rowIndexFlags.length) {
            out.writeInt(this.rowIndexFlags[i5]);
            ++i5;
        }
        out.writeInt(this.rowIndexShifts.length);
        int i6 = 0;
        while (i6 < this.rowIndexShifts.length) {
            out.writeByte(this.rowIndexShifts[i6]);
            ++i6;
        }
        out.writeInt(this.table.length);
        int i7 = 0;
        while (i7 < this.table.length) {
            out.writeShort(this.table[i7]);
            ++i7;
        }
        out.close();
    }

    private void printNumber(int x, int width) {
        String s = String.valueOf(x);
        if (width > s.length()) {
            System.out.print(spaces.substring(0, width - s.length()));
        }
        if (x != 0) {
            System.out.print(s);
        } else {
            System.out.print('.');
        }
    }

    public final short at(int row, char ch) {
        byte col = this.columnMap.elementAt(ch);
        return this.at(row, col);
    }

    public final short at(int row, int col) {
        if (this.cellIsPopulated(row, col)) {
            return this.internalAt(this.rowIndex[row], col + this.rowIndexShifts[row]);
        }
        return 0;
    }

    private final boolean cellIsPopulated(int row, int col) {
        if (this.rowIndexFlagsIndex[row] < 0) {
            return col == -this.rowIndexFlagsIndex[row];
        }
        int flags = this.rowIndexFlags[this.rowIndexFlagsIndex[row] + (col >> 5)];
        return (flags & 1 << (col & 0x1F)) != 0;
    }

    private final short internalAt(int row, int col) {
        return this.table[row * this.numCols + col];
    }
}

