/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ComplexTransition;
import com.ibm.icu.dev.tool.localeconverter.Lex;
import com.ibm.icu.dev.tool.localeconverter.PosixCharMap;
import java.io.PushbackReader;
import java.io.StringReader;

public class SymbolTransition
extends ComplexTransition {
    private static PosixCharMap mapping = new PosixCharMap();
    public static final SymbolTransition GLOBAL = new SymbolTransition(0x7FFFFFFE);
    private static Lex.Transition[][] states;

    public static void setCharMap(PosixCharMap mappingIn) {
        mapping = mappingIn;
        if (mapping == null) {
            mapping = new PosixCharMap();
        }
    }

    public static PosixCharMap getCharMap() {
        return mapping;
    }

    public SymbolTransition(int success) {
        super(success);
    }

    public boolean accepts(int c) {
        return '<' == (char)c;
    }

    protected void handleSuccess(Lex parser, StringBuffer output) {
        String text = parser.getData();
        String mappedText = mapping.mapKey(text);
        if (mappedText != null) {
            output.append(mappedText);
        } else {
            output.append(text);
        }
    }

    protected Lex.Transition[][] getStates() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (states == null) {
                states = new Lex.Transition[][]{{new Lex.CharTransition('<', 0, -1), new Lex.ParseExceptionTransition("illegal characters in symbol")}, {new Lex.CharTransition('/', 0, -2), new Lex.CharTransition('>', 0, 0x7FFFFFFE), new Lex.StringTransition("\f\r\n\u2028\u2029", 17, -3), new Lex.EOFTransition(-3), new Lex.DefaultTransition(0, -1)}, {new Lex.CharTransition('>', 0, -1), new Lex.CharTransition('/', 0, -1), new Lex.ParseExceptionTransition("illegal escape character in symbol")}, {new Lex.ParseExceptionTransition("unexpected end of line/file")}};
            }
        }
        return states;
    }

    public static void main(String[] args) {
        try {
            Lex.Transition[][] states = new Lex.Transition[][]{{new SymbolTransition(0x7FFFFFFE), new Lex.EOFTransition(), new Lex.ParseExceptionTransition("bad test input")}};
            String text = "<U><S><D> ";
            StringReader sr = new StringReader(text);
            PushbackReader pr = new PushbackReader(sr);
            Lex parser = new Lex(states, pr);
            int s = parser.nextToken();
            while (s == 0x7FFFFFFE) {
                System.out.println(parser.getData());
                s = parser.nextToken();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

