/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ArrayEnumeration;
import com.ibm.icu.dev.tool.localeconverter.Comparable;
import com.ibm.icu.dev.tool.localeconverter.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public final class SortedVector {
    private Object[] dataArray = new Object[16];
    private Comparator comparator;
    private int count = 0;
    private boolean isValid = false;
    private int auxStart;
    private int startIndex;
    private int power;
    private static final int[] exp2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};

    public SortedVector(Object[] newValues, Comparator comparator) {
        this.comparator = comparator;
        this.addElements(newValues);
    }

    public SortedVector(Vector newValues, Comparator comparator) {
        this.comparator = comparator;
        this.addElements(newValues);
    }

    public SortedVector(Enumeration newValues, Comparator comparator) {
        this.comparator = comparator;
        this.addElements(newValues);
    }

    public SortedVector(Object[] newValues) {
        this.addElements(newValues);
    }

    public SortedVector(Comparator comparator) {
        this.comparator = comparator;
    }

    public SortedVector(Vector newValues) {
        this.addElements(newValues);
    }

    public SortedVector(Enumeration newValues) {
        this.addElements(newValues);
    }

    public SortedVector() {
    }

    public void addElement(Object element) {
        if (this.count >= this.dataArray.length) {
            this.setCapacity(this.count * 2 + 17);
        }
        this.dataArray[this.count++] = element;
        this.isValid = false;
    }

    public void addElements(Object[] newValues) {
        int newCount = this.count + newValues.length;
        if (newCount > this.dataArray.length) {
            this.setCapacity(newCount);
        }
        int i = this.count;
        while (i < newCount) {
            this.dataArray[i] = newValues[i - this.count];
            ++i;
        }
        this.count = newCount;
        this.isValid = false;
    }

    public void addElements(Vector newValues) {
        int newCount = this.count + newValues.size();
        if (newCount > this.dataArray.length) {
            this.setCapacity(newCount);
        }
        int i = this.count;
        while (i < newCount) {
            this.dataArray[i] = newValues.elementAt(i - this.count);
            ++i;
        }
        this.count = newCount;
        this.isValid = false;
    }

    public void addElements(Enumeration newValues) {
        while (newValues.hasMoreElements()) {
            this.addElement(newValues.nextElement());
        }
    }

    public void removeElements(int startIndex, int endIndex) {
        if (!this.isValid) {
            this.validate();
        }
        System.arraycopy(this.dataArray, endIndex, this.dataArray, startIndex, this.count - endIndex);
        int i = this.count - (endIndex - startIndex);
        while (i < this.count) {
            this.dataArray[i] = null;
            ++i;
        }
        this.count -= endIndex - startIndex;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.isValid = false;
    }

    public Comparator getComparator() {
        if (this.comparator == null) {
            this.validateComparator();
        }
        return this.comparator;
    }

    public int size() {
        return this.count;
    }

    public int capacity() {
        return this.dataArray.length;
    }

    public void setCapacity(int newSize) {
        Object[] temp = new Object[newSize];
        System.arraycopy(this.dataArray, 0, temp, 0, Math.min(this.count, newSize));
        this.dataArray = temp;
    }

    public void trimToSize() {
        this.setCapacity(this.count);
    }

    public Object elementAt(int index) {
        if (!this.isValid) {
            this.validate();
        }
        if (index >= this.count) {
            return this.dataArray[this.dataArray.length];
        }
        return this.dataArray[index];
    }

    public boolean contains(Object value) {
        int index = this.indexOf(value);
        return index >= 0 && this.comparator.compare(value, this.dataArray[index]) == 0;
    }

    public Enumeration elements() {
        if (!this.isValid) {
            this.validate();
        }
        return new ArrayEnumeration(this.dataArray, 0, this.count);
    }

    public void copyInto(Object[] toFill) {
        if (!this.isValid) {
            this.validate();
        }
        System.arraycopy(this.dataArray, 0, toFill, 0, toFill.length);
    }

    public int indexOf(Object searchValue) {
        if (!this.isValid) {
            this.validate();
        }
        int index = this.startIndex;
        if (0 <= this.comparator.compare(searchValue, this.dataArray[this.auxStart])) {
            index += this.auxStart;
        }
        switch (this.power) {
            case 31: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x40000000])) {
                    index -= 0x40000000;
                }
            }
            case 30: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x20000000])) {
                    index -= 0x20000000;
                }
            }
            case 29: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x10000000])) {
                    index -= 0x10000000;
                }
            }
            case 28: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x8000000])) {
                    index -= 0x8000000;
                }
            }
            case 27: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x4000000])) {
                    index -= 0x4000000;
                }
            }
            case 26: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x2000000])) {
                    index -= 0x2000000;
                }
            }
            case 25: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x1000000])) {
                    index -= 0x1000000;
                }
            }
            case 24: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x800000])) {
                    index -= 0x800000;
                }
            }
            case 23: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x400000])) {
                    index -= 0x400000;
                }
            }
            case 22: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x200000])) {
                    index -= 0x200000;
                }
            }
            case 21: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 0x100000])) {
                    index -= 0x100000;
                }
            }
            case 20: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 524288])) {
                    index -= 524288;
                }
            }
            case 19: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 262144])) {
                    index -= 262144;
                }
            }
            case 18: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 131072])) {
                    index -= 131072;
                }
            }
            case 17: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 65536])) {
                    index -= 65536;
                }
            }
            case 16: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 32768])) {
                    index -= 32768;
                }
            }
            case 15: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 16384])) {
                    index -= 16384;
                }
            }
            case 14: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 8192])) {
                    index -= 8192;
                }
            }
            case 13: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 4096])) {
                    index -= 4096;
                }
            }
            case 12: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 2048])) {
                    index -= 2048;
                }
            }
            case 11: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 1024])) {
                    index -= 1024;
                }
            }
            case 10: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 512])) {
                    index -= 512;
                }
            }
            case 9: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 256])) {
                    index -= 256;
                }
            }
            case 8: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 128])) {
                    index -= 128;
                }
            }
            case 7: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 64])) {
                    index -= 64;
                }
            }
            case 6: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 32])) {
                    index -= 32;
                }
            }
            case 5: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 16])) {
                    index -= 16;
                }
            }
            case 4: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 8])) {
                    index -= 8;
                }
            }
            case 3: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 4])) {
                    index -= 4;
                }
            }
            case 2: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 2])) {
                    index -= 2;
                }
            }
            case 1: {
                if (0 > this.comparator.compare(searchValue, this.dataArray[index - 1])) {
                    --index;
                }
            }
            case 0: {
                if (0 <= this.comparator.compare(searchValue, this.dataArray[index])) break;
                --index;
            }
        }
        return index;
    }

    private void validateComparator() {
        try {
            Object trial = this.dataArray[0];
            this.comparator = trial instanceof Float || trial instanceof Double ? new DoubleComparator() : (trial instanceof Integer ? new IntegerComparator() : (trial instanceof Number ? new LongComparator() : (trial instanceof String ? new StringComparator() : new ComparableComparator())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validate() {
        if (this.isValid) {
            return;
        }
        if (this.comparator == null) {
            this.validateComparator();
        }
        this.power = exp2.length - 1;
        while (this.power > 0 && this.count < exp2[this.power]) {
            --this.power;
        }
        this.auxStart = exp2[this.power] != this.count ? this.count - exp2[this.power] : 0;
        this.startIndex = exp2[this.power] - 1;
        int lo = 0;
        int up = this.count - 1;
        int step = up - lo + 1;
        while (step > 1) {
            step = step < 5 ? 1 : (5 * step - 1) / 11;
            int i = up - step;
            while (i >= lo) {
                Object temp = this.dataArray[i];
                int j = i + step;
                while (j <= up && 0 > this.comparator.compare(this.dataArray[j], temp)) {
                    this.dataArray[j - step] = this.dataArray[j];
                    j += step;
                }
                this.dataArray[j - step] = temp;
                --i;
            }
        }
        this.isValid = true;
    }

    public static final class StringComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            return ((String)a).compareTo((String)b);
        }
    }

    public static final class ComparableComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            return ((Comparable)a).compareTo(b);
        }
    }

    public static final class DoubleComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            double bb;
            double aa = ((Number)a).doubleValue();
            return aa < (bb = ((Number)b).doubleValue()) ? -1 : (aa > bb ? 1 : 0);
        }
    }

    public static final class IntegerComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            return ((Number)a).intValue() - ((Number)b).intValue();
        }
    }

    public static final class LongComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            long bb;
            long aa = ((Number)a).longValue();
            return aa < (bb = ((Number)b).longValue()) ? -1 : (aa > bb ? 1 : 0);
        }
    }
}

