/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ComplexTransition;
import com.ibm.icu.dev.tool.localeconverter.EscapeTransition;
import com.ibm.icu.dev.tool.localeconverter.Lex;
import com.ibm.icu.dev.tool.localeconverter.SymbolTransition;
import java.io.PushbackReader;
import java.io.StringReader;

public class QuoteTransition
extends ComplexTransition {
    public static final QuoteTransition GLOBAL = new QuoteTransition(0x7FFFFFFE);
    public static final char STRING_CHAR = '\"';
    private static final Lex.Transition[][] states = new Lex.Transition[][]{{new Lex.CharTransition('\"', 1, -1), new Lex.ParseExceptionTransition("illegal character in quoted string")}, {new Lex.CharTransition('\"', 1, 0x7FFFFFFE), new Lex.StringTransition("\f\r\n\u2028\u2029", 1, -2), new EscapeTransition(-1), new SymbolTransition(-1), new Lex.EOFTransition(-2), new Lex.DefaultTransition(0, -1)}, {new Lex.ParseExceptionTransition("unterminated string")}};

    public QuoteTransition(int success) {
        super(success);
    }

    public boolean accepts(int c) {
        return '\"' == (char)c;
    }

    protected Lex.Transition[][] getStates() {
        return states;
    }

    public static void main(String[] args) {
        try {
            Lex.Transition[][] states = new Lex.Transition[][]{{new QuoteTransition(0x7FFFFFFE), new Lex.EOFTransition(), new Lex.ParseExceptionTransition("bad test input")}};
            EscapeTransition.setEscapeChar('/');
            String text = "\"hello<\"/>>/d32world\"\"<one>/\n<two>\"";
            StringReader sr = new StringReader(text);
            PushbackReader pr = new PushbackReader(sr);
            Lex parser = new Lex(states, pr);
            int s = parser.nextToken();
            while (s == 0x7FFFFFFE) {
                System.out.println(parser.getData());
                s = parser.nextToken();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

