/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.CollationItem;
import com.ibm.icu.dev.tool.localeconverter.ICULocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.LocaleConverter;
import com.ibm.icu.dev.tool.localeconverter.PosixCollationBuilder;
import com.ibm.icu.dev.tool.localeconverter.PosixToNeutralConverter;
import com.ibm.icu.text.HexToUnicodeTransliterator;
import com.ibm.icu.text.ReplaceableString;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class PosixToNeutralConverter
extends LocaleConverter {
    public static final byte LC_CTYPE = 1;
    public static final byte LC_TIME = 2;
    public static final byte LC_NUMERIC = 4;
    public static final byte LC_MONETARY = 8;
    public static final byte LC_MESSAGES = 16;
    public static final byte LC_MEASUREMENT = 17;
    public static final byte LC_ADDRESS = 18;
    public static final byte LC_PAPER = 19;
    public static final byte LC_NAME = 20;
    public static final byte LC_IDENTIFICATION = 21;
    public static final byte LC_TELEPHONE = 22;
    public static final HexToUnicodeTransliterator myTranslit = new HexToUnicodeTransliterator();
    private static final byte[] masks = new byte[]{1, 2, 4, 8, 16, 17, 18, 19, 20, 21, 22};
    private static final String[][] props = new String[][]{{"upper", "lower", "alpha", "digit", "space", "cntrl", "punct", "graph", "print", "xdigit", "blank", "toupper", "tolower"}, {"abday", "day", "abmon", "mon", "d_t_fmt", "d_ftm", "t_fmt", "am_pm", "t_fmt_ampm", "era", "era_year", "era_d_fmt", "alt_digits"}, {"decimal_point", "thousands_sep", "grouping"}, {"int_curr_symbol", "currency_symbol", "mon_decimal_point", "mon_thousands_sep", "mon_grouping", "positive_sign", "negative_sign", "int_frac_digits", "frac_digits", "p_cs_precedes", "p_sep_by_space", "n_cs_precedes", "n_sep_by_space", "p_sign_posn"}, {"yesexpr", "noexpr"}, {"measurement"}, {"copy", "postal_fmt", "country_name", "country_post", "country_ab2", "country_ab3", "country_num", "country_car", "country_isbn", "lang_name", "lang_ab", "lang_term", "lang_lib"}, {"height", "width", "copy"}, {"copy", "name_fmt", "name_gen", "name_miss", "name_mr", "name_mrs", "name_ms"}, {"title", "source", "address", "contact", "email", "tel", "fax", "language", "territory", "revision ", "date"}, {"copy", "tel_int_fmt", "tel_dom_fmt", "int_select", "int_prefix"}};
    private final byte flags;
    private final Locale locale;
    private final Locale parentLocale;
    private final String sfileName;

    public PosixToNeutralConverter(byte flags, Locale locale, String fileName) {
        this.flags = flags;
        this.locale = locale;
        this.sfileName = fileName;
        myTranslit.applyPattern("<U###0>");
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = "";
        int ndx = language.indexOf(95);
        if (ndx >= 0) {
            country = language.substring(ndx + 1);
            language = language.substring(0, ndx);
        }
        if ((ndx = country.indexOf(95)) >= 0) {
            variant = country.substring(ndx);
            country = country.substring(0, ndx);
        }
        if ("".equals(country)) {
            language = "";
            variant = "";
        } else if ("".equals(variant)) {
            country = "";
        }
        this.parentLocale = new Locale(language, country, variant);
    }

    protected void convert(Hashtable result, Hashtable source) throws LocaleConverter.ConversionError {
        this.writePosixCompData(result, source);
        this.convertMEASUREMENT(result, source);
        this.convertCOUNTRYNUMBER(result, source);
        this.convertCOUNTRYISBNNUMBER(result, source);
        this.convertLANGUAGELIB(result, source);
        this.convertPAPERSIZE(result, source);
        this.convertMONETARY(result, source);
        this.convertNUMERIC(result, source);
        this.convertTIME(result, source);
        this.convertCOLLATE(result, source);
        int i = 0;
        while (i < masks.length) {
            if ((this.flags & masks[i]) != 0) {
                int j = 0;
                while (j < props[i].length) {
                    String prop = props[i][j];
                    Object val = source.get(prop);
                    if (val != null) {
                        this.resultPut(result, prop, val);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public String[][] clone2DArr(String[][] str2Darray) {
        String[][] newStr2DArr = new String[str2Darray.length][str2Darray[0].length];
        int i = 0;
        while (i < str2Darray.length) {
            int j = 0;
            while (j < str2Darray[i].length) {
                newStr2DArr[i][j] = new String(str2Darray[i][j]);
                ++j;
            }
            ++i;
        }
        return newStr2DArr;
    }

    public Object[][] clone2DArr(Object[][] str2Darray) {
        Object[][] newStr2DArr = new Object[str2Darray.length][str2Darray[0].length];
        int i = 0;
        while (i < str2Darray.length) {
            int j = 0;
            while (j < str2Darray[i].length) {
                newStr2DArr[i][j] = new String((String)str2Darray[i][j]);
                ++j;
            }
            ++i;
        }
        return newStr2DArr;
    }

    public void writePosixCompData(Hashtable result, Hashtable source) {
        class DumpPosixData {
            FileOutputStream outFile;
            ICULocaleWriter myLocaleWriter;
            private final /* synthetic */ PosixToNeutralConverter this$0;

            public DumpPosixData(PosixToNeutralConverter this$0, String fileName) {
                this.this$0 = this$0;
                try {
                    this.outFile = new FileOutputStream(fileName.concat("_PCD.txt"));
                    this.myLocaleWriter = new ICULocaleWriter(new PrintStream(this.outFile));
                }
                catch (IOException e) {
                    System.out.println("File not found\n\n\n");
                    return;
                }
            }

            private void writePosixCompData(Hashtable resultHash, Hashtable source, String fileName) {
                this.convertMESSAGES(resultHash, source);
                this.convertIDENTIFICATION(resultHash, source);
                this.convertNAMEFORMAT(resultHash, source);
                this.convertADDRESSFORMAT(resultHash, source);
                this.convertTELEPHONEFORMAT(resultHash, source);
                String euroVar = PosixToNeutralConverter.access$000(this.this$0).getVariant();
                euroVar = euroVar.equals("") ? "PCD" : euroVar.concat("_PCD");
                Locale myLocale = new Locale(PosixToNeutralConverter.access$000(this.this$0).getLanguage(), PosixToNeutralConverter.access$000(this.this$0).getCountry(), euroVar);
                this.myLocaleWriter.write(myLocale, resultHash);
            }

            private void convertMESSAGES(Hashtable result, Hashtable source) {
                String[][] DEFAULT_MESSAGES = (String[][])PosixToNeutralConverter.access$100(this.this$0, "Messages");
                String[][] myMessages = this.this$0.clone2DArr(DEFAULT_MESSAGES);
                String value = (String)source.get("yesexpr");
                ReplaceableString temp = new ReplaceableString();
                if (value != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myMessages[0][1] = temp.toString();
                }
                if ((value = (String)source.get("noexpr")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myMessages[1][1] = temp.toString();
                }
                PosixToNeutralConverter.access$200(this.this$0, result, "Messages", myMessages);
            }

            private void convertIDENTIFICATION(Hashtable result, Hashtable source) {
                String[][] DEFAULT_MESSAGES = (String[][])PosixToNeutralConverter.access$100(this.this$0, "Identification");
                String[][] myIdentification = this.this$0.clone2DArr(DEFAULT_MESSAGES);
                String value = (String)source.get("title");
                ReplaceableString temp = new ReplaceableString();
                if (value != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[0][1] = temp.toString();
                }
                if ((value = (String)source.get("source")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[1][1] = temp.toString();
                }
                if ((value = (String)source.get("address")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[2][1] = value;
                }
                if ((value = (String)source.get("contact")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[3][1] = temp.toString();
                }
                if ((value = (String)source.get("email")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[4][1] = temp.toString();
                }
                if ((value = (String)source.get("tel")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[5][1] = temp.toString();
                }
                if ((value = (String)source.get("fax")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[6][1] = temp.toString();
                }
                if ((value = (String)source.get("language")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[7][1] = temp.toString();
                }
                if ((value = (String)source.get("territory")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[8][1] = temp.toString();
                }
                if ((value = (String)source.get("audience")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[9][1] = temp.toString();
                }
                if ((value = (String)source.get("application")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[10][1] = temp.toString();
                } else {
                    value = (String)source.get("abbreviation");
                }
                if (value != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[11][1] = temp.toString();
                }
                if ((value = (String)source.get("revision")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[12][1] = temp.toString();
                }
                if ((value = (String)source.get("date")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myIdentification[13][1] = temp.toString();
                }
                PosixToNeutralConverter.access$200(this.this$0, result, "Identification", myIdentification);
            }

            private void convertNAMEFORMAT(Hashtable result, Hashtable source) {
                String[][] DEFAULT_MESSAGES = (String[][])PosixToNeutralConverter.access$100(this.this$0, "NameFormat");
                String[][] myNameFormat = this.this$0.clone2DArr(DEFAULT_MESSAGES);
                String value = (String)source.get("name_mr");
                ReplaceableString temp = new ReplaceableString();
                if (value != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myNameFormat[2][1] = temp.toString();
                }
                if ((value = (String)source.get("name_miss")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myNameFormat[3][1] = temp.toString();
                }
                if ((value = (String)source.get("name_ms")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myNameFormat[6][1] = temp.toString();
                }
                if ((value = (String)source.get("name_mrs")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myNameFormat[4][1] = temp.toString();
                }
                if ((value = (String)source.get("name_gender")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myNameFormat[1][1] = temp.toString();
                }
                if ((value = (String)source.get("name_fmt")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    char[] myChars = new char[100];
                    temp.getChars(0, temp.length(), myChars, 0);
                    StringBuffer myString = new StringBuffer();
                    int i = 0;
                    do {
                        if (myChars[i] != '%') {
                            myString.append(myChars[i]);
                            ++i;
                            continue;
                        }
                        switch (myChars[++i]) {
                            case 'f': {
                                myString.append("{0}");
                                break;
                            }
                            case 'F': {
                                myString.append("{1}");
                                break;
                            }
                            case 'g': {
                                myString.append("{2}");
                                break;
                            }
                            case 'G': {
                                myString.append("{3}");
                                break;
                            }
                            case 'l': {
                                myString.append("{4}");
                                break;
                            }
                            case 'o': {
                                myString.append("{5}");
                                break;
                            }
                            case 'm': {
                                myString.append("{6}");
                                break;
                            }
                            case 'M': {
                                myString.append("{7}");
                                break;
                            }
                            case 'p': {
                                myString.append("{8}");
                                break;
                            }
                            case 's': {
                                myString.append("{9}");
                                break;
                            }
                            case 'S': {
                                myString.append("{10}");
                                break;
                            }
                            case 'd': {
                                myString.append("{11}");
                                break;
                            }
                            case 't': {
                                myString.append("{12}");
                                break;
                            }
                            default: {
                                myString.append(myChars[i]);
                            }
                        }
                        ++i;
                    } while (i < temp.length());
                    myNameFormat[0][1] = myString.toString();
                }
                PosixToNeutralConverter.access$200(this.this$0, result, "NameFormat", myNameFormat);
            }

            private void convertADDRESSFORMAT(Hashtable result, Hashtable source) {
                String[][] DEFAULT_MESSAGES = (String[][])PosixToNeutralConverter.access$100(this.this$0, "AddressFormat");
                String[][] myAddressFormat = this.this$0.clone2DArr(DEFAULT_MESSAGES);
                String value = (String)source.get("postal_fmt");
                ReplaceableString temp = new ReplaceableString();
                if (value != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    char[] myChars = new char[100];
                    temp.getChars(0, temp.length(), myChars, 0);
                    StringBuffer myString = new StringBuffer();
                    int i = 0;
                    do {
                        if (myChars[i] != '%') {
                            myString.append(myChars[i]);
                            ++i;
                            continue;
                        }
                        switch (myChars[++i]) {
                            case 'a': {
                                myString.append("{0}");
                                break;
                            }
                            case 'f': {
                                myString.append("{1}");
                                break;
                            }
                            case 'd': {
                                myString.append("{2}");
                                break;
                            }
                            case 'b': {
                                myString.append("{3}");
                                break;
                            }
                            case 's': {
                                myString.append("{4}");
                                break;
                            }
                            case 'h': {
                                myString.append("{5}");
                                break;
                            }
                            case 'N': {
                                myString.append("{6}");
                                break;
                            }
                            case 't': {
                                myString.append("{13}");
                                break;
                            }
                            case 'r': {
                                myString.append("{7}");
                                break;
                            }
                            case 'e': {
                                myString.append("{8}");
                                break;
                            }
                            case 'C': {
                                myString.append("{9}");
                                break;
                            }
                            case 'Z': {
                                myString.append("{10}");
                                break;
                            }
                            case 'T': {
                                myString.append("{11}");
                                break;
                            }
                            case 'z': {
                                myString.append("{12}");
                                break;
                            }
                            case 'c': {
                                myString.append("{14}");
                                break;
                            }
                            default: {
                                myString.append(myChars[i]);
                            }
                        }
                        ++i;
                    } while (i < temp.length());
                    myAddressFormat[0][1] = myString.toString();
                }
                PosixToNeutralConverter.access$200(this.this$0, result, "AddressFormat", myAddressFormat);
            }

            private void convertTELEPHONEFORMAT(Hashtable result, Hashtable source) {
                int i;
                StringBuffer myString;
                char[] myChars;
                String[][] DEFAULT_MESSAGES = (String[][])PosixToNeutralConverter.access$100(this.this$0, "TelephoneFormat");
                String[][] myTelephoneFormat = this.this$0.clone2DArr(DEFAULT_MESSAGES);
                String value = (String)source.get("tel_int_fmt");
                ReplaceableString temp = new ReplaceableString();
                if (value != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myChars = new char[100];
                    temp.getChars(0, temp.length(), myChars, 0);
                    myString = new StringBuffer();
                    i = 0;
                    do {
                        if (myChars[i] != '%') {
                            myString.append(myChars[i]);
                            ++i;
                            continue;
                        }
                        switch (myChars[++i]) {
                            case 'a': {
                                myString.append("{0}");
                                break;
                            }
                            case 'A': {
                                myString.append("{1}");
                                break;
                            }
                            case 'l': {
                                myString.append("{2}");
                                break;
                            }
                            case 'c': {
                                myString.append("{3}");
                                break;
                            }
                            case 'C': {
                                myString.append("{4}");
                                break;
                            }
                            default: {
                                myString.append(myChars[i]);
                            }
                        }
                        ++i;
                    } while (i < temp.length());
                    myTelephoneFormat[0][1] = myString.toString();
                }
                if ((value = (String)source.get("dom_fmt")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myChars = new char[100];
                    temp.getChars(0, temp.length(), myChars, 0);
                    myString = new StringBuffer();
                    i = 0;
                    do {
                        if (myChars[i] != '%') {
                            myString.append(myChars[i]);
                            ++i;
                            continue;
                        }
                        switch (myChars[++i]) {
                            case 'a': {
                                myString.append("{0}");
                                break;
                            }
                            case 'A': {
                                myString.append("{1}");
                                break;
                            }
                            case 'l': {
                                myString.append("{2}");
                                break;
                            }
                            case 'c': {
                                myString.append("{3}");
                                break;
                            }
                            case 'C': {
                                myString.append("{4}");
                                break;
                            }
                            default: {
                                myString.append(myChars[i]);
                            }
                        }
                        ++i;
                    } while (i < temp.length());
                    myTelephoneFormat[1][1] = myString.toString();
                }
                if ((value = (String)source.get("int_select")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myTelephoneFormat[2][1] = temp.toString();
                }
                if ((value = (String)source.get("int_prefix")) != null) {
                    temp.replace(0, temp.length(), value);
                    PosixToNeutralConverter.myTranslit.transliterate(temp);
                    myTelephoneFormat[3][1] = temp.toString();
                }
                PosixToNeutralConverter.access$200(this.this$0, result, "TelephoneFormat", myTelephoneFormat);
            }
        }
        DumpPosixData p = new DumpPosixData(this, this.sfileName);
        Hashtable myresult = new Hashtable(20);
        p.writePosixCompData(myresult, source, this.sfileName);
    }

    private void convertMONETARY(Hashtable result, Hashtable source) {
        String[] DEFAULT_CURRENCY_ELEMENTS = (String[])this.getDefault("CurrencyElements");
        String[] elements = (String[])DEFAULT_CURRENCY_ELEMENTS.clone();
        String value = (String)source.get("currency_symbol");
        if (value != null) {
            myTranslit.transliterate(new ReplaceableString(value));
            elements[0] = value;
        }
        if ((value = (String)source.get("int_curr_symbol")) != null) {
            myTranslit.transliterate(new ReplaceableString(value));
            elements[1] = value;
        }
        if ((value = (String)source.get("mon_decimal_point")) != null) {
            myTranslit.transliterate(new ReplaceableString(value));
            elements[2] = value;
        }
        this.resultPut(result, "CurrencyElements", elements);
    }

    private void convertMEASUREMENT(Hashtable result, Hashtable source) {
        String DEFAULT_MEASUREMENT;
        String elements = DEFAULT_MEASUREMENT = (String)this.getDefault("Measurement");
        String value = (String)source.get("measurement");
        if (value != null) {
            if (value.equals("1")) {
                elements = "Metric";
            } else if (value.equals("2")) {
                elements = "American";
            } else if (value.equals("3")) {
                elements = "Other";
            }
        }
        this.resultPut(result, "Measurement", elements);
    }

    private void convertCOUNTRYNUMBER(Hashtable result, Hashtable source) {
        String DEFAULT_COUNTRYNUMBER;
        String elements = DEFAULT_COUNTRYNUMBER = (String)this.getDefault("CountryNumber");
        String value = (String)source.get("country_num");
        if (value != null) {
            elements = value;
        }
        this.resultPut(result, "CountryNumber", elements);
    }

    private void convertCOUNTRYISBNNUMBER(Hashtable result, Hashtable source) {
        String DEFAULT_COUNTRYNUMBER = (String)this.getDefault("CountryISBNNumber");
        String elements = new String(DEFAULT_COUNTRYNUMBER);
        String value = (String)source.get("country_num");
        if (value != null) {
            elements = value;
        }
        this.resultPut(result, "CountryISBNNumber", elements);
    }

    private void convertLANGUAGELIB(Hashtable result, Hashtable source) {
        String DEFAULT_LANGUAGELIB = (String)this.getDefault("LanguageLibraryUse");
        String elements = new String(DEFAULT_LANGUAGELIB);
        String value = (String)source.get("lang_lib");
        if (value != null) {
            elements = value;
        }
        this.resultPut(result, "LanguageLibraryUse", elements);
    }

    private void convertPAPERSIZE(Hashtable result, Hashtable source) {
        String[][] DEFAULT_PAPERSIZE = (String[][])this.getDefault("PaperSize");
        String[][] elements = this.clone2DArr(DEFAULT_PAPERSIZE);
        String value = (String)source.get("height");
        if (value != null) {
            elements[0][1] = value;
        }
        if ((value = (String)source.get("width")) != null) {
            elements[1][1] = value;
        }
        elements[2][1] = "mm";
        this.resultPut(result, "PaperSize", elements);
    }

    private void convertNUMERIC(Hashtable result, Hashtable source) {
        String thousandsSep;
        String[] DEFAULT_NUMBER_ELEMENTS = (String[])this.getDefault("NumberElements");
        String[] elements = (String[])DEFAULT_NUMBER_ELEMENTS.clone();
        String decimalPoint = (String)source.get("decimal_point");
        if (decimalPoint != null) {
            elements[0] = decimalPoint;
        }
        if ((thousandsSep = (String)source.get("thousands_sep")) != null) {
            elements[1] = thousandsSep;
        }
        this.resultPut(result, "NumberElements", elements);
        decimalPoint = ".";
        thousandsSep = ",";
        String[] DEFAULT_NUMBER_PATTERNS = (String[])this.getDefault("NumberPatterns");
        String[] patterns = (String[])DEFAULT_NUMBER_PATTERNS.clone();
        String patternDigit = elements[5];
        String zeroDigit = elements[4];
        String negativeSign = elements[6];
        String percentSign = elements[3];
        Object groupingObj = source.get("grouping");
        boolean isStrArray = groupingObj instanceof String[];
        String groupingString = isStrArray ? ((String[])groupingObj)[0] : (String)groupingObj;
        if (groupingString == null) {
            patterns[0] = this.replace(patterns[0], elements[0], "<DECIMAL>");
            patterns[0] = this.replace(patterns[0], elements[1], "<THOUSAND>");
            patterns[0] = this.replace(patterns[0], "<DECIMAL>", decimalPoint);
            patterns[0] = this.replace(patterns[0], "<THOUSAND>", thousandsSep);
            patterns[2] = this.replace(patterns[2], elements[1], "<THOUSAND>");
            patterns[2] = this.replace(patterns[2], "<THOUSAND>", thousandsSep);
        } else {
            int grouping = Integer.parseInt(groupingString);
            StringBuffer pattern = new StringBuffer();
            pattern.append(patternDigit);
            pattern.append(thousandsSep);
            int i = Math.max(1, grouping - 1);
            while (i > 0) {
                pattern.append(patternDigit);
                --i;
            }
            pattern.append(zeroDigit);
            pattern.append(decimalPoint);
            int i2 = Math.max(1, grouping - 1);
            while (i2 >= 0) {
                pattern.append(patternDigit);
                --i2;
            }
            String patternString = pattern.toString();
            patterns[0] = patternString + ";" + negativeSign + patternString;
            pattern.setLength(0);
            pattern.append(patternDigit);
            pattern.append(thousandsSep);
            int i3 = Math.max(1, grouping - 1);
            while (i3 > 0) {
                pattern.append(patternDigit);
                --i3;
            }
            pattern.append(zeroDigit);
            pattern.append(percentSign);
            patterns[2] = pattern.toString();
            String[] currencyElements = (String[])this.getDefault("CurrencyElements");
            String currency_symbol = (String)source.get("currency_symbol");
            currency_symbol = currency_symbol != null ? currency_symbol : (String)source.get("int_curr_symbol");
            currency_symbol = currency_symbol != null ? currency_symbol : "";
            String mon_decimal_point = (String)source.get("mon_decimal_point");
            mon_decimal_point = mon_decimal_point != null ? mon_decimal_point : "";
            String mon_thousands_sep = (String)source.get("mon_thousands_sep");
            mon_thousands_sep = mon_thousands_sep != null ? mon_thousands_sep : "";
            Object monGroupingObj = source.get("mon_grouping");
            String mon_grouping_string = monGroupingObj instanceof String[] ? ((String[])monGroupingObj)[0] : (String)monGroupingObj;
            int mon_grouping = mon_grouping_string == null ? grouping : Integer.parseInt(mon_grouping_string);
            String frac_digits_string = (String)source.get("frac_digits");
            int frac_digits = frac_digits_string == null ? mon_grouping : Integer.parseInt(frac_digits_string);
            String positive_sign = (String)source.get("positive_sign");
            positive_sign = positive_sign != null ? positive_sign : "";
            String negative_sign = (String)source.get("negative_sign");
            negative_sign = negative_sign != null ? negative_sign : "";
            String p_sign_posn = (String)source.get("p_sign_posn");
            p_sign_posn = p_sign_posn != null ? p_sign_posn : "";
            String n_sign_posn = (String)source.get("n_sign_posn");
            n_sign_posn = n_sign_posn != null ? n_sign_posn : "";
            boolean p_cs_precedes = !"0".equals(source.get("p_cs_precedes"));
            String p_sep_by_space = (String)source.get("p_sep_by_space");
            boolean n_cs_precedes = !"0".equals(source.get("n_cs_precedes"));
            String n_sep_by_space = (String)source.get("n_sep_by_space");
            pattern.setLength(0);
            patterns[1] = this.createPatternString(".", ",", mon_grouping, frac_digits, positive_sign, p_cs_precedes, p_sep_by_space, p_sign_posn, patternDigit, zeroDigit) + ";" + this.createPatternString(".", ",", mon_grouping, frac_digits, negative_sign, n_cs_precedes, n_sep_by_space, n_sign_posn, patternDigit, zeroDigit);
        }
        this.resultPut(result, "NumberPatterns", patterns);
    }

    private String createPatternString(String decimal, String thousands, int grouping, int fracDigits, String sign, boolean preceeds, String sep_by_space, String sign_posn, String digit, String requiredDigit) {
        int i;
        String quantity_currency_seperator;
        StringBuffer buffer = new StringBuffer();
        String currency = "\u00a4";
        if ("2".equals(sep_by_space) && ("".equals("\u00a4") || "".equals(sign))) {
            sep_by_space = "0";
        }
        if ("1".equals(sep_by_space) && "".equals("\u00a4")) {
            sep_by_space = "0";
        }
        String sign_currency_seperator = "2".equals(sep_by_space) ? " " : "";
        String string = quantity_currency_seperator = "1".equals(sep_by_space) ? " " : "";
        if ("0".equals(sign_posn)) {
            buffer.append('(');
        }
        if ("1".equals(sign_posn)) {
            buffer.append(sign);
            if (preceeds) {
                buffer.append(sign_currency_seperator);
            }
        }
        if (preceeds) {
            if ("3".equals(sign_posn)) {
                buffer.append(sign);
                buffer.append(sign_currency_seperator);
            }
            buffer.append("\u00a4");
            if ("4".equals(sign_posn)) {
                buffer.append(sign_currency_seperator);
                buffer.append(sign);
            }
            buffer.append(quantity_currency_seperator);
        }
        buffer.append(digit);
        if (grouping > 0) {
            buffer.append(thousands);
            i = grouping - 1;
            while (i > 0) {
                buffer.append(digit);
                --i;
            }
        }
        buffer.append(requiredDigit);
        buffer.append(decimal);
        if (fracDigits > 0) {
            i = fracDigits - 1;
            while (i >= 0) {
                buffer.append(requiredDigit);
                --i;
            }
        } else {
            buffer.append(digit);
        }
        if (!preceeds) {
            buffer.append(quantity_currency_seperator);
            if ("1".equals(sign_posn)) {
                buffer.append(sign_currency_seperator);
            }
            if ("3".equals(sign_posn)) {
                buffer.append(sign);
                buffer.append(sign_currency_seperator);
            }
            buffer.append("\u00a4");
            if ("4".equals(sign_posn)) {
                buffer.append(sign_currency_seperator);
                buffer.append(sign);
            }
        }
        if ("2".equals(sign_posn)) {
            buffer.append(sign_currency_seperator);
            buffer.append(sign);
        }
        if ("0".equals(sign_posn)) {
            buffer.append(')');
        }
        return buffer.toString();
    }

    private void convertTIME(Hashtable result, Hashtable source) {
        int ndx;
        String longishDateFormat;
        String[] newTemp;
        this.resultPut(result, "DayNames", source.get("day"));
        this.resultPut(result, "DayAbbreviations", source.get("abday"));
        String[] temp = (String[])source.get("am_pm");
        if (temp != null) {
            String[] defaultAMPM = (String[])this.getDefault("AmPmMarkers");
            if ("".equals(temp[0])) {
                temp[0] = defaultAMPM[0];
            }
            if ("".equals(temp[1])) {
                temp[1] = defaultAMPM[1];
            }
            this.resultPut(result, "AmPmMarkers", temp);
        }
        if ((temp = (String[])source.get("mon")) != null) {
            newTemp = new String[13];
            System.arraycopy(temp, 0, newTemp, 0, 12);
            newTemp[12] = "";
            this.resultPut(result, "MonthNames", newTemp);
        }
        if ((temp = (String[])source.get("abmon")) != null) {
            newTemp = new String[13];
            System.arraycopy(temp, 0, newTemp, 0, 12);
            newTemp[12] = "";
            this.resultPut(result, "MonthAbbreviations", newTemp);
        }
        String t_fmt_ampm = (String)source.get("t_fmt_ampm");
        String t_fmt = (String)source.get("t_fmt");
        String d_t_fmt = (String)source.get("d_t_fmt");
        String d_fmt = (String)source.get("d_fmt");
        String nlldate = (String)source.get("nlldate");
        String[] DEFAULT_DATETIME_ELEMENTS = (String[])this.getDefault("DateTimePatterns");
        String[] elements = (String[])DEFAULT_DATETIME_ELEMENTS.clone();
        String X_pattern = elements[3];
        String x_pattern = elements[7];
        String c_pattern = elements[4] + " " + elements[0];
        elements[0] = t_fmt_ampm != null && t_fmt_ampm.length() > 0 ? t_fmt_ampm : t_fmt;
        elements[1] = t_fmt != null ? t_fmt : t_fmt_ampm;
        elements[2] = t_fmt != null ? t_fmt : t_fmt_ampm;
        elements[3] = t_fmt != null ? t_fmt : t_fmt_ampm;
        String string = longishDateFormat = nlldate != null ? nlldate : d_fmt;
        if (d_t_fmt != null && t_fmt != null && (ndx = d_t_fmt.indexOf(t_fmt)) >= 0) {
            if (ndx < (d_t_fmt.length() - t_fmt.length()) / 2) {
                elements[8] = "{0} {1}";
            }
            longishDateFormat = this.replace(d_t_fmt, t_fmt, "");
            longishDateFormat = this.replace(longishDateFormat, "%Z", "");
            longishDateFormat = this.replace(longishDateFormat, "  ", " ");
            if ((longishDateFormat = this.replace(longishDateFormat, "  ", " ")).charAt(0) == ' ') {
                longishDateFormat = longishDateFormat.substring(1);
            }
            longishDateFormat.trim();
        }
        elements[4] = longishDateFormat;
        elements[5] = d_t_fmt;
        elements[6] = nlldate != null ? nlldate : d_fmt;
        elements[7] = d_fmt;
        int i = 0;
        while (i < 8) {
            elements[i] = elements[i] != null ? this.convertFormats(elements[i], X_pattern, x_pattern, c_pattern) : DEFAULT_DATETIME_ELEMENTS[i];
            ++i;
        }
        this.resultPut(result, "DateTimePatterns", elements);
    }

    private String convertFormats(String pattern, String X_pattern, String x_pattern, String c_pattern) {
        HexToUnicodeTransliterator huTranslit = myTranslit;
        huTranslit.applyPattern("<U0000>");
        ReplaceableString tempStr = new ReplaceableString();
        tempStr.replace(0, tempStr.length(), pattern);
        huTranslit.transliterate(tempStr);
        String tpattern = tempStr.toString();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < tpattern.length()) {
            char c = tpattern.charAt(i);
            if (c != '%') {
                result.append(c);
            } else {
                c = tpattern.charAt(++i);
                switch (c) {
                    case 'a': {
                        result.append("EEE");
                        break;
                    }
                    case 'A': {
                        result.append("EEEE");
                        break;
                    }
                    case 'b': {
                        result.append("MMM");
                        break;
                    }
                    case 'B': {
                        result.append("MMMM");
                        break;
                    }
                    case 'c': {
                        result.append(c_pattern);
                        break;
                    }
                    case 'C': {
                        result.append("YYYY");
                        break;
                    }
                    case 'd': {
                        result.append("dd");
                        break;
                    }
                    case 'D': {
                        result.append("mm/dd/yy");
                        break;
                    }
                    case 'e': {
                        result.append("dd");
                        break;
                    }
                    case 'h': {
                        result.append("MMM");
                        break;
                    }
                    case 'H': {
                        result.append("HH");
                        break;
                    }
                    case 'I': {
                        result.append("hh");
                        break;
                    }
                    case 'j': {
                        result.append("DDD");
                        break;
                    }
                    case 'm': {
                        result.append("MM");
                        break;
                    }
                    case 'M': {
                        result.append("mm");
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'p': {
                        result.append("aa");
                        break;
                    }
                    case 'r': {
                        result.append(this.convertFormats("%I:%M:%S %p", X_pattern, x_pattern, c_pattern));
                        break;
                    }
                    case 'S': {
                        result.append("ss");
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'T': {
                        result.append(this.convertFormats("%I:%M:%S", X_pattern, x_pattern, c_pattern));
                        break;
                    }
                    case 'U': {
                        result.append("ww");
                        break;
                    }
                    case 'w': {
                        result.append("E");
                        break;
                    }
                    case 'W': {
                        result.append("ww");
                        break;
                    }
                    case 'x': {
                        result.append(x_pattern);
                        break;
                    }
                    case 'X': {
                        result.append(X_pattern);
                        break;
                    }
                    case 'y': {
                        result.append("yy");
                        break;
                    }
                    case 'Y': {
                        result.append("yyyy");
                        break;
                    }
                    case 'Z': {
                        result.append("z");
                        break;
                    }
                    case '%': {
                        result.append("%");
                        break;
                    }
                    default: {
                        result.append('%');
                        result.append(c);
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    private void convertCOLLATE(Hashtable result, Hashtable source) {
        PosixCollationBuilder.CollationRule[] ruleSource;
        String[] sortOrder = (String[])source.get("sort_order");
        HexToUnicodeTransliterator huTranslit = myTranslit;
        huTranslit.applyPattern("<U0000>");
        ReplaceableString tempStr = new ReplaceableString();
        Object[][] DEFAULT_COLLATION = (Object[][])this.getDefault("CollationElements");
        Object[][] elements = this.clone2DArr(DEFAULT_COLLATION);
        huTranslit.transliterate(tempStr);
        if (sortOrder != null) {
            if (!"forward".equals(sortOrder[0])) {
                System.err.println("ERROR: Unsupported primary sort order: " + sortOrder[0]);
            }
            if (sortOrder.length == 2 && !"forward".equals(sortOrder[1]) && !"backward".equals(sortOrder[1])) {
                System.err.println("ERROR: Unsupported secondary sort order: " + sortOrder[1]);
            }
            if (sortOrder.length == 3 && !"forward".equals(sortOrder[2])) {
                System.err.println("ERROR: Unsupported tertiary sort order: " + sortOrder[2]);
            }
            if (sortOrder.length > 3) {
                System.err.println("WARNING: Sort levels of order greater than three ignored.");
            }
        }
        if ((ruleSource = (PosixCollationBuilder.CollationRule[])source.get("posix_sort_rules")) != null) {
            CollationItem[] rules = new CollationItem[ruleSource.length + 1];
            PosixCollationBuilder.CollationRule prevRule = null;
            int i = 0;
            int ndx = 0;
            while (ndx < ruleSource.length) {
                PosixCollationBuilder.CollationRule rule = ruleSource[ndx];
                if (rule.getSize() <= 1) {
                    if (prevRule == null) {
                        rules[i] = new CollationItem(rule.getSymbol());
                    } else {
                        int diff = prevRule.compare(rule);
                        rules[i] = new CollationItem(diff, rule.getSymbol());
                    }
                    rules[i++].setComment(rule.getSource());
                    prevRule = rule;
                }
                ++ndx;
            }
            String prevSeek = null;
            prevRule = null;
            int ndx2 = 0;
            while (ndx2 < ruleSource.length) {
                PosixCollationBuilder.CollationRule rule = ruleSource[ndx2];
                if (rule.getSize() > 1) {
                    String seek = rule.getExpansion();
                    if (!seek.equals(prevSeek)) {
                        PosixCollationBuilder.CollationRule seekRule = rule.seeksToRule();
                        rules[i] = new CollationItem(seekRule.compare(rule), rule.getSymbol(), rule.getExpansion());
                        prevSeek = seek;
                    } else {
                        rules[i] = prevRule != null ? new CollationItem(prevRule.compare(rule), rule.getSymbol(), prevRule.getSymbol()) : new CollationItem(rule.getSymbol());
                    }
                    rules[i++].setComment(rule.getSource());
                }
                prevRule = rule;
                ++ndx2;
            }
            elements[1][1] = "backward".equals(sortOrder[1]) ? "true" : "false";
            elements[2][1] = rules;
            this.resultPut(result, "CollationElements", elements);
        }
    }

    private void resultPut(Hashtable resultTable, String tag, Object value) {
        if (value == null) {
            return;
        }
        resultTable.put(tag, value);
    }

    private Object getDefault(String desiredResource) {
        return this.getParentBundle().getObject(desiredResource);
    }

    private ResourceBundle getParentBundle() {
        return ResourceBundle.getBundle("com.ibm.icu.dev.tool.localeconverter.myLocaleElements", this.parentLocale);
    }

    private String replace(String source, String target, String replacement) {
        if (target.equals(replacement)) {
            return source;
        }
        StringBuffer result = new StringBuffer();
        int lastNdx = 0;
        int ndx = source.indexOf(target);
        while (ndx >= 0) {
            result.append(source.substring(lastNdx, ndx));
            result.append(replacement);
            lastNdx = ndx += target.length();
            ndx = source.indexOf(target, ndx);
        }
        result.append(source.substring(lastNdx));
        return result.toString();
    }

    static /* synthetic */ Locale access$000(PosixToNeutralConverter x0) {
        return x0.locale;
    }

    static /* synthetic */ Object access$100(PosixToNeutralConverter x0, String x1) {
        return x0.getDefault(x1);
    }

    static /* synthetic */ void access$200(PosixToNeutralConverter x0, Hashtable x1, String x2, Object x3) {
        x0.resultPut(x1, x2, x3);
    }
}

