/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.Comparator;
import com.ibm.icu.dev.tool.localeconverter.PosixCharMap;
import com.ibm.icu.dev.tool.localeconverter.SortedVector;
import java.util.Enumeration;
import java.util.Hashtable;

class PosixCollationBuilder {
    private static final int MAX_WEIGHTS = 4;
    private static final int MAX_COMPOSITION = 4;
    private static int nextCharNumber = 1;
    private Hashtable weightSymbols = new Hashtable();
    private Hashtable contractions = new Hashtable();
    private Hashtable rules = new Hashtable();
    private CollationRule lastRule = null;
    private PosixCharMap map;
    private SortedVector order;
    private static int FIRST_WEIGHT_CHAR = 63487;
    private int nextWeightChar = FIRST_WEIGHT_CHAR;
    private CollationRule ignoreRule;
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PosixCollationBuilder(PosixCharMap map) {
        this.map = map;
        String ignoreSymbol = this.defineWeightSymbol("IGNORE");
        this.ignoreRule = new CollationRule(ignoreSymbol);
        this.rules.put(ignoreSymbol, this.ignoreRule);
        this.lastRule = this.ignoreRule;
    }

    public String defineWeightSymbol(String symbol) {
        this.order = null;
        String c = this.nextFreeWeightChar();
        this.map.defineMapping(symbol, c);
        this.weightSymbols.put(c, symbol);
        this.weightSymbols.put(symbol, c);
        return c;
    }

    public String defineContraction(String symbol, String value) {
        this.order = null;
        String c = this.nextFreeWeightChar();
        this.map.defineMapping(symbol, c);
        this.contractions.put(c, value);
        return c;
    }

    private String nextFreeWeightChar() {
        String mappedSource;
        String result = "";
        while ((result = "" + (char)this.nextWeightChar--) != (mappedSource = this.map.backmapValue(result))) {
        }
        return result;
    }

    public int ordinalityOf(String symbol) {
        CollationRule w = (CollationRule)this.rules.get(symbol);
        if (w != null) {
            return w.charNumber;
        }
        System.err.print("ERROR: Weight symbol not found: ");
        int i = 0;
        while (i < symbol.length()) {
            char c = symbol.charAt(i);
            System.err.print("\\u");
            System.err.print(HEX_DIGIT[(c & 0xF000) >> 12]);
            System.err.print(HEX_DIGIT[(c & 0xF00) >> 8]);
            System.err.print(HEX_DIGIT[(c & 0xF0) >> 4]);
            System.err.println(HEX_DIGIT[c & 0xF]);
            ++i;
        }
        System.err.println("       Weight given maximum possible value.");
        return Integer.MAX_VALUE;
    }

    public void addRule(String symbol) {
        if (symbol.length() > 1) {
            System.err.println("WARNING: Undefined element '" + symbol + "'.  collating-symbol generated.");
            symbol = this.defineWeightSymbol(symbol);
        }
        this.order = null;
        this.lastRule = new CollationRule(symbol);
        this.rules.put(symbol, this.lastRule);
    }

    public void addRule(CollationRule rule) {
        this.order = null;
        this.lastRule = rule;
        this.rules.put(rule.value, rule);
    }

    public void addWeight(String weight) {
        if (weight.length() > 1) {
            weight = this.map.mapKey(weight);
        }
        this.order = null;
        this.lastRule.addWeight(weight);
    }

    public Enumeration getRules() {
        return this.rules.elements();
    }

    public SortedVector getSortOrder() {
        if (this.order == null) {
            this.order = new SortedVector(new Comparator(){

                public int compare(Object i, Object j) {
                    boolean w2;
                    CollationRule o1 = (CollationRule)i;
                    CollationRule o2 = (CollationRule)j;
                    boolean w1 = o1.isWeightSymbol() != null;
                    boolean bl = w2 = o2.isWeightSymbol() != null;
                    if (w1 && !w2) {
                        return -1;
                    }
                    if (!w1 && w2) {
                        return 1;
                    }
                    return o1.compare(o2);
                }
            });
            this.order.addElements(this.rules.elements());
            int i = 0;
            while (i < this.order.size()) {
                CollationRule r = (CollationRule)this.order.elementAt(i);
                if (r.isWeightSymbol() == null) break;
                ++i;
            }
            this.order.removeElements(0, i);
        }
        return this.order;
    }

    public class CollationRule {
        int charNumber;
        String value;
        int nextWeight = 0;
        String[] weightSource = new String[4];
        int[][] weight = null;
        StringBuffer source = new StringBuffer();

        public CollationRule(String symbol) {
            this.charNumber = nextCharNumber++;
            this.value = symbol;
            int i = 0;
            while (i < 4) {
                this.weightSource[i] = symbol;
                ++i;
            }
            this.source.append(PosixCollationBuilder.this.map.backmapValue(symbol));
            this.source.append("\t\t");
        }

        private CollationRule(CollationRule other, int composition) {
            this.charNumber = other.charNumber;
            this.value = other.value;
            this.nextWeight = other.nextWeight;
            int i = 0;
            while (i < 4) {
                String source = other.weightSource[i];
                this.weightSource[i] = source.length() > composition ? "" + source.charAt(composition) : this.value;
                ++i;
            }
        }

        public void addWeight(String symbol) {
            if (symbol.length() > 4) {
                System.err.println("WARNING: Weights of composition greater than 4 were truncated.");
                symbol = symbol.substring(0, 4);
            }
            if (this.nextWeight < 4) {
                if (this.nextWeight > 0) {
                    this.source.append(";");
                }
                int i = 0;
                while (i < symbol.length()) {
                    this.source.append(PosixCollationBuilder.this.map.backmapValue("" + symbol.charAt(i)));
                    ++i;
                }
                this.weightSource[this.nextWeight++] = symbol;
                this.weight = null;
            }
        }

        public int compare(CollationRule other) {
            if (other == null) {
                return this.compare(PosixCollationBuilder.this.ignoreRule);
            }
            this.resolveWeights();
            other.resolveWeights();
            int compareSize = Math.min(this.getSize(), other.getSize());
            int j = 0;
            while (j < compareSize) {
                int i = 0;
                while (i < 4) {
                    int diff = this.weight[j][i] - other.weight[j][i];
                    if (diff < 0) {
                        return -(i + 1);
                    }
                    if (diff > 0) {
                        return i + 1;
                    }
                    ++i;
                }
                ++j;
            }
            return this.getSize() - other.getSize();
        }

        public boolean isMultiWeight() {
            return this.getSize() > 1;
        }

        public int getSize() {
            int size = 0;
            int i = 1;
            while (i < this.weightSource.length) {
                size = Math.max(size, this.weightSource[i].length());
                ++i;
            }
            return size;
        }

        public CollationRule getComponent(int ndx) {
            return new CollationRule(this, ndx);
        }

        public String getValue() {
            return this.value;
        }

        public String getSymbol() {
            String newValue = this.isContraction();
            if (newValue != null) {
                return newValue;
            }
            newValue = this.isWeightSymbol();
            if (newValue != null) {
                return newValue;
            }
            return this.value;
        }

        public String getSource() {
            return this.source.toString();
        }

        private String isContraction() {
            return (String)PosixCollationBuilder.this.contractions.get(this.value);
        }

        private String isWeightSymbol() {
            return (String)PosixCollationBuilder.this.weightSymbols.get(this.value);
        }

        public CollationRule seeksToRule() {
            CollationRule exp;
            CollationRule comp = this.getSize() <= 1 ? this : this.getComponent(0);
            int ndx = PosixCollationBuilder.this.order.indexOf(comp);
            if (ndx == 0) {
                return this;
            }
            do {
                exp = (CollationRule)PosixCollationBuilder.this.order.elementAt(ndx--);
            } while (ndx > 0 && exp.getSize() > 1);
            return exp;
        }

        public String getExpansion() {
            if (this.getSize() <= 1) {
                return null;
            }
            StringBuffer expansion = new StringBuffer();
            int j = 0;
            while (j < this.getSize()) {
                CollationRule exp;
                CollationRule comp = this.getComponent(j);
                int ndx = PosixCollationBuilder.this.order.indexOf(comp);
                do {
                    exp = (CollationRule)PosixCollationBuilder.this.order.elementAt(ndx--);
                } while (ndx >= 0 && exp.getSize() > 1);
                expansion.append(exp.getSymbol());
                ++j;
            }
            return expansion.toString();
        }

        public String toString() {
            return this.source.toString();
        }

        private void resolveWeights() {
            if (this.weight == null) {
                this.weight = new int[4][4];
                int j = 0;
                while (j < 4) {
                    String symbol = this.weightSource[j];
                    if (symbol.length() <= 1) {
                        this.weight[0][j] = PosixCollationBuilder.this.ordinalityOf(symbol);
                    } else {
                        int i = 0;
                        while (i < symbol.length()) {
                            char c = symbol.charAt(i);
                            this.weight[i][j] = PosixCollationBuilder.this.ordinalityOf("" + c);
                            ++i;
                        }
                    }
                    ++j;
                }
            }
        }
    }
}

