/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.EOLTransition;
import com.ibm.icu.dev.tool.localeconverter.Lex;
import com.ibm.icu.dev.tool.localeconverter.RangeTransition;
import com.ibm.icu.dev.tool.localeconverter.SpaceTransition;
import com.ibm.icu.dev.tool.localeconverter.SymbolTransition;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;

public class PosixCharMap {
    private Hashtable table = new Hashtable();
    private Hashtable backTable = null;
    private PosixCharMap parentMap;
    private String encoding;
    private static final char[] UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};

    public PosixCharMap() {
    }

    public PosixCharMap(PosixCharMap parent) {
        this.parentMap = parent;
    }

    public PosixCharMap(String fileName) throws IOException {
        this(new FileReader(fileName));
    }

    public PosixCharMap(String pathName, String fileName) throws IOException {
        this(new FileReader(new File(pathName, fileName)));
    }

    public PosixCharMap(Reader inputReader) throws IOException {
        this.load(new BufferedReader(inputReader));
    }

    public PosixCharMap getParent() {
        return this.parentMap;
    }

    public void setParent(PosixCharMap parent) {
        this.parentMap = parent;
    }

    public void load(String pathName, String fileName) throws IOException {
        this.load(new File(pathName, fileName), "");
    }

    public void load(String pathName, String fileName, String enc) throws IOException {
        this.load(new File(pathName, fileName), enc);
    }

    public void load(File file, String enc) throws IOException {
        this.encoding = enc;
        this.load(new BufferedReader(new FileReader(file)));
    }

    public static int unescapeAt(String s, int[] offset16) {
        int dig;
        int result = 0;
        int n = 0;
        int minDig = 0;
        int maxDig = 0;
        int bitsPerDigit = 4;
        int offset = offset16[0];
        int length = s.length();
        if (offset < 0 || offset >= length) {
            return -1;
        }
        int c = UTF16.charAt(s, offset);
        offset += UTF16.getCharCount(c);
        switch (c) {
            case 117: {
                maxDig = 4;
                minDig = 4;
                break;
            }
            case 85: {
                maxDig = 8;
                minDig = 8;
                break;
            }
            case 120: {
                minDig = 1;
                maxDig = 2;
                break;
            }
            default: {
                dig = UCharacter.digit(c, 8);
                if (dig < 0) break;
                minDig = 1;
                maxDig = 3;
                n = 1;
                bitsPerDigit = 3;
                result = dig;
            }
        }
        if (minDig != 0) {
            while (offset < length && n < maxDig) {
                c = s.charAt(offset);
                dig = Character.digit((char)c, bitsPerDigit == 3 ? 8 : 16);
                if (dig < 0) break;
                result = result << bitsPerDigit | dig;
                ++offset;
                ++n;
            }
            if (n < minDig) {
                return -1;
            }
            offset16[0] = offset;
            return result;
        }
        int i = 0;
        while (i < UNESCAPE_MAP.length) {
            if (c == UNESCAPE_MAP[i]) {
                offset16[0] = offset;
                return UNESCAPE_MAP[i + 1];
            }
            if (c < UNESCAPE_MAP[i]) break;
            i += 2;
        }
        offset16[0] = offset;
        return c;
    }

    public static String unescape(String s) {
        StringBuffer buf = new StringBuffer();
        int[] pos = new int[1];
        int i = 0;
        while (i < s.length()) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                pos[0] = i;
                int e = PosixCharMap.unescapeAt(s, pos);
                if (e < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence " + s.substring(i - 1, Math.min(i + 8, s.length())));
                }
                UTF16.append(buf, e);
                i = pos[0];
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * Loose catch block
     */
    public void load(Reader inputReader) throws IOException {
        block12: {
            PosixCharMap oldMap = SymbolTransition.getCharMap();
            SymbolTransition.setCharMap(null);
            try {
                block11: {
                    int state;
                    boolean TOKEN = true;
                    int EOF = 2;
                    int EOL = 3;
                    int RANGE = 4;
                    Lex.Transition[][] states1 = new Lex.Transition[][]{{new SpaceTransition(0), new EOLTransition(3), new Lex.EOFTransition(2), new Lex.DefaultTransition(0, -1)}, {new Lex.StringTransition(" \t", 1, 1), new Lex.StringTransition("\f\r\n\u2028\u2029", 1, 1), new Lex.EOFTransition(1), new Lex.DefaultTransition(0, -1)}};
                    Lex.Transition[][] states2 = new Lex.Transition[][]{{new Lex.EOFTransition(2), new EOLTransition(3), new SymbolTransition(1), new SpaceTransition(0), new RangeTransition(4), new Lex.DefaultTransition(0, 0)}};
                    PushbackReader input = new PushbackReader(inputReader);
                    Lex p = new Lex(states1, input);
                    while ((state = p.nextToken()) != 2 && !p.dataEquals("CHARMAP")) {
                    }
                    p.accept(3);
                    if (state == 2) break block11;
                    p = new Lex(states2, input);
                    state = p.nextToken();
                    while (state != 2) {
                        String key = p.getData();
                        if (p.dataEquals("ENDCHARMAP")) break;
                        state = p.nextToken();
                        while (state == 3) {
                            if (p.dataEquals("ENDCHARMAP")) break;
                            String data = PosixCharMap.unescape(p.getData());
                            data.trim();
                            if (data.startsWith("<U") || data.startsWith("#U")) {
                                String numData = data.substring(2, data.length() - 1);
                                int digit = Integer.parseInt(numData, 16);
                                this.defineMapping(key, "" + (char)digit);
                            } else if (data.startsWith("\\x")) {
                                byte[] encData = new byte[6];
                                int num = this.hexToByte(data, encData);
                                String tData = new String(encData, 0, num, this.encoding);
                                this.defineMapping(key, tData);
                            }
                            state = p.nextToken();
                            key = p.getData();
                        }
                        if (state != 4) continue;
                        String begin = key;
                        state = p.nextToken();
                        String end = p.getData();
                        state = p.nextToken();
                        String data = p.getData();
                        data.trim();
                        byte[] encData = new byte[6];
                        int num = this.hexToByte(data, encData);
                        String tData = new String(encData, 0, num, this.encoding);
                        int[] val = this.getInt(begin);
                        int beginRange = val[1];
                        val = this.getInt(end);
                        int endRange = val[1];
                        String stringVal = key.substring(0, val[0]);
                        int digit = tData.charAt(0);
                        while (beginRange <= endRange) {
                            this.defineMapping(stringVal + beginRange + ">", "" + (char)digit++);
                            ++beginRange;
                        }
                        state = p.nextToken();
                        key = p.getData();
                    }
                }
                Object var25_26 = null;
            }
            catch (Throwable throwable) {
                Object var25_28 = null;
                SymbolTransition.setCharMap(oldMap);
                throw throwable;
            }
            SymbolTransition.setCharMap(oldMap);
            {
                break block12;
                catch (EOFException e) {
                    Object var25_27 = null;
                    SymbolTransition.setCharMap(oldMap);
                }
            }
        }
    }

    public int[] getInt(String data) {
        int i = 0;
        int[] retVal = new int[2];
        int len = data.length();
        while (i < len) {
            if (data.charAt(i) - 48 < 9) break;
            ++i;
        }
        String sub = data.substring(i, len - 1);
        retVal[0] = i;
        retVal[1] = Integer.parseInt(sub, 10);
        return retVal;
    }

    public int hexToByte(String data, byte[] retval) {
        String tData = data;
        int i = 0;
        i = 0;
        while (i < data.length() / 4) {
            if (tData.charAt(0) == '\\' && tData.charAt(1) == 'x') {
                String numData = tData.substring(2, 4);
                retval[i] = (byte)Integer.parseInt(numData, 16);
                tData = tData.substring(4, tData.length());
            }
            ++i;
        }
        return i;
    }

    public void defineMapping(String from, String to) {
        this.table.put(from, to);
        this.backTable = null;
    }

    public void undefineMapping(String from) {
        this.table.remove(from);
        this.backTable = null;
    }

    public void swap() {
        Hashtable<String, String> newTable = new Hashtable<String, String>();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String code = (String)this.table.get(key);
            String newKey = this.toSymbol(code);
            String newCode = this.toLiteral(key);
            String prevCode = (String)newTable.get(newKey);
            if (prevCode != null && prevCode.compareTo(newCode) <= 0) continue;
            newTable.put(newKey, newCode);
        }
        this.table = newTable;
    }

    private String toLiteral(String code) {
        String data = code.substring(2, code.length() - 1);
        int digit = Integer.parseInt(data, 16);
        return "" + (char)digit;
    }

    private String toSymbol(String code) {
        StringBuffer escapeBuffer = new StringBuffer();
        escapeBuffer.append(">");
        int i = 0;
        while (i < code.length()) {
            int value = code.charAt(i) & 0xFFFF;
            while (value > 0 || escapeBuffer.length() < 5) {
                char digit = Character.forDigit(value % 16, 16);
                escapeBuffer.append(digit);
                value >>= 4;
            }
            ++i;
        }
        escapeBuffer.append("U<");
        escapeBuffer.reverse();
        return escapeBuffer.toString();
    }

    public void dump(PrintStream out) {
        StringBuffer escapeBuffer = new StringBuffer();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String code = (String)this.table.get(key);
            out.print(key);
            out.print("       <U");
            int i = 0;
            while (i < code.length()) {
                int value = code.charAt(i) & 0xFFFF;
                escapeBuffer.setLength(0);
                while (value > 0 || escapeBuffer.length() < 4) {
                    char digit = Character.forDigit(value % 16, 16);
                    escapeBuffer.append(digit);
                    value >>= 4;
                }
                escapeBuffer.reverse();
                out.print(escapeBuffer.toString());
                ++i;
            }
            out.println(">");
        }
    }

    public String mapKey(String key) {
        String result = (String)this.table.get(key);
        if (result == null) {
            result = this.parentMap != null ? this.parentMap.mapKey(key) : key;
        }
        return result;
    }

    public String backmapValue(String value) {
        String result;
        if (this.backTable == null) {
            this.backTable = new Hashtable();
            Enumeration enumeration = this.table.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String val = (String)this.table.get(key);
                this.backTable.put(val, key);
            }
        }
        if ((result = (String)this.backTable.get(value)) == null) {
            result = this.parentMap != null ? this.parentMap.backmapValue(value) : value;
        }
        return result;
    }

    public Enumeration keys() {
        return this.table.keys();
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public static void main(String[] args) {
        try {
            PosixCharMap map1 = new PosixCharMap("C:\\projects\\com\\taligent\\localeconverter\\CharMaps", "IBM-1129.UPMAP100.txt");
            map1.swap();
            map1.dump(System.out);
            SymbolTransition.setCharMap(map1);
            System.out.println();
            System.out.println();
            PosixCharMap map = new PosixCharMap("C:\\projects\\com\\taligent\\localeconverter\\CharMaps", "ibm1129.txt");
            map.dump(System.out);
            System.out.println();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

