/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.EOLTransition;
import com.ibm.icu.dev.tool.localeconverter.EscapeTransition;
import com.ibm.icu.dev.tool.localeconverter.Lex;
import com.ibm.icu.dev.tool.localeconverter.LineCharNumberReader;
import com.ibm.icu.dev.tool.localeconverter.LocaleConverter;
import com.ibm.icu.dev.tool.localeconverter.PosixCharMap;
import com.ibm.icu.dev.tool.localeconverter.PosixCollationBuilder;
import com.ibm.icu.dev.tool.localeconverter.PosixToNeutralConverter;
import com.ibm.icu.dev.tool.localeconverter.SortedVector;
import com.ibm.icu.dev.tool.localeconverter.SpaceTransition;
import com.ibm.icu.dev.tool.localeconverter.SymbolTransition;
import com.ibm.icu.dev.tool.localeconverter.TokenTransition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class POSIXLocaleReader {
    private final String localeDataPath;
    private final Locale locale;
    public static final int TAG_TOKEN = 1;
    public static final int SEPARATOR_TOKEN = 2;
    public static final int EOL_TOKEN = 3;
    public static final int EOF_TOKEN = 4;
    static final Lex.Transition[][] dataStates = new Lex.Transition[][]{{new SpaceTransition(0), new Lex.CharTransition(';', 1, 2), new Lex.CharTransition(',', 1, 2), new EOLTransition(3), new TokenTransition(1), new Lex.EOFTransition(4), new Lex.ParseExceptionTransition("unexpected characters")}};
    static final Lex.Transition[][] LCStates = new Lex.Transition[][]{{new SpaceTransition(0), new EOLTransition(3), new Lex.EOFTransition(4), new Lex.DefaultTransition(0, -1)}, {new Lex.StringTransition(" \t", 17, 1), new Lex.StringTransition("\f\r\n\u2028\u2029", 17, 1), new Lex.EOFTransition(1), new Lex.DefaultTransition(0, -1)}};

    public POSIXLocaleReader(String localeDataPath, Locale locale) {
        this.localeDataPath = localeDataPath;
        this.locale = locale;
    }

    public Hashtable parse(String fileName, byte flags) throws IOException {
        try {
            Hashtable table = this.parseNative(fileName);
            Hashtable result = new PosixToNeutralConverter(flags, this.locale, fileName).convert(table);
            return result;
        }
        catch (LocaleConverter.ConversionError e) {
            System.err.println("Internal error converting locale data");
            return null;
        }
    }

    public Hashtable parseNative(String fileName) throws IOException {
        char oldEscapeChar = EscapeTransition.setDefaultEscapeChar();
        char oldCommentChar = EOLTransition.setDefaultCommentChar();
        Hashtable table = new Hashtable();
        try {
            LineCharNumberReader lines = new LineCharNumberReader(new BufferedReader(new FileReader(new File(this.localeDataPath, fileName))));
            PushbackReader reader = new PushbackReader(lines);
            reader.unread(10);
            String sectionTag = this.seekLC(reader);
            while (sectionTag != null) {
                try {
                    this.parseSection(table, reader, sectionTag);
                }
                catch (Lex.ParseException e) {
                    System.err.println("ERROR parsing: " + e.reason);
                    System.err.println("         Line: " + lines.getLineNumber());
                    System.err.println("         char: " + lines.getCharNumber());
                    this.seekEND(reader);
                    System.err.println("Skipped to line: " + (lines.getLineNumber() + 1));
                }
                sectionTag = this.seekLC(reader);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            EscapeTransition.setEscapeChar(oldEscapeChar);
            EOLTransition.setCommentChar(oldCommentChar);
            throw throwable;
        }
        EscapeTransition.setEscapeChar(oldEscapeChar);
        EOLTransition.setCommentChar(oldCommentChar);
        return table;
    }

    private void parseSection(Hashtable table, PushbackReader reader, String sectionTag) throws IOException {
        if (sectionTag.equals("LC_CTYPE")) {
            this.parseCTYPE(table, reader);
        } else if (sectionTag.equals("LC_COLLATE")) {
            this.parseCOLLATE(table, reader);
        } else if (sectionTag.equals("LC_MONETARY")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_NUMERIC")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_TIME")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_MESSAGES")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_MEASUREMENT")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_ADDRESS")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_PAPER")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_NAME")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_IDENTIFICATION")) {
            this.parseLC(table, reader, sectionTag);
        } else if (sectionTag.equals("LC_TELEPHONE")) {
            this.parseLC(table, reader, sectionTag);
        } else {
            System.out.println("Unrecognised section:" + sectionTag);
            System.out.println("Default parsing applied.");
            this.parseLC(table, reader, sectionTag);
        }
    }

    private PushbackReader createParserInput(String localeName) throws IOException {
        PushbackReader reader = new PushbackReader(new BufferedReader(new FileReader(new File(this.localeDataPath, localeName))));
        reader.unread(10);
        return reader;
    }

    private String seekLC(PushbackReader reader) throws IOException {
        Lex p = new Lex(LCStates, reader);
        String LC = "LC_";
        int s = p.nextToken();
        while (s != 4) {
            if (s == 1) {
                if (p.dataStartsWith("LC_")) {
                    String tag = p.getData();
                    while ((s = p.nextToken()) != 3 && s != 4) {
                    }
                    return tag;
                }
                if (p.dataEquals("escape_char")) {
                    s = p.nextToken();
                    if (s == 1 || p.getData().length() != 1) {
                        String escape_char = p.getData();
                        EscapeTransition.setEscapeChar(escape_char.charAt(0));
                    } else {
                        System.out.println("Error in escape_char directive.  Directive ignored.");
                    }
                } else if (p.dataEquals("comment_char")) {
                    s = p.nextToken();
                    if (s == 1 || p.getData().length() != 1) {
                        String comment_char = p.getData();
                        EOLTransition.setCommentChar(comment_char.charAt(0));
                    } else {
                        System.out.println("Error in escape_char directive.  Directive ignored.");
                    }
                }
            }
            s = p.nextToken();
        }
        return null;
    }

    private boolean seekEND(PushbackReader reader) throws IOException {
        Lex p = new Lex(LCStates, reader);
        String END = "END";
        int s = p.nextToken();
        while (s != 4) {
            if (s == 1 && p.dataStartsWith("END")) {
                while ((s = p.nextToken()) != 3 && s != 4) {
                }
                return true;
            }
            s = p.nextToken();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void parseCTYPE(Hashtable table, PushbackReader reader) throws IOException {
        block3: {
            p = new Lex(POSIXLocaleReader.dataStates, reader);
            temp = new StringBuffer();
            s = p.nextToken();
            if (s != 1 || !p.dataEquals("copy")) ** GOTO lbl26
            p.accept(1);
            this.parseCopy("LC_CTYPE", p.getData(), table);
            p.accept(3);
            p.accept(1, "END");
            p.accept(1, "LC_CTYPE");
            break block3;
lbl-1000:
            // 1 sources

            {
                key = p.getData();
                temp.setLength(0);
                p.accept(1);
                p.appendDataTo(temp);
                s = p.nextToken();
                while (s == 2) {
                    p.accept(1);
                    p.appendDataTo(temp);
                    s = p.nextToken();
                }
                if (s != 3) {
                    throw new IOException();
                }
                table.put(key, temp.toString());
                s = p.nextToken();
lbl26:
                // 2 sources

                ** while (s == 1 && !p.dataEquals((String)"END"))
            }
lbl27:
            // 1 sources

            p.accept(1, "LC_CTYPE");
        }
    }

    private void parseCopy(String section, String toCopy, Hashtable t) throws IOException {
        char oldEscapeChar = EscapeTransition.setDefaultEscapeChar();
        char oldCommentChar = EOLTransition.setDefaultCommentChar();
        try {
            PushbackReader reader = this.createParserInput(toCopy);
            String tag = this.seekLC(reader);
            while (tag != null && !section.equals(tag)) {
                tag = this.seekLC(reader);
            }
            if (tag != null) {
                this.parseSection(t, reader, section);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            EscapeTransition.setEscapeChar(oldEscapeChar);
            EOLTransition.setCommentChar(oldCommentChar);
            throw throwable;
        }
        EscapeTransition.setEscapeChar(oldEscapeChar);
        EOLTransition.setCommentChar(oldCommentChar);
    }

    /*
     * Unable to fully structure code
     */
    private void parseLC(Hashtable t, PushbackReader reader, String sectionTag) throws IOException {
        block5: {
            input = new Lex(POSIXLocaleReader.dataStates, reader);
            input.accept(1);
            if (!input.dataEquals("copy")) ** GOTO lbl30
            input.accept(1);
            this.parseCopy(sectionTag, input.getData(), t);
            break block5;
lbl-1000:
            // 1 sources

            {
                label = input.getData();
                values = new Vector<String>();
                input.accept(1);
                temp = input.getData();
                values.addElement(temp);
                while (input.nextToken() == 2) {
                    input.accept(1);
                    value = input.getData();
                    values.addElement(value);
                }
                if (values.size() > 1) {
                    data = new String[values.size()];
                    values.copyInto(data);
                    t.put(label, data);
                } else {
                    t.put(label, values.elementAt(0));
                }
                if (input.getState() != 3) {
                    System.out.println("Extraneous text after label: " + label);
                    throw new IOException();
                }
                input.nextToken();
lbl30:
                // 2 sources

                ** while (input.getState() == 1 && !input.dataEquals((String)"END"))
            }
        }
        input.accept(1, sectionTag);
    }

    private void parseCOLLATE(Hashtable table, PushbackReader reader) throws IOException {
        PosixCharMap map = new PosixCharMap(SymbolTransition.getCharMap());
        SymbolTransition.setCharMap(map);
        try {
            Lex input = new Lex(dataStates, reader);
            PosixCollationBuilder builder = new PosixCollationBuilder(map);
            int s = input.nextToken();
            while (s == 3) {
                s = input.nextToken();
            }
            while (s == 1) {
                if (input.dataEquals("END")) break;
                if (input.dataEquals("UNDEFINED")) {
                    System.err.println("WARNING: Undefined characters will sort last.");
                    s = input.nextToken();
                    while (s != 4 && s != 3) {
                        s = input.nextToken();
                    }
                } else if (input.dataEquals("copy")) {
                    input.accept(1);
                    String toCopy = input.getData();
                    input.accept(3);
                    this.parseCopy("LC_COLLATE", toCopy, table);
                    System.err.println("Copying collation rules from " + toCopy + "...");
                } else if (input.dataEquals("...")) {
                    System.err.println("ERROR: Ellipsis not supported in collation rules.");
                    System.err.println("       Line ignored");
                } else if (input.dataEquals("replace-after")) {
                    System.err.println("ERROR: Replace-after not supported in collation rules.");
                    System.err.println("       Skipping until next replace-end.");
                    s = input.nextToken();
                    while (s != 4) {
                        if (s != 1 || !input.dataEquals("replace-end")) continue;
                        input.accept(3);
                        break;
                    }
                } else if (input.dataEquals("collating-element")) {
                    input.accept(1);
                    String key = input.getData();
                    input.accept(1, "from");
                    input.accept(1);
                    String value = input.getData();
                    builder.defineContraction(key, value);
                    input.accept(3);
                } else if (input.dataEquals("collating-symbol")) {
                    input.accept(1);
                    builder.defineWeightSymbol(input.getData());
                    input.accept(3);
                } else if (input.dataEquals("order_start")) {
                    Vector<String> tempVector = new Vector<String>();
                    input.accept(1);
                    tempVector.addElement(input.getData());
                    s = input.nextToken();
                    while (s == 2) {
                        input.accept(1);
                        tempVector.addElement(input.getData());
                        s = input.nextToken();
                    }
                    Object[] order_start = new String[tempVector.size()];
                    tempVector.copyInto(order_start);
                    table.put("sort_order", order_start);
                } else if (input.dataEquals("order_end")) {
                    input.accept(3);
                    SortedVector order = builder.getSortOrder();
                    Object[] ruleSource = new PosixCollationBuilder.CollationRule[order.size()];
                    order.copyInto(ruleSource);
                    table.put("posix_sort_rules", ruleSource);
                } else {
                    builder.addRule(input.getData());
                    s = input.nextToken();
                    while (s == 1) {
                        builder.addWeight(input.getData());
                        s = input.nextToken();
                        if (s != 2) continue;
                        s = input.nextToken();
                    }
                }
                s = input.nextToken();
            }
            input.accept(1, "LC_COLLATE");
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            SymbolTransition.setCharMap(map.getParent());
            throw throwable;
        }
        SymbolTransition.setCharMap(map.getParent());
    }
}

