/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.CollationItem;
import com.ibm.icu.dev.tool.localeconverter.LocaleConverter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class NeutralToJ1Converter
extends LocaleConverter {
    private static final Conversion[] conversions = new Conversion[]{new Conversion("LocaleString"), new Conversion("LocaleID"), new Conversion("ShortLanguage"), new Conversion("ShortCountry"), new Conversion("Languages"), new Conversion("Countries"), new Conversion("MonthNames", 0), new Conversion("MonthNames", 1), new Conversion("MonthNames", 2), new Conversion("MonthNames", 3), new Conversion("MonthNames", 4), new Conversion("MonthNames", 5), new Conversion("MonthNames", 6), new Conversion("MonthNames", 7), new Conversion("MonthNames", 8), new Conversion("MonthNames", 9), new Conversion("MonthNames", 10), new Conversion("MonthNames", 11), new Conversion("MonthNames", 12), new Conversion("MonthAbbreviations", 0), new Conversion("MonthAbbreviations", 1), new Conversion("MonthAbbreviations", 2), new Conversion("MonthAbbreviations", 3), new Conversion("MonthAbbreviations", 4), new Conversion("MonthAbbreviations", 5), new Conversion("MonthAbbreviations", 6), new Conversion("MonthAbbreviations", 7), new Conversion("MonthAbbreviations", 8), new Conversion("MonthAbbreviations", 9), new Conversion("MonthAbbreviations", 10), new Conversion("MonthAbbreviations", 11), new Conversion("MonthAbbreviations", 12), new Conversion("DayNames", 0), new Conversion("DayNames", 1), new Conversion("DayNames", 2), new Conversion("DayNames", 3), new Conversion("DayNames", 4), new Conversion("DayNames", 5), new Conversion("DayNames", 6), new Conversion("DayAbbreviations", 0), new Conversion("DayAbbreviations", 1), new Conversion("DayAbbreviations", 2), new Conversion("DayAbbreviations", 3), new Conversion("DayAbbreviations", 4), new Conversion("DayAbbreviations", 5), new Conversion("DayAbbreviations", 6), new Conversion("AmPmMarkers", 0), new Conversion("AmPmMarkers", 1), new Conversion("Eras"), new Conversion("NumberPatterns", 0), new Conversion("NumberPatterns", 1), new Conversion("NumberPatterns", 2), new Conversion("NumberElements", 0), new Conversion("NumberElements", 1), new Conversion("NumberElements", 2), new Conversion("NumberElements", 3), new Conversion("NumberElements", 4), new Conversion("NumberElements", 5), new Conversion("NumberElements", 6), new Conversion("NumberElements", 7), new Conversion("CurrencyElements", 0), new Conversion("CurrencyElements", 1), new Conversion("CurrencyElements", 2), new Conversion("DateTimePatterns", 0), new Conversion("DateTimePatterns", 1), new Conversion("DateTimePatterns", 2), new Conversion("DateTimePatterns", 3), new Conversion("DateTimePatterns", 4), new Conversion("DateTimePatterns", 5), new Conversion("DateTimePatterns", 6), new Conversion("DateTimePatterns", 7), new Conversion("DateTimePatterns", 8), new Conversion("DateTimeElements", 9), new Conversion("DateTimeElements", 10), new CollationConversion()};
    private Locale locale;
    private Locale parentLocale;
    private ResourceBundle defaultData;

    public NeutralToJ1Converter(Locale locale) {
        this.locale = locale;
        String language = locale.toString();
        String country = "";
        String variant = "";
        int ndx = language.indexOf(95);
        if (ndx >= 0) {
            country = language.substring(ndx + 1);
            language = language.substring(0, ndx);
        }
        if ((ndx = country.indexOf(95)) >= 0) {
            variant = country.substring(ndx);
            country = country.substring(0, ndx);
        }
        if ("".equals(country)) {
            language = "";
            variant = "";
        } else if ("".equals(variant)) {
            country = "";
        }
        this.parentLocale = new Locale(language, country, variant);
        this.defaultData = ResourceBundle.getBundle("com.ibm.icu.dev.tool.localeconverter.myLocaleElements", this.parentLocale);
    }

    protected void convert(Hashtable result, Hashtable source) throws LocaleConverter.ConversionError {
        Vector<Object> localeElements = new Vector<Object>();
        int i = 0;
        while (i < conversions.length) {
            Conversion conv = conversions[i];
            String newValue = conv.convert(source);
            if (newValue != null) {
                localeElements.addElement(newValue);
            } else {
                localeElements.addElement(this.defaultData.getObject(conv.getPropName()));
            }
            ++i;
        }
        result.put("LocaleElements", localeElements);
    }

    private static class CollationConversion
    extends Conversion {
        private CollationConversion() {
        }

        public String convert(Hashtable source) throws LocaleConverter.ConversionError {
            Object[][] elements = (Object[][])source.get("CollationElements");
            CollationItem[] items = (CollationItem[])elements[2][1];
            if (items == null) {
                return "";
            }
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                if (items[i] != null) {
                    result.append(items[i].toString());
                }
                ++i;
            }
            return result.toString();
        }
    }

    private static class Conversion {
        private String propName;
        private int ndx;

        protected Conversion() {
        }

        public Conversion(String propName) {
            this.propName = propName;
            this.ndx = -1;
        }

        public Conversion(String propName, int ndx) {
            this.propName = propName;
            this.ndx = ndx;
        }

        public String getPropName() {
            return this.propName;
        }

        public String convert(Hashtable source) throws LocaleConverter.ConversionError {
            Object sourceData = source.get(this.propName);
            if (sourceData == null) {
                return null;
            }
            if (this.ndx >= 0) {
                if (sourceData instanceof String[]) {
                    sourceData = ((String[])sourceData)[this.ndx];
                } else if (sourceData instanceof String[][]) {
                    sourceData = ((String[][])sourceData)[this.ndx];
                }
            }
            if (sourceData instanceof String) {
                return (String)sourceData;
            }
            if (sourceData instanceof String[]) {
                String[] data = (String[])sourceData;
                StringBuffer result = new StringBuffer();
                int i = 0;
                while (i < data.length) {
                    if (i > 0) {
                        result.append(';');
                    }
                    result.append(data[i]);
                    ++i;
                }
                return result.toString();
            }
            throw new LocaleConverter.ConversionError("could not convert tag: " + this.propName);
        }
    }
}

