/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.Comparator;
import com.ibm.icu.dev.tool.localeconverter.SortedVector;
import com.ibm.icu.text.HexToUnicodeTransliterator;
import com.ibm.icu.text.ReplaceableString;
import com.ibm.icu.text.UnicodeToHexTransliterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class LocaleWriter {
    private static final String INDENT_CHARS = "                                                                                                                        ";
    private static final char[] EOL_CHARS = new char[]{'\r', '\n', '\u2028', '\u2029'};
    private static final int INDENT_SIZE = 4;
    private static final int MAX_LINE_LENGTH = 80;
    private int indentLevel;
    private String indentString;
    private boolean needsIndent;
    protected StringBuffer lineBuffer = new StringBuffer();
    private int lineLength;
    protected PrintStream out;
    protected PrintStream err;
    public static final HexToUnicodeTransliterator huTranslit = new HexToUnicodeTransliterator("<U###0>");
    public static final UnicodeToHexTransliterator uhTranslit = new UnicodeToHexTransliterator("\\\\u0000");
    final File outFile = new File("cnvLoc.txt");
    FileOutputStream outFileStream;
    BufferedWriter outBufWrite;
    PrintWriter myOut;
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public LocaleWriter(PrintStream out) {
        this.out = out;
        this.err = out;
        try {
            this.outFile.canWrite();
            this.outFileStream = new FileOutputStream(this.outFile);
            this.outBufWrite = new BufferedWriter(new OutputStreamWriter((OutputStream)this.outFileStream, "UTF8"));
        }
        catch (IOException e) {
            System.out.println("Encoding unsupported");
            return;
        }
    }

    public LocaleWriter(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
        try {
            this.outFile.canWrite();
            this.outFileStream = new FileOutputStream(this.outFile);
            this.outBufWrite = new BufferedWriter(new OutputStreamWriter((OutputStream)this.outFileStream, "UTF8"));
        }
        catch (IOException e) {
            System.out.println("Encoding unsupported");
            return;
        }
    }

    public void write(Locale locale, Hashtable localeData) {
        this.open(locale);
        SortedVector order = new SortedVector(localeData.keys(), (Comparator)new SortedVector.StringComparator());
        Enumeration e = order.elements();
        while (e.hasMoreElements()) {
            Object data;
            String key = (String)e.nextElement();
            if (this.isDuplicateOfInheritedValue(locale, key, data = localeData.get(key))) {
                this.println("///* Discarding duplicate data for tag: " + key + " */");
                continue;
            }
            this.write(key, data);
        }
        this.close();
    }

    public void closeFileHandle() {
        try {
            this.outBufWrite.close();
        }
        catch (IOException excp) {
            this.out.println("could not close the output file");
        }
    }

    protected void write(String tag, Object o) {
        if (o instanceof String) {
            this.write(tag, (String)o);
        } else if (o instanceof String[]) {
            this.write(tag, (String[])o);
        } else if (o instanceof String[][]) {
            this.write(tag, (String[][])o);
        } else if (o instanceof Object[]) {
            Object[] data = (Object[])o;
            String[] temp = new String[data.length];
            int i = 0;
            while (i < data.length) {
                temp[i] = data[i].toString();
                ++i;
            }
            this.write(tag, temp);
        } else if (o instanceof Object[][]) {
            Object[][] data = (Object[][])o;
            String[][] temp = new String[data.length][];
            int i = 0;
            while (i < data.length) {
                temp[i] = new String[data[i].length];
                int j = 0;
                while (j < temp[i].length) {
                    temp[i][j] = data[i][j].toString();
                    ++j;
                }
                ++i;
            }
            this.write(tag, temp);
        } else {
            this.write(tag, o.toString());
        }
    }

    protected final void write(String tag, String[][] value) {
        if (value.length > 0) {
            if (value[0].length > 2) {
                this.write2D(tag, value);
            } else {
                this.writeTagged(tag, value);
            }
        } else {
            this.writeTagged(tag, value);
        }
    }

    protected abstract void open(Locale var1);

    protected abstract void write(String var1, String var2);

    protected abstract void write(String var1, String[] var2);

    protected abstract void write2D(String var1, String[][] var2);

    protected abstract void writeTagged(String var1, String[][] var2);

    protected abstract void close();

    protected abstract String getStringJoiningCharacter();

    protected void tabTo(int pos) {
        if (pos > this.lineLength) {
            int i = this.lineLength;
            while (i < pos) {
                this.print(" ");
                ++i;
            }
        }
    }

    protected void writeToFile(String str) {
        ReplaceableString tempStr = new ReplaceableString();
        tempStr.replace(0, tempStr.length(), str);
        try {
            this.outBufWrite.write(tempStr.toString());
        }
        catch (IOException e) {
            this.out.println("Could not write to file");
        }
    }

    protected void print(String val) {
        if (this.needsIndent) {
            this.out.print(this.indentString);
            this.writeToFile(this.indentString);
            this.lineLength += this.indentString.length();
            this.needsIndent = false;
        }
        ReplaceableString tempStr = new ReplaceableString();
        tempStr.replace(0, tempStr.length(), val);
        huTranslit.transliterate(tempStr);
        String tval = tempStr.toString();
        if (tval.length() < val.length()) {
            tval = this.prependEsc(tempStr.toString());
        }
        if (tval != null) {
            this.out.print(tval);
            this.writeToFile(tval);
            int len = 0;
            int i = 0;
            while (i < EOL_CHARS.length) {
                len = Math.max(len, tval.lastIndexOf(EOL_CHARS[i]));
                ++i;
            }
            this.lineLength = len == 0 ? (this.lineLength += tval.length()) : tval.length() - len;
        }
    }

    protected String prependEsc(String str) {
        StringBuffer myStr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch > '\u007f') {
                myStr.append("\\u");
                myStr.append(this.toHexString(ch, 16, 4));
            } else {
                myStr.append(ch);
            }
            ++i;
        }
        return myStr.toString();
    }

    protected String toHexString(char ch, int radix, int pad) {
        int MAX_DIGITS = 10;
        int length = 0;
        char[] buffer = new char[10];
        int num = 0;
        int i = ch;
        do {
            int digit = i % radix;
            char c = buffer[length++] = digit <= 9 ? (char)(48 + digit) : (char)(48 + digit + 7);
        } while ((i /= radix) > 0);
        while (length < pad) {
            buffer[length++] = 48;
        }
        if (length < 10) {
            buffer[length] = '\u0000';
        }
        num = pad >= length ? pad : length;
        int j = 0;
        while (j < num / 2) {
            char temp = buffer[length - 1 - j];
            buffer[length - 1 - j] = buffer[j];
            buffer[j] = temp;
            ++j;
        }
        return new String(buffer, 0, length);
    }

    protected void println(String val) {
        this.print(val);
        this.out.println();
        this.writeToFile("\n");
        this.lineLength = 0;
        this.needsIndent = true;
    }

    protected void printString(String val) {
        if (val != null) {
            this.indent();
            this.lineBuffer.setLength(0);
            this.lineBuffer.append("\"");
            int size = val.length();
            int i = 0;
            while (i < size) {
                this.append(val.charAt(i));
                ++i;
            }
            this.lineBuffer.append("\"");
            this.print(this.lineBuffer.toString());
            this.outdent();
        } else {
            this.print("\"\"");
        }
    }

    protected boolean append(char c) {
        boolean escape = this.isEscapeChar(c);
        if (escape) {
            this.appendEscapedChar(c, this.lineBuffer);
        } else {
            this.lineBuffer.append(c);
        }
        return this.lineLength + this.lineBuffer.length() < 80;
    }

    protected boolean isEscapeChar(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case '\"': 
            case '\\': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return c < ' ' || c > '\u007f';
    }

    protected void appendEscapedChar(char c, StringBuffer buffer) {
        buffer.append(this.getEscapeChar());
        int value = c & 0xFFFF;
        buffer.append(HEX_DIGIT[(value & 0xF000) >> 12]);
        buffer.append(HEX_DIGIT[(value & 0xF00) >> 8]);
        buffer.append(HEX_DIGIT[(value & 0xF0) >> 4]);
        buffer.append(HEX_DIGIT[value & 0xF]);
    }

    protected String getEscapeChar() {
        return "\\u";
    }

    protected final void indent() {
        this.indent(1);
    }

    protected void indent(int amount) {
        this.indentLevel += amount;
        this.indentString = INDENT_CHARS.substring(0, this.indentLevel * 4);
    }

    protected final void outdent() {
        this.outdent(1);
    }

    protected void outdent(int amount) {
        this.indentLevel -= amount;
        this.indentString = INDENT_CHARS.substring(0, this.indentLevel * 4);
    }

    private boolean isDuplicateOfInheritedValue(Locale loc, String tag, Object value) {
        if (value == null) {
            return true;
        }
        try {
            ResourceBundle parentBundle = this.getParentBundle(loc);
            if (parentBundle == null) {
                return false;
            }
            Object parentValue = parentBundle.getObject(tag);
            return this.objectsAreEqual(value, parentValue);
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    private boolean objectsAreEqual(Object item, Object parentItem) {
        if (item instanceof Object[] && parentItem instanceof Object[]) {
            return this.arraysAreEqual((Object[])item, (Object[])parentItem);
        }
        return item.equals(parentItem);
    }

    private boolean arraysAreEqual(Object[] item, Object[] parentItem) {
        boolean matches = item.length == parentItem.length;
        int i = 0;
        while (i < item.length && matches) {
            matches = this.objectsAreEqual(item[i], parentItem[i]);
            ++i;
        }
        return matches;
    }

    private ResourceBundle getParentBundle(Locale loc) {
        try {
            String x = loc.toString();
            int ndx = x.lastIndexOf(95);
            if (ndx < 0) {
                return null;
            }
            String parentLocName = x.substring(0, ndx);
            Locale parentLoc = this.localeFromString(parentLocName);
            return ResourceBundle.getBundle("com.ibm.icu.dev.tool.localeconverter.myLocaleElements", parentLoc);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private String replace(String source, String target, String replacement) {
        if (target.equals(replacement)) {
            return source;
        }
        StringBuffer result = new StringBuffer();
        int lastNdx = 0;
        int ndx = source.indexOf(target);
        while (ndx >= 0) {
            result.append(source.substring(lastNdx, ndx));
            result.append(replacement);
            lastNdx = ndx += target.length();
            ndx = source.indexOf(target, ndx);
        }
        result.append(source.substring(lastNdx));
        return result.toString();
    }

    public Locale localeFromString(String localeName) {
        String language = localeName;
        String country = "";
        String variant = "";
        int ndx = language.indexOf(95);
        if (ndx >= 0) {
            country = language.substring(ndx + 1);
            language = language.substring(0, ndx);
        }
        if ((ndx = country.indexOf(95)) >= 0) {
            variant = country.substring(ndx);
            country = country.substring(0, ndx);
        }
        return new Locale(language, country, variant);
    }
}

