/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineCharNumberReader
extends BufferedReader {
    private int lineNumber = 0;
    private int charNumber = 0;
    private int markedLineNumber;
    private int markedCharNumber;
    private boolean skipLF;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    public LineCharNumberReader(Reader in) {
        super(in);
    }

    public LineCharNumberReader(Reader in, int sz) {
        super(in, sz);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharNumber() {
        return this.charNumber;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int c = super.read();
            ++this.charNumber;
            if (this.skipLF) {
                if (c == 10) {
                    c = super.read();
                }
                this.skipLF = false;
            }
            switch (c) {
                case 13: {
                    this.skipLF = true;
                }
                case 10: 
                case 8232: 
                case 8233: {
                    ++this.lineNumber;
                    this.charNumber = 0;
                    int n = 10;
                    return n;
                }
            }
            int n = c;
            return n;
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = super.read(cbuf, off, len);
            int i = off;
            while (i < off + len) {
                block11: {
                    char c;
                    block10: {
                        c = cbuf[i];
                        ++this.charNumber;
                        if (!this.skipLF) break block10;
                        this.skipLF = false;
                        if (c == '\n') break block11;
                    }
                    switch (c) {
                        case '\r': {
                            this.skipLF = true;
                        }
                        case '\n': 
                        case '\u2028': 
                        case '\u2029': {
                            ++this.lineNumber;
                            this.charNumber = 0;
                        }
                    }
                }
                ++i;
            }
            int n2 = n;
            return n2;
        }
    }

    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String l = super.readLine();
            if (l != null) {
                ++this.lineNumber;
            }
            this.charNumber = 0;
            this.skipLF = false;
            String string = l;
            return string;
        }
    }

    public long skip(long n) throws IOException {
        int nn = (int)Math.min(n, 8192L);
        Object object = this.lock;
        synchronized (object) {
            if (this.skipBuffer == null || this.skipBuffer.length < nn) {
                this.skipBuffer = new char[nn];
            }
            long r = n;
            while (r > 0L) {
                int nc = this.read(this.skipBuffer, 0, nn);
                if (nc == -1) break;
                r -= (long)nc;
            }
            long l = n - r;
            return l;
        }
    }

    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(readAheadLimit);
            this.markedLineNumber = this.lineNumber;
            this.markedCharNumber = this.charNumber;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.reset();
            this.lineNumber = this.markedLineNumber;
            this.charNumber = this.markedCharNumber;
        }
    }
}

