/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import java.io.IOException;
import java.io.PushbackReader;

public final class Lex {
    private Transition[][] states;
    private PushbackReader input;
    private int state;
    private String data;
    private final StringBuffer dataBuffer = new StringBuffer();
    private boolean debugMessagesOn;
    private String debugTag;
    public static final int END_OF_FILE = Integer.MAX_VALUE;
    public static final byte IGNORE = 1;
    public static final byte ACCUMULATE = 0;
    private static final byte BUFFER_MASK = 1;
    public static final byte CONSUME = 0;
    public static final byte PUTBACK = 16;
    private static final byte INPUT_MASK = 16;
    public static final byte ACCUMULATE_CONSUME = 0;
    public static final byte IGNORE_CONSUME = 1;
    public static final byte ACCUMULATE_PUTBACK = 16;
    public static final byte IGNORE_PUTBACK = 17;

    public Lex(Transition[][] states) {
        this.states = states;
    }

    public Lex(Transition[][] statesIn, PushbackReader inputIn) {
        this.states = statesIn;
        this.input = inputIn;
    }

    public int getState() {
        return this.state;
    }

    public String getData() {
        if (this.data == null) {
            this.data = this.dataBuffer.toString();
        }
        return this.data;
    }

    public PushbackReader getInput() {
        return this.input;
    }

    public void setInput(PushbackReader input) {
        this.input = input;
    }

    public Transition[][] getStates() {
        return this.states;
    }

    public void setStates(Transition[][] states) {
        this.states = states;
    }

    public boolean dataEquals(String other) {
        if (this.data != null) {
            return this.data.equals(other);
        }
        if (other.length() != this.dataBuffer.length()) {
            return false;
        }
        int len = this.dataBuffer.length();
        int i = 0;
        while (i < len) {
            if (other.charAt(i) != this.dataBuffer.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void appendDataTo(StringBuffer buffer) {
        buffer.append((Object)this.dataBuffer);
    }

    public boolean dataStartsWith(String s) {
        if (this.dataBuffer.length() < s.length()) {
            return false;
        }
        int sLength = s.length();
        int i = 0;
        while (i < sLength) {
            if (this.dataBuffer.charAt(i) != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int dataAsNumber(int radix) {
        int value = 0;
        int len = this.dataBuffer.length();
        int i = 0;
        while (i < len) {
            value = value * radix + Character.digit(this.dataBuffer.charAt(i), radix);
            ++i;
        }
        return value;
    }

    public int nextToken() throws IOException {
        this.state = 0;
        this.dataBuffer.setLength(0);
        block0: do {
            int c = this.input.read();
            Transition[] transition = this.states[-this.state];
            int i = 0;
            while (i < transition.length) {
                if (transition[i].accepts(c)) {
                    this.state = transition[i].doAction(c, this.input, this.dataBuffer);
                    continue block0;
                }
                ++i;
            }
        } while (this.state <= 0);
        this.data = null;
        return this.state;
    }

    public void accept(int neededState) throws IOException {
        if (neededState != this.nextToken()) {
            Exception e = new Exception();
            e.printStackTrace();
            throw new ParseException("Unexpected token - " + this.getData());
        }
    }

    public void accept(int neededState, String neededValue) throws IOException {
        this.accept(neededState);
        if (!this.dataEquals(neededValue)) {
            Exception e = new Exception();
            e.printStackTrace();
            throw new ParseException("Unexpected token - " + this.getData());
        }
    }

    public void debug(boolean debugMessagesOn) {
        this.debugMessagesOn = debugMessagesOn;
        this.debugTag = null;
    }

    public void debug(boolean debugMessagesOn, String tag) {
        this.debugMessagesOn = debugMessagesOn;
        this.debugTag = tag;
    }

    public static final class ParseExceptionTransition
    implements Transition {
        private String reason;

        public ParseExceptionTransition(String reason) {
            this.reason = reason;
        }

        public boolean accepts(int c) {
            return true;
        }

        public final int doAction(int c, PushbackReader input, StringBuffer buffer) throws IOException {
            input.unread((char)c);
            throw new ParseException(this.reason);
        }
    }

    public static final class ParseException
    extends IOException {
        public final String reason;

        public ParseException() {
            this.reason = "unkown";
        }

        public ParseException(String reason) {
            this.reason = reason;
        }

        public String toString() {
            return this.reason;
        }
    }

    public static final class ExceptionTransition
    extends BaseTransition {
        private IOException e;

        public ExceptionTransition(IOException e) {
            super((byte)17, Integer.MAX_VALUE);
        }

        public ExceptionTransition(byte action, IOException e) {
            super(action, Integer.MAX_VALUE);
        }

        public boolean accepts(int c) {
            return true;
        }

        public final int doAction(int c, PushbackReader input, StringBuffer buffer) throws IOException {
            super.doAction(c, input, buffer);
            throw this.e;
        }
    }

    public static final class CharTransition
    extends BaseTransition {
        private char c;

        public CharTransition(char c, byte action, int nextState) {
            super(action, nextState);
            this.c = c;
        }

        public boolean accepts(int c) {
            return this.c == (char)c;
        }
    }

    public static final class StringTransition
    extends BaseTransition {
        private String chars;

        public StringTransition(String chars, byte action, int nextState) {
            super(action, nextState);
            this.chars = chars;
        }

        public boolean accepts(int c) {
            return this.chars.indexOf((char)c) != -1;
        }
    }

    public static final class DefaultTransition
    extends BaseTransition {
        public DefaultTransition(byte action, int nextState) {
            super(action, nextState);
        }

        public boolean accepts(int c) {
            return true;
        }
    }

    public static final class EOFTransition
    extends BaseTransition {
        public EOFTransition() {
            this(1, Integer.MAX_VALUE);
        }

        public EOFTransition(int next) {
            this(1, next);
        }

        public EOFTransition(byte action, int next) {
            super(action, next);
        }

        public boolean accepts(int c) {
            return c == -1;
        }
    }

    public static abstract class BaseTransition
    implements Transition {
        private final boolean addToBuffer;
        private final boolean unreadInput;
        private final int next;

        public BaseTransition(byte action, int next) {
            this.addToBuffer = (action & 1) == 0;
            this.unreadInput = (action & 0x10) == 16;
            this.next = next;
        }

        public abstract boolean accepts(int var1);

        public int doAction(int c, PushbackReader input, StringBuffer buffer) throws IOException {
            if (this.addToBuffer) {
                buffer.append((char)c);
            }
            if (this.unreadInput) {
                input.unread(c);
            }
            return this.next;
        }
    }

    public static interface Transition {
        public boolean accepts(int var1);

        public int doAction(int var1, PushbackReader var2, StringBuffer var3) throws IOException;
    }
}

