/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.CollationItem;
import com.ibm.icu.dev.tool.localeconverter.LocaleWriter;
import java.io.PrintStream;
import java.util.Locale;

public class JavaLocaleWriter
extends LocaleWriter {
    private static final String HEADER = "package java.text.resources;\nimport java.util.ListResourceBundle;\npublic class TestLocaleElements extends ListResourceBundle {\n    public Object[][] getContents() {\n        return new Object[][] {";
    private static final String FOOTER = "        };\n    }\n}";

    public JavaLocaleWriter(PrintStream out) {
        super(out);
    }

    public JavaLocaleWriter(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public void open(Locale locale) {
        this.println(HEADER);
        this.indent(3);
    }

    protected void write(String tag, Object o) {
        if ("CollationElements".equals(tag)) {
            this.writeTagged(tag, (Object[][])o);
        } else if (!(o instanceof CollationItem[])) {
            super.write(tag, o);
        } else {
            CollationItem[] items = (CollationItem[])o;
            this.print("{ ");
            this.printString("CollationElements");
            this.println(", ");
            int i = 0;
            while (i < items.length) {
                if (items[i] != null) {
                    this.printString(items[i].toString());
                    if (items[i].comment != null) {
                        this.print("+");
                        this.tabTo(30);
                        this.print("//");
                        this.println(items[i].comment);
                    } else {
                        this.println("+");
                    }
                }
                ++i;
            }
            this.println("\"\"");
            this.println(" },");
        }
    }

    public void write(String tag, String value) {
        this.print("{ ");
        this.printString(tag);
        this.print(", ");
        this.printString(value);
        this.println(" },");
    }

    public void write(String tag, String[] value) {
        this.print("{ ");
        if (tag != null) {
            this.printString(tag);
            this.println(",");
        } else {
            this.println("");
        }
        this.indent();
        this.println("new String[] {");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.printString(value[i]);
            this.println(",");
            ++i;
        }
        this.outdent();
        this.println("}");
        this.outdent();
        this.println("},");
    }

    public void write2D(String tag, String[][] value) {
        this.print("{ ");
        this.printString(tag);
        this.println(",");
        this.indent();
        this.println("new String[][] {");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.println("{");
            this.indent();
            int j = 0;
            while (j < value[i].length) {
                this.printString(value[i][j]);
                this.println(",");
                ++j;
            }
            this.outdent();
            this.println("},");
            ++i;
        }
        this.outdent();
        this.println("}");
        this.outdent();
        this.println("},");
    }

    public void writeTagged(String tag, String[][] value) {
        this.print("{ ");
        this.printString(tag);
        this.println(",");
        this.indent();
        this.println("new String[][] {");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write(value[i][0], value[i][1]);
            ++i;
        }
        this.outdent();
        this.println("}");
        this.outdent();
        this.println("},");
    }

    public void writeTagged(String tag, Object[][] value) {
        this.print("{ ");
        this.printString(tag);
        this.println(",");
        this.indent();
        this.println("new String[][] {");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write((String)value[i][0], value[i][1]);
            ++i;
        }
        this.outdent();
        this.println("}");
        this.outdent();
        this.println("},");
    }

    public void close() {
        this.outdent(3);
        this.print(FOOTER);
        this.println("");
    }

    protected void appendEscapedChar(char c, StringBuffer buffer) {
        if (c < ' ' || c == '\"' || c == '\\') {
            buffer.append('\\');
            buffer.append(LocaleWriter.HEX_DIGIT[(c & 0x1C0) >> 6]);
            buffer.append(LocaleWriter.HEX_DIGIT[(c & 0x38) >> 3]);
            buffer.append(LocaleWriter.HEX_DIGIT[c & 7]);
        } else {
            super.appendEscapedChar(c, buffer);
        }
    }

    protected String getStringJoiningCharacter() {
        return "+";
    }
}

