/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.LocaleConverter;
import com.ibm.icu.dev.tool.localeconverter.LocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.NeutralToJ1Converter;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Locale;

public class Java1LocaleWriter
extends LocaleWriter {
    private static final String HEADER1 = "package java.text.resources;\npublic class LocaleElements_";
    private static final String HEADER2 = " extends LocaleData {\n    public LocaleElements_";
    private static final String HEADER3 = "() {\n        super.init(table);\n    }\n    static String table []=";
    private static final String FOOTER = "    }\n}";

    public Java1LocaleWriter(PrintStream out) {
        super(out);
    }

    public Java1LocaleWriter(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public void write(Locale locale, Hashtable localeData) {
        try {
            Hashtable temp = new NeutralToJ1Converter(locale).convert(localeData);
            super.write(locale, temp);
        }
        catch (LocaleConverter.ConversionError e) {
            this.err.println(e);
        }
    }

    protected void open(Locale locale) {
        this.print(HEADER1);
        this.print(locale.toString());
        this.print(HEADER2);
        this.print(locale.toString());
        this.println(HEADER3);
        this.indent(3);
    }

    protected void write(String tag, String value) {
        this.print("{ ");
        this.printString(tag);
        this.print(", ");
        this.printString(value);
        this.println(" },");
    }

    protected void write(String tag, String[] value) {
        this.print("{ ");
        if (tag != null) {
            this.printString(tag);
            this.println(",");
        } else {
            this.println("");
        }
        this.indent();
        this.println("new String[] {");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.printString(value[i]);
            this.println(",");
            ++i;
        }
        this.outdent();
        this.println("}");
        this.outdent();
        this.println("},");
    }

    protected void write2D(String tag, String[][] value) {
        this.print("{ ");
        this.printString(tag);
        this.println(",");
        this.indent();
        this.println("new String[][] {");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.println("{");
            this.indent();
            int j = 0;
            while (j < value[i].length) {
                this.printString(value[i][j]);
                this.println(",");
                ++j;
            }
            this.outdent();
            this.println("},");
            ++i;
        }
        this.outdent();
        this.println("}");
        this.outdent();
        this.println("},");
    }

    protected void writeTagged(String tag, String[][] value) {
        this.print("{ ");
        this.printString(tag);
        this.println(",");
        this.indent();
        this.println("new String[][] {");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write(value[i][0], value[i][1]);
            ++i;
        }
        this.outdent();
        this.println("}");
        this.outdent();
        this.println("},");
    }

    protected void close() {
        this.outdent(3);
        this.print(FOOTER);
    }

    protected void appendEscapedChar(char c, StringBuffer buffer) {
        if (c < ' ' || c == '\"' || c == '\\') {
            buffer.append('\\');
            buffer.append(LocaleWriter.HEX_DIGIT[(c & 0x1C0) >> 6]);
            buffer.append(LocaleWriter.HEX_DIGIT[(c & 0x38) >> 3]);
            buffer.append(LocaleWriter.HEX_DIGIT[c & 7]);
        } else {
            super.appendEscapedChar(c, buffer);
        }
    }

    protected String getStringJoiningCharacter() {
        return "+";
    }
}

