/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.LocaleWriter;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.ListResourceBundle;
import java.util.Locale;

public class ICU3LocaleWriter
extends LocaleWriter {
    private ListResourceBundle bundle = null;

    public ICU3LocaleWriter(PrintStream out) {
        super(out);
    }

    protected void open(Locale locale) {
        this.print(locale.toString());
        this.println(" {");
        this.indent();
    }

    public ICU3LocaleWriter(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public ICU3LocaleWriter(ListResourceBundle bundle, PrintStream out, PrintStream err) {
        super(out, err);
        this.bundle = bundle;
    }

    public void write(Locale locale) {
        this.open(locale);
        Enumeration<String> keys = this.bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object o = this.bundle.getObject(key);
            this.write(key, o);
        }
        this.close();
    }

    public void write(String key, Object o) {
        if (key != null) {
            this.print(key);
        }
        if (o instanceof String) {
            this.write((String)o);
        } else if (o instanceof Integer[]) {
            this.write((Integer[])o);
        } else if (o instanceof byte[]) {
            this.write((byte[])o);
        } else if (o instanceof Integer) {
            this.write((Integer)o);
        } else if (o instanceof Object[][]) {
            this.write((Object[][])o);
        } else if (o instanceof Object[]) {
            this.write((Object[])o);
        }
    }

    protected void write(String str) {
        this.print("{");
        this.printString(str);
        this.println("}");
    }

    protected void write(Integer[] o) {
        this.println(":intvector { ");
        this.indent();
        if (o != null) {
            int i = 0;
            while (i < o.length) {
                this.print(o[i].toString());
                this.println(",");
                ++i;
            }
        }
        this.outdent();
        this.println(" }");
    }

    private String toHex(byte b) {
        char i = (char)(b & 0xFF);
        String temp = Integer.toHexString(i);
        if (temp.length() < 2) {
            return "0" + temp;
        }
        return temp;
    }

    protected void write(byte[] o) {
        this.print(":bin{ ");
        this.indent();
        if (o != null) {
            int i = 0;
            while (i < o.length) {
                this.print(this.toHex(o[i]));
                ++i;
            }
        }
        this.outdent();
        this.println(" }");
    }

    protected void write(Integer o) {
        this.print(":int { ");
        this.indent();
        if (o != null) {
            this.print(o.toString());
        }
        this.outdent();
        this.println(" }");
    }

    protected void write(Object[] o) {
        String key = null;
        this.println(":array { ");
        this.indent();
        int i = 0;
        while (i < o.length) {
            if (o[i] instanceof String) {
                this.printString((String)o[i]);
            } else {
                this.write(key, o[i]);
            }
            this.println(",");
            ++i;
        }
        this.outdent();
        this.println(" }");
    }

    protected void write(Object[][] o) {
        Object key = null;
        this.println(":table {");
        this.indent();
        int i = 0;
        while (i < o.length) {
            if (o[i][1] instanceof String) {
                this.print((String)o[i][0]);
                this.print("{");
                this.printString((String)o[i][1]);
                this.println("}");
            } else {
                this.write((String)o[i][0], o[i][1]);
                this.println("");
            }
            ++i;
        }
        this.outdent();
        this.println(" }");
    }

    protected void write(String tag, String value) {
        this.print(tag);
        this.print(" { ");
        this.printString(value);
        this.println(" }");
    }

    protected void write(String tag, String[] value) {
        if (tag != null) {
            this.print(tag);
            this.println(" { ");
        } else {
            this.println("{");
        }
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.printString(value[i]);
            this.println(",");
            ++i;
        }
        this.outdent();
        this.println("}");
    }

    protected void write2D(String tag, String[][] value) {
        this.print(tag);
        this.println(" { ");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write((String)null, value[i]);
            ++i;
        }
        this.outdent();
        this.println("}");
    }

    protected void writeTagged(String tag, Object[][] value) {
        this.print(tag);
        this.println(" { ");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write((String)value[i][0], value[i][1]);
            ++i;
        }
        this.outdent();
        this.println("}");
    }

    protected void writeTagged(String tag, String[][] value) {
        this.print(tag);
        this.println(" { ");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write(value[i][0], value[i][1]);
            ++i;
        }
        this.outdent();
        this.println("}");
    }

    protected void close() {
        this.outdent();
        this.println("}");
        super.closeFileHandle();
    }

    protected String getStringJoiningCharacter() {
        return "";
    }
}

