/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.CollationItem;
import com.ibm.icu.dev.tool.localeconverter.LocaleWriter;
import java.io.PrintStream;
import java.util.Locale;

public class ICU2LocaleWriter
extends LocaleWriter {
    public ICU2LocaleWriter(PrintStream out) {
        super(out);
    }

    public ICU2LocaleWriter(PrintStream out, PrintStream err) {
        super(out, err);
    }

    protected void open(Locale locale) {
        this.print(locale.toString());
        this.println(" {");
        this.indent();
    }

    protected void write(String tag, String value) {
        this.print(tag);
        this.print(" { ");
        this.printString(value);
        this.println(" }");
    }

    protected void write(String tag, String[] value) {
        if (tag != null) {
            this.print(tag);
            this.println(" { ");
        } else {
            this.println("{");
        }
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.printString(value[i]);
            this.println(",");
            ++i;
        }
        this.outdent();
        this.println("}");
    }

    protected void write(String tag, Object o) {
        if ("CollationElements".equals(tag)) {
            this.writeTagged(tag, (Object[][])o);
        } else if (!(o instanceof CollationItem[])) {
            super.write(tag, o);
        } else {
            CollationItem[] items = (CollationItem[])o;
            if (items[0] != null) {
                this.print("Sequence");
                this.println(" { ");
                int i = 0;
                while (i < items.length) {
                    if (items[i] != null) {
                        this.printString(items[i].toString());
                        if (items[i].comment != null) {
                            this.tabTo(30);
                            this.print("//");
                            this.println(items[i].comment);
                        }
                    }
                    ++i;
                }
                this.println("}");
            }
        }
    }

    protected void writeTagged(String tag, Object[][] value) {
        this.print(tag);
        this.println(" { ");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write((String)value[i][0], value[i][1]);
            ++i;
        }
        this.outdent();
        this.println("}");
    }

    protected void write2D(String tag, String[][] value) {
        this.print(tag);
        this.println(" { ");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write((String)null, value[i]);
            ++i;
        }
        this.outdent();
        this.println("}");
    }

    protected void writeTagged(String tag, String[][] value) {
        this.print(tag);
        this.println(" { ");
        this.indent();
        int i = 0;
        while (i < value.length) {
            this.write(value[i][0], value[i][1]);
            ++i;
        }
        this.outdent();
        this.println("}");
    }

    protected void close() {
        this.outdent();
        this.println("}");
    }

    protected String getStringJoiningCharacter() {
        return "";
    }

    protected boolean isEscapeChar(char c) {
        return true;
    }

    protected String getEscapeChar() {
        return "%u";
    }
}

