/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ComplexTransition;
import com.ibm.icu.dev.tool.localeconverter.EOLTransition;
import com.ibm.icu.dev.tool.localeconverter.Lex;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;

public class EscapeTransition
extends ComplexTransition {
    public static final EscapeTransition GLOBAL = new EscapeTransition(0x7FFFFFFE);
    public static final char DEFAULT_ESCAPE_CHAR = '\\';
    public static char ESCAPE_CHAR = (char)92;
    private static final int DECIMAL = 1;
    private static final int OCTAL = 2;
    private static final int HEX = 3;
    private static final int ESCAPE = 4;
    private static final int EOL = 5;
    private static final String OCTAL_CHARS = "01234567";
    private static final String DECIMAL_CHARS = "0123456789";
    private static final String HEX_CHARS = "0123456789abcdefABCDEF";
    private static Lex.Transition[][] theStates = null;

    public static synchronized char setDefaultEscapeChar() {
        return EscapeTransition.setEscapeChar('\\');
    }

    public static synchronized char setEscapeChar(char c) {
        char result = ESCAPE_CHAR;
        ESCAPE_CHAR = c;
        theStates = null;
        return result;
    }

    public EscapeTransition(int success) {
        super(success);
    }

    public boolean accepts(int c) {
        return ESCAPE_CHAR == (char)c;
    }

    protected void handleSuccess(Lex parser, StringBuffer output) throws IOException {
        switch (parser.getState()) {
            case 1: {
                output.append((char)parser.dataAsNumber(10));
                break;
            }
            case 2: {
                output.append((char)parser.dataAsNumber(8));
                break;
            }
            case 3: {
                output.append((char)parser.dataAsNumber(16));
                break;
            }
            case 4: {
                parser.appendDataTo(output);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new Lex.ParseException("Internal error parsing escape sequence");
            }
        }
    }

    protected Lex.Transition[][] getStates() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (theStates == null) {
                theStates = new Lex.Transition[][]{{new Lex.CharTransition(ESCAPE_CHAR, 1, -1), new Lex.ParseExceptionTransition("illegal escape character")}, {new Lex.EOFTransition(2), new Lex.CharTransition('d', 1, -3), new Lex.CharTransition('x', 1, -2), new Lex.StringTransition(OCTAL_CHARS, 0, -4), new Lex.CharTransition(ESCAPE_CHAR, 0, 4), new EOLTransition(5), new Lex.DefaultTransition(0, 4)}, {new Lex.EOFTransition(3), new Lex.StringTransition(HEX_CHARS, 0, -2), new Lex.DefaultTransition(17, 3)}, {new Lex.EOFTransition(1), new Lex.StringTransition(DECIMAL_CHARS, 0, -3), new Lex.DefaultTransition(17, 1)}, {new Lex.EOFTransition(2), new Lex.StringTransition(OCTAL_CHARS, 0, -4), new Lex.DefaultTransition(17, 2)}};
            }
        }
        return theStates;
    }

    public static void main(String[] args) {
        try {
            Lex.Transition[][] states = new Lex.Transition[][]{{new EscapeTransition(0x7FFFFFFE), new Lex.EOFTransition(), new Lex.ParseExceptionTransition("bad test input")}};
            String text = "\\d100\\xAf\\\\\\777\\\n\\123\\x2028\\x2029";
            StringReader sr = new StringReader(text);
            PushbackReader pr = new PushbackReader(sr);
            Lex parser = new Lex(states, pr);
            int s = parser.nextToken();
            while (s == 0x7FFFFFFE) {
                System.out.println(parser.getState());
                s = parser.nextToken();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

