/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ComplexTransition;
import com.ibm.icu.dev.tool.localeconverter.Lex;
import java.io.PushbackReader;
import java.io.StringReader;

public class EOLTransition
extends ComplexTransition {
    public static final String EOL_CHARS = "\f\r\n\u2028\u2029";
    public static final char DEFAULT_COMMENT_CHAR = '#';
    public static char COMMENT_CHAR = (char)35;
    public static final EOLTransition GLOBAL = new EOLTransition(0x7FFFFFFE);
    private static Lex.Transition[][] states;

    public static synchronized char setDefaultCommentChar() {
        return EOLTransition.setCommentChar('#');
    }

    public static synchronized char setCommentChar(char c) {
        char result = COMMENT_CHAR;
        COMMENT_CHAR = c;
        states = null;
        return result;
    }

    public EOLTransition(int success) {
        super(success);
    }

    public boolean accepts(int c) {
        return EOL_CHARS.indexOf((char)c) >= 0;
    }

    protected Lex.Transition[][] getStates() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (states == null) {
                states = new Lex.Transition[][]{{new Lex.StringTransition(EOL_CHARS, 1, -1), new Lex.EOFTransition(0x7FFFFFFE), new Lex.ParseExceptionTransition("bad characters in EOL")}, {new Lex.CharTransition(COMMENT_CHAR, 1, -2), new Lex.StringTransition(EOL_CHARS, 1, -1), new Lex.StringTransition(" \t", 1, -1), new Lex.EOFTransition(0x7FFFFFFE), new Lex.DefaultTransition(17, 0x7FFFFFFE)}, {new Lex.StringTransition(EOL_CHARS, 1, -1), new Lex.EOFTransition(0x7FFFFFFE), new Lex.DefaultTransition(1, -2)}};
            }
        }
        return states;
    }

    public static void main(String[] args) {
        try {
            Lex.Transition[][] states = new Lex.Transition[][]{{new EOLTransition(0x7FFFFFFE).debug(true), new Lex.EOFTransition(), new Lex.ParseExceptionTransition("bad test input")}};
            String text = "\n\r\n# Hello World\n\r\n\n\n\r\r\n#hello  kdsj\n";
            StringReader sr = new StringReader(text);
            PushbackReader pr = new PushbackReader(sr);
            Lex parser = new Lex(states, pr);
            parser.debug(true);
            int s = parser.nextToken();
            while (s == 0x7FFFFFFE) {
                s = parser.nextToken();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

