/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ICU2LocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.ICULocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.Java1LocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.JavaLocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.POSIXLocaleReader;
import com.ibm.icu.dev.tool.localeconverter.PosixCharMap;
import com.ibm.icu.dev.tool.localeconverter.SymbolTransition;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class ConvertPOSIXLocale {
    private static final short OPT_LC_CTYPE = 1;
    private static final short OPT_LC_TIME = 2;
    private static final short OPT_LC_NUMERIC = 4;
    private static final short OPT_LC_MONETARY = 8;
    private static final short OPT_LC_MESSAGES = 16;
    private static final short OPT_11 = 32;
    private static final short OPT_12 = 64;
    private static final short OPT_ICU = 128;
    private static final short OPT_ICU2 = 256;
    private static final short OPT_RAW = 512;
    private static final short OPT_UNKNOWN = 16384;
    private static final String[] USER_OPTIONS = new String[]{"-LC_CTYPE", "-LC_TIME", "-LC_NUMERIC", "-LC_MONETARY", "-LC_MESSAGES", "-11", "-12", "-icu", "-icu2", "-RAW", "-enc"};
    private static final short OPT_CONVERT = 31;
    private Hashtable data;

    public static void main(String[] args) {
        try {
            new ConvertPOSIXLocale(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("Unknown error: " + t);
        }
    }

    public ConvertPOSIXLocale(String[] args) {
        this.process(args);
    }

    public void process(String[] args) {
        short options = this.identifyOptions(args);
        String enc = null;
        if (args.length < 2 || (options & 0x4000) != 0) {
            this.printUsage();
        } else {
            Vector<String> mapFiles = new Vector<String>();
            Locale locale = null;
            String fileName = null;
            int i = 0;
            while (i < args.length) {
                String thisArg = args[i];
                if (thisArg.startsWith("-")) {
                    if (thisArg.startsWith("-enc")) {
                        enc = args[++i];
                    }
                } else if (locale == null) {
                    locale = this.localeFromString(thisArg);
                } else if (fileName == null) {
                    fileName = thisArg;
                } else {
                    mapFiles.addElement(thisArg);
                }
                ++i;
            }
            if (enc == null) {
                enc = "Default";
            }
            if (fileName == null || locale == null || options == 0) {
                this.printUsage();
            } else {
                PosixCharMap map = new PosixCharMap();
                Enumeration enumeration = mapFiles.elements();
                while (enumeration.hasMoreElements()) {
                    String mapFile = (String)enumeration.nextElement();
                    System.err.println("Locale: " + locale);
                    System.err.println("Loading character map file: " + mapFile);
                    try {
                        map.load(new File(mapFile), enc);
                    }
                    catch (IOException e) {
                        System.err.println("Error loading map file: " + mapFile + "  " + e);
                        System.err.println("File skipped");
                    }
                }
                SymbolTransition.setCharMap(map);
                File dataFile = new File(fileName);
                System.err.println("Locale directory: " + dataFile.getParent());
                POSIXLocaleReader reader = new POSIXLocaleReader(dataFile.getParent(), locale);
                System.err.println("Parsing file: " + dataFile.getName());
                try {
                    this.data = reader.parse(dataFile.getName(), (byte)(options & 0x1F));
                    System.err.println("Converting....");
                    if ((options & 0x20) != 0) {
                        new Java1LocaleWriter(System.out, System.err).write(locale, this.data);
                    }
                    if ((options & 0x40) != 0) {
                        new JavaLocaleWriter(System.out, System.err).write(locale, this.data);
                    }
                    if ((options & 0x80) != 0) {
                        new ICULocaleWriter(System.out, System.err).write(locale, this.data);
                    }
                    if ((options & 0x100) != 0) {
                        new ICU2LocaleWriter(System.out, System.err).write(locale, this.data);
                    }
                    if ((options & 0x200) != 0) {
                        new ICULocaleWriter(System.out, System.err).write(locale, this.data);
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
    }

    private void printUsage() {
        System.err.println("Usage: ConvertPOSIXLocale [-LC_CTYPE] [-LC_TIME] [-LC_NUMERIC] [-LC_MONETARY] [-LC_MESSAGES] [-11] [-12] [-icu] localeName localeDataFile [charMapFile ...]");
    }

    private short identifyOptions(String[] options) {
        short result = 0;
        int j = 0;
        while (j < options.length) {
            String option = options[j];
            if (option.startsWith("-")) {
                boolean optionRecognized = false;
                int i = 0;
                while (i < USER_OPTIONS.length) {
                    if (USER_OPTIONS[i].equals(option)) {
                        result = (short)(result | (short)(1 << i));
                        optionRecognized = true;
                        break;
                    }
                    i = (short)(i + 1);
                }
                if (!optionRecognized) {
                    result = (short)(result | 0x4000);
                }
            }
            ++j;
        }
        return result;
    }

    private Locale localeFromString(String localeName) {
        String language = localeName;
        String country = "";
        String variant = "";
        int ndx = language.indexOf(95);
        if (ndx >= 0) {
            country = language.substring(ndx + 1);
            language = language.substring(0, ndx);
        }
        if ((ndx = country.indexOf(95)) >= 0) {
            variant = country.substring(ndx + 1);
            country = country.substring(0, ndx);
        }
        if ((ndx = country.indexOf(64)) > 0) {
            variant = country.substring(ndx + 1);
            country = country.substring(0, ndx);
        }
        return new Locale(language, country, variant);
    }
}

