/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ICULocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.Java1LocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.JavaLocaleWriter;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ConvertJavaLocale {
    private static final byte OPT_11 = 1;
    private static final byte OPT_12 = 2;
    private static final byte OPT_ICU = 4;
    private static final byte OPT_PACKAGE = 8;
    private static final byte OPT_UNKNOWN = -128;
    private static final String[] USER_OPTIONS = new String[]{"-11", "-12", "-icu", "-package"};
    private static final String[] tags = new String[]{"LocaleString", "LocaleID", "ShortLanguage", "ShortCountry", "Languages", "Countries", "MonthNames", "MonthAbbreviations", "DayNames", "DayAbbreviations", "AmPmMarkers", "Eras", "NumberPatterns", "NumberElements", "CurrencyElements", "DateTimePatterns", "DateTimeElements", "CollationElements", "zoneStrings", "localPatternChars"};

    public static void main(String[] args) {
        try {
            new ConvertJavaLocale(args, System.out);
        }
        catch (Throwable t) {
            System.err.println("Unknown error: " + t);
        }
    }

    public ConvertJavaLocale(String[] args, PrintStream out) {
        this.process(args, out);
    }

    public void process(String[] args, PrintStream out) {
        short options = this.identifyOptions(args);
        if (args.length < 1 || (options & 0xFFFFFF80) != 0) {
            this.printUsage();
        } else {
            String localeName = null;
            String packagename = null;
            int i = 0;
            while (i < args.length) {
                String thisArg = args[i];
                if (args[i].equalsIgnoreCase("-package")) {
                    packagename = args[++i];
                } else if (!args[i].equalsIgnoreCase("-icu") && !args[i].startsWith("-")) {
                    localeName = args[i];
                }
                ++i;
            }
            Hashtable data = new Hashtable();
            String localeElements = packagename + ".LocaleElements" + (localeName != null ? "_" + localeName : "");
            String DateFormatZoneData = packagename + ".DateFormatZoneData" + (localeName != null ? "_" + localeName : "");
            this.addLocaleData(localeElements, data);
            this.addLocaleData(DateFormatZoneData, data);
            Locale locale = this.localeFromString(localeName);
            if ((options & 1) != 0) {
                new Java1LocaleWriter(out, System.err).write(locale, data);
            }
            if ((options & 2) != 0) {
                new JavaLocaleWriter(out, System.err).write(locale, data);
            }
            if ((options & 4) != 0) {
                new ICULocaleWriter(out, System.err).write(locale, data);
            }
        }
    }

    private void addLocaleData(String bundleClassName, Hashtable data) {
        try {
            Class<?> bundleClass = Class.forName(bundleClassName);
            ResourceBundle bundle = (ResourceBundle)bundleClass.newInstance();
            int i = 0;
            while (i < tags.length) {
                try {
                    Object resource = bundle.getObject(tags[i]);
                    data.put(tags[i], resource);
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not find bundle class for bundle: " + bundleClassName);
        }
        catch (InstantiationException e) {
            System.err.println("Could not create bundle instance for bundle: " + bundleClassName);
        }
        catch (IllegalAccessException e) {
            System.err.println("Could not create bundle instance for bundle: " + bundleClassName);
        }
    }

    private void printUsage() {
        System.err.println("Usage: ConvertJavaLocale [-11] [-12] [-icu] [-package] <package name> localeName");
    }

    private short identifyOptions(String[] options) {
        short result = 0;
        int j = 0;
        while (j < options.length) {
            String option = options[j];
            if (option.startsWith("-")) {
                boolean optionRecognized = false;
                int i = 0;
                while (i < USER_OPTIONS.length) {
                    if (USER_OPTIONS[i].equals(option)) {
                        result = (short)(result | (short)(1 << i));
                        optionRecognized = true;
                        break;
                    }
                    i = (short)(i + 1);
                }
                if (!optionRecognized) {
                    result = (short)(result | 0xFFFFFF80);
                }
            }
            ++j;
        }
        return result;
    }

    private Locale localeFromString(String localeName) {
        if (localeName == null) {
            return new Locale("", "", "");
        }
        String language = localeName;
        String country = "";
        String variant = "";
        int ndx = language.indexOf(95);
        if (ndx >= 0) {
            country = language.substring(ndx + 1);
            language = language.substring(0, ndx);
        }
        if ((ndx = country.indexOf(95)) >= 0) {
            variant = country.substring(ndx + 1);
            country = country.substring(0, ndx);
        }
        return new Locale(language, country, variant);
    }
}

