/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ICU3LocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.Java1LocaleWriter;
import com.ibm.icu.dev.tool.localeconverter.JavaLocaleWriter;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;

public class ConvertICUListResourceBundle {
    private static final byte OPT_11 = 1;
    private static final byte OPT_12 = 2;
    private static final byte OPT_ICU = 4;
    private static final byte OPT_PACKAGE = 8;
    private static final byte OPT_BUNDLE = 16;
    private static final byte OPT_UNKNOWN = -128;
    private static final String[] USER_OPTIONS = new String[]{"-11", "-12", "-icu", "-package", "-bundle-name"};

    public static void main(String[] args) {
        try {
            new ConvertICUListResourceBundle(args, System.out);
        }
        catch (Throwable t) {
            System.err.println("Unknown error: " + t);
        }
    }

    public ConvertICUListResourceBundle(String[] args, PrintStream out) {
        this.process(args, out);
    }

    public void process(String[] args, PrintStream out) {
        short options = this.identifyOptions(args);
        if (args.length < 1 || (options & 0xFFFFFF80) != 0) {
            this.printUsage();
        } else {
            String localeName = null;
            String packagename = null;
            String bundleName = null;
            int i = 0;
            while (i < args.length) {
                String thisArg = args[i];
                if (args[i].equalsIgnoreCase("-package")) {
                    packagename = args[++i];
                } else if (!args[i].equalsIgnoreCase("-icu")) {
                    if (!args[i].startsWith("-")) {
                        localeName = args[i];
                    } else if (args[i].equalsIgnoreCase("-bundle-name")) {
                        bundleName = args[++i];
                    }
                }
                ++i;
            }
            Hashtable data = new Hashtable();
            String localeElements = packagename + (bundleName != null ? "." + bundleName : ".LocaleElements") + (localeName != null ? "_" + localeName : "");
            String DateFormatZoneData = packagename + ".DateFormatZoneData" + (localeName != null ? "_" + localeName : "");
            this.addLocaleData(localeElements, data);
            Locale locale = localeName == null ? this.localeFromString("root") : this.localeFromString(localeName);
            if ((options & 1) != 0) {
                new Java1LocaleWriter(out, System.err).write(locale, data);
            }
            if ((options & 2) != 0) {
                new JavaLocaleWriter(out, System.err).write(locale, data);
            }
            if ((options & 4) != 0) {
                new ICU3LocaleWriter(this.getBundle(localeElements), out, System.err).write(locale);
            }
        }
    }

    private ListResourceBundle getBundle(String bundleClassName) {
        try {
            Class<?> bundleClass = Class.forName(bundleClassName);
            ListResourceBundle bundle = (ListResourceBundle)bundleClass.newInstance();
            return bundle;
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not find bundle class for bundle: " + bundleClassName);
        }
        catch (InstantiationException e) {
            System.err.println("Could not create bundle instance for bundle: " + bundleClassName);
        }
        catch (IllegalAccessException e) {
            System.err.println("Could not create bundle instance for bundle: " + bundleClassName);
        }
        return null;
    }

    private void addLocaleData(String bundleClassName, Hashtable data) {
        ListResourceBundle bundle = this.getBundle(bundleClassName);
        Enumeration<String> keys = ((ResourceBundle)bundle).getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object o = bundle.getObject(key);
            data.put(key, o);
        }
    }

    private void printUsage() {
        System.err.println("Usage: ConvertICUListResourceBundle [-11] [-12] [-icu] [-package] <package name> [-bundle-name] <bundle name> localeName");
    }

    private short identifyOptions(String[] options) {
        short result = 0;
        int j = 0;
        while (j < options.length) {
            String option = options[j];
            if (option.startsWith("-")) {
                boolean optionRecognized = false;
                int i = 0;
                while (i < USER_OPTIONS.length) {
                    if (USER_OPTIONS[i].equals(option)) {
                        result = (short)(result | (short)(1 << i));
                        optionRecognized = true;
                        break;
                    }
                    i = (short)(i + 1);
                }
                if (!optionRecognized) {
                    result = (short)(result | 0xFFFFFF80);
                }
            }
            ++j;
        }
        return result;
    }

    private Locale localeFromString(String localeName) {
        if (localeName == null) {
            return new Locale("", "", "");
        }
        String language = localeName;
        String country = "";
        String variant = "";
        int ndx = language.indexOf(95);
        if (ndx >= 0) {
            country = language.substring(ndx + 1);
            language = language.substring(0, ndx);
        }
        if ((ndx = country.indexOf(95)) >= 0) {
            variant = country.substring(ndx + 1);
            country = country.substring(0, ndx);
        }
        return new Locale(language, country, variant);
    }
}

